/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/12/1998 - avoided checking vg_name against LVM_PV_NEW
 *
 */

#include <liblvm.h>

int pv_check_new ( pv_t *pv) {
   int ret = FALSE;

#ifdef DEBUG
   debug ( "pv_check_new -- CALLED\n");
#endif

   if ( pv == NULL) ret = -LVM_EPARA;
   else if ( pv->vg_name[0] == 0 &&
             pv->pe_total == 0) ret = TRUE;

#ifdef DEBUG
   debug ( "pv_check_new -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
