/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

void stat_show ( struct stat *stat_b) {
#ifdef DEBUG
   debug ( "stat_show -- CALLED\n");
#endif

   if ( stat_b == NULL) return;

   printf ( "st_dev: %x\n", stat_b->st_dev);
   printf ( "st_ino: %lu\n", stat_b->st_ino);
   printf ( "st_mode: %x\n", stat_b->st_mode);
   printf ( "st_nlink: %d\n", stat_b->st_nlink);
   printf ( "st_uid: %d\n", stat_b->st_uid);
   printf ( "st_gid: %d\n", stat_b->st_gid);
   printf ( "st_rdev: %x\n", stat_b->st_rdev);
   printf ( "st_size: %lu\n", stat_b->st_size);
   printf ( "st_blksize: %lu\n", stat_b->st_blksize);
   printf ( "st_blocks: %lu\n", stat_b->st_blocks);
   printf ( "st_atime: %lu\n", stat_b->st_atime);
   printf ( "st_mtime: %lu\n", stat_b->st_mtime);
   printf ( "st_ctime: %lu\n", stat_b->st_ctime);

#ifdef DEBUG
   debug ( "stat_show -- LEAVING\n");
#endif
   return;
}
