/*
 * Author: Heinz Mauelshagen, Germany
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <lvm_user.h>

#ifdef DEBUG
int opt_d = 0;
#endif

int main ( int argc, char **argv)
{
   int c = 0;
   int opt_v = 0;
   int ret = 0;
   char *cmd = NULL;
#ifdef DEBUG
   char *options = "dh?v";
#else
   char *options = "h?v";
#endif
   char *vg_name = NULL;
   vg_t *vg = NULL;

   cmd = basename ( argv[0]);

   SUSER_CHECK;
   LVMTAB_CHECK;

   while ( ( c = getopt ( argc, argv, options)) != EOF) {
      switch ( c) {
#ifdef DEBUG
         case 'd':
            if ( opt_d > 0) {
               fprintf ( stderr, "%s -- d option yet given\n\n", cmd);
               return 1;
            }
            opt_d++;
            break;
#endif

         case 'h':
         case '?':
            printf ( "\n%s\n\n%s -- Volume group make nodes\n\n"
                     "Synopsis:\n"
                     "---------\n\n"
                     "%s\n"
#ifdef DEBUG
                     "\t[-d]\n"
#endif
                     "\t[-h/-?]\n"
                     "\t[-v]\n"
                     "\t[VolumeGroupName...]\n\n",
                     lvm_version, cmd, cmd);
            return 0;
            break;

         case 'v':
            if ( opt_v > 0) {
               fprintf ( stderr, "%s -- v option yet given\n\n", cmd);
               return 1;
            }
            opt_v++;
            break;

         default:
            fprintf ( stderr, "%s -- invalid command line option \"%c\"\n\n",
                      cmd, c);
            return 1;
      }
   }
  
   if ( optind == argc) {
      argv = lvm_tab_vg_check_exist_all_vg ();
      argc = optind = 0;
      if ( argv != NULL) while ( argv[argc] != NULL) argc++;
   }

   if ( argc == 0) {
      printf ( "%s -- no volume groups to create nodes for\n\n", cmd);
      return 0;
   }

   for ( ; optind < argc; optind++) {
      vg_name = argv[optind];
   
      if ( opt_v > 0) printf ( "%s -- checking volume group name\n", cmd);
      if ( vg_check_name ( vg_name) < 0) { 
         fprintf ( stderr, "%s -- invalid volume group name %s\n\n",
                           cmd, vg_name);
         return 1;
      }
      if ( strncmp ( vg_name, "/dev/", 5) == 0) vg_name += 5;
   
      if ( lvm_tab_vg_check_exist ( vg_name, &vg) != TRUE) {
         fprintf ( stderr, "%s -- volume group %s doesn't exist\n\n",
                           cmd, vg_name);
         return 1;
      }
   
      if ( opt_v > 0) printf ( "%s -- removing directory and nodes of %s\n",
                               cmd, vg_name);
      if ( ( ret = vg_remove_dir_and_group_and_nodes ( vg_name)) < 0) {
         fprintf ( stderr, "%s -- ERROR %d: removing volume group "
                           "nodes of %s\n\n",
                           cmd, ret, vg_name);
         return 1;
      }
   
      if ( ( ret = vg_create_dir_and_group_and_nodes ( vg, cmd, opt_v)) < 0) {
         fprintf ( stderr, "%s -- ERROR %d: creating volume group "
                           "nodes of %s\n\n",
                           cmd, ret, vg_name);
         return 1;
      }
   
      printf ( "%s -- successfully made all nodes of volume group %s\n",
               cmd, vg_name);
   }

   printf ( "\n");
   return 0;
}
