/*
 * Author: Heinz Mauelshagen, Germany
 *
 * February-May 1997
 *
 * lvm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * lvm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#ifndef _LVM_KERNEL_H_INCLUDE
#define _LVM_KERNEL_H_INCLUDE

#define	DEVICE_REQUEST do_request

#include <lvm_version.h>

#ifdef MODULE
static int init_module ( void);
#else
static int lvm_init ( void);
#endif

#define	suser()	( current->uid == 0 && current->euid == 0)

static void cleanup_module ( void);

static int	lvm_MajorNumber = LVM_MAJOR;

/* do we have to have seek?
static int  lvm_blk_seek  ( struct inode *, struct file *, off_t, int);
*/
static int  lvm_blk_ioctl ( struct inode *, struct file *, unsigned int,
                            unsigned long);
static int  lvm_blk_open  ( struct inode *, struct file *);

static int  lvm_chr_open  ( struct inode *, struct file *);

#if LINUX_VERSION_CODE >= KERNEL_VERSION ( 2, 1, 0)
static int lvm_chr_close ( struct inode *, struct file *);
static int lvm_blk_close ( struct inode *, struct file *);
#else
static void lvm_chr_close ( struct inode *, struct file *);
static void lvm_blk_close ( struct inode *, struct file *);
#endif

static int  lvm_chr_ioctl ( struct inode *, struct file *, unsigned int,
                            unsigned long);

#if defined LVM_CONFIG_PROC_FS && defined CONFIG_PROC_FS
static int lvm_proc_get_info ( char *, char **, off_t, int, int);
#endif

static void lvm_init_vars ( void);

extern int  (*lvm_map_ptr) ( int, kdev_t *, unsigned long *,
                             unsigned long, int);
static int  lvm_map ( int, kdev_t *, unsigned long *, unsigned long, int);

static void do_request (void);

static int do_vg_remove ( int);

static int do_lv_create ( int, char *, lv_t *, struct inode *);
static int do_lv_remove ( int, char *);
static int do_lv_extend_reduce ( int, char *, lv_t *, struct inode *);

static void lvm_geninit ( struct gendisk *);
static struct inode *lvm_get_inode ( int);

static void lvm_memcpy ( char *, char *, int);
static int  lvm_strcmp ( char *, char *);
static char *lvm_strrchr ( char *, char c);
#endif /* #ifndef _LVM_KERNEL_H_INCLUDE */
