/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March-May,November 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/17/1998 - fixed allocation bug with striped logical volumes
 *
 */

#include <liblvm.h>

int lv_setup_for_extend ( char *vg_name, vg_t *vg, char *lv_name,
                          uint size, char **pv_allowed) {
   int i = 0;
   int j = 0;
   int l = 0;
   int p = 0;
   int pa = 0;
   int ret = 0;
   int s = 0;
   uint dest = 0;
   uint old_le = 0;
   uint pe = 0;
   uint pe_last = 0;
   uint pe_this = 0;
   uint pv_index = 0;
   uint source = 0;
   int stripes = 0;
   pe_t *pe_p = NULL;
   disk_pe_t lv_pe = { 0, 0};

#ifdef DEBUG
   debug ( "lv_setup_for_extend -- CALLED\n");
#endif

   if ( vg_name == NULL || vg == NULL || lv_name == NULL ||
        vg_check_name ( vg_name) < 0 || size == 0 ||
        lv_check_name ( lv_name) < 0) return -LVM_EPARAM;

   if ( ( l = lv_get_index_by_name ( vg, lv_name)) < 0)
      return -LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX;

   /* extend LVs PE structures */
   old_le = vg->lv[l]->lv_allocated_le;
#ifdef DEBUG
   debug ( "lv_setup_for_extend -- OLD vg->lv[%d]->lv_allocated_le: %lu  "
            "vg->lv[%d]->lv_current_le: %lu\n",
            l, vg->lv[l]->lv_allocated_le, l, vg->lv[l]->lv_current_le);
#endif

   /* new size */
   vg->lv[l]->lv_allocated_le = vg->lv[l]->lv_current_le = size / vg->pe_size;
   vg->lv[l]->lv_size = size;

   stripes = vg->lv[l]->lv_stripes;
   if ( ( pe = vg->lv[l]->lv_allocated_le - old_le) >
        vg->pe_total - vg->pe_allocated) return -LVM_ESIZE;

   vg->pe_allocated += pe;

   /* reallocation for larger size */
   if ( ( vg->lv[l]->lv_current_pe =
          realloc ( vg->lv[l]->lv_current_pe,
                    vg->lv[l]->lv_allocated_le *
                    sizeof ( pe_t))) == NULL) {
      fprintf ( stderr, "realloc error in %s [line %d]\n",
                        __FILE__, __LINE__);
      return -LVM_ELV_SETUP_FOR_EXTEND_REALLOC;
   }

   /* initialize to 0 */
   for ( i = old_le; i < vg->lv[l]->lv_allocated_le; i++) {
      vg->lv[l]->lv_current_pe[i].dev = vg->lv[l]->lv_current_pe[i].pe = 0;
   }

#ifdef DEBUG
   if ( opt_d > 0) {
      printf ( "lv_setup_for_extend -- AFTER realloc\n");
      printf ( "pe: %u  stripes: %d  vg->pe_total: %u  "
               "vg->pe_allocated: %u\n",
               pe, stripes, vg->pe_total, vg->pe_allocated);
      printf ( "NEW vg->lv[%d]->lv_allocated_le: %u\n",
               l, vg->lv[l]->lv_allocated_le);
   }
#endif

   p = 0;
   /* linear mapping */
   if ( stripes < 2) {
      stripes = 1;
      /* walk through physical volumes searching for physical extends */
      while ( p < vg->pv_cur && pe > 0) {
         /* check for restricted physical volume list */
         if ( pv_allowed != NULL) {
            for ( pa = 0; pv_allowed[pa] != NULL; pa++) {
               if ( strcmp ( vg->pv[p]->pv_name, pv_allowed[pa]) == 0) break;
            }
            if ( pv_allowed[pa] == NULL) {
               p++;
               continue;
            }
         }
         if ( vg->pv[p]->pe_total - vg->pv[p]->pe_allocated == 0 ||
              ! ( vg->pv[p]->pv_allocatable & PV_ALLOCATABLE)) {
#ifdef DEBUG
            debug ( "lv_setup_for_extend -- %s NOT allocatable\n",
                      vg->pv[p]->pv_name);
#endif
            p++;
            continue;
         }

	 pe_last = pe;
         pe_p = &vg->lv[l]->lv_current_pe[vg->lv[l]->lv_allocated_le-pe];
#ifdef DEBUG
         debug ( "lv_setup_for_extend -- BEFORE pv_reserve_pe: "
                  "vg->lv[%d]->lv_allocated_le-pe: %lu  "
                  "vg->pv[%d]->lv_cur: %lu\n",
                  l, vg->lv[l]->lv_allocated_le-pe, p, vg->pv[p]->lv_cur);
#endif

         /* check for new LV on this PV */
         if ( lv_check_on_pv ( vg->pv[p], l + 1) != TRUE) vg->pv[p]->lv_cur++;

         lv_pe.lv_num = l + 1;
         lv_pe.le_num = vg->lv[l]->lv_allocated_le - pe;
         if ( ( ret = pv_reserve_pe ( vg->pv[p], &lv_pe, &pe,
                                      pe_p, vg->lv[l]->lv_allocation,
                                      FALSE)) < 0)
             return -LVM_ESIZE;
#ifdef DEBUG
         debug ( "lv_setup_for_extend -- AFTER pv_reserve_pe  "
                 "vg->pv[%d]->lv_cur: %lu\n", p,  vg->pv[p]->lv_cur);
         debug ( "lv_setup_for_extend -- pe: %u  pe_last: %u\n", pe, pe_last);
         debug ( "lv_setup_for_extend --pv_reserve_pe returned: %d   "
                 "pe_last: %d  pe: %d\n", ret, pe_last, pe);
#endif
         if ( pe == pe_last) return -LVM_ESIZE;
         p++;
      }

   /* striped mapping */
   } else {
      if ( pe % stripes > 0) return -LVM_ELV_SETUP_FOR_EXTEND_STRIPES;
      pe_last = pe / stripes;
      s = stripes;
      for ( i = stripes - 1; i > 0; i--) {
         for ( j = old_le / stripes - 1; j >= 0; j--) {
            source = i * ( old_le / stripes) + j;
            dest = i * ( vg->lv[l]->lv_allocated_le / stripes) + j;
            vg->lv[l]->lv_current_pe[dest].dev =
               vg->lv[l]->lv_current_pe[source].dev;
            vg->lv[l]->lv_current_pe[dest].pe =
               vg->lv[l]->lv_current_pe[source].pe;
            pv_index = pv_get_index_by_kdev_t ( vg, vg->lv[l]->lv_current_pe[dest].dev);
            vg->pv[pv_index]->pe[(vg->lv[l]->lv_current_pe[dest].pe-(vg->pv[pv_index]->pe_on_disk.base+vg->pv[pv_index]->pe_on_disk.size)/SECTOR_SIZE)/vg->pe_size].le_num = dest;
            vg->lv[l]->lv_current_pe[source].dev = \
            vg->lv[l]->lv_current_pe[source].pe = 0;
         }
      }

      /* walk through physical volumes searching for physical extends */
      while ( p < vg->pv_cur && s > 0) {
         /* match PV of a stripe of this LV */
         if ( vg->lv[l]->lv_current_pe\
              [(stripes-s)*vg->lv[l]->lv_allocated_le/stripes].dev ==
              vg->pv[p]->pv_dev) {
            if ( ! ( vg->pv[p]->pv_allocatable & PV_ALLOCATABLE))
               return -LVM_ESIZE;
            if ( pe_last <= vg->pv[p]->pe_total - vg->pv[p]->pe_allocated) {
               pe_this = pe_last;
#ifdef DEBUG
               debug ( "lv_setup_for_extend -- pe_this: %d\n", pe_this);
#endif
               lv_pe.lv_num = l + 1;
               lv_pe.le_num = (stripes - s + 1) *
                              (vg->lv[l]->lv_allocated_le/stripes) - pe_this;
               pe_p = &vg->lv[l]->lv_current_pe[lv_pe.le_num];
               if ( ( ret = pv_reserve_pe ( vg->pv[p], &lv_pe,
                                            &pe_this, pe_p,
                                            vg->lv[l]->lv_allocation,
                                            FALSE)) < 0)
                  return -LVM_ESIZE;
               if ( pe_this == 0) {
                  pe -= pe_last;
                  s--;
               } else return -LVM_ESIZE;
            } else return -LVM_ESIZE;
            p = -1;
         }
         p++;
      }
   }

#ifdef DEBUG
   debug ( "lv_setup_for_extend -- pe: %d\n", pe);
#endif
   if ( pe != 0) return -LVM_ESIZE;

   return 0;
}
