/*
 * Author: Heinz Mauelshagen, Germany (mge@ez-darmstadt.telekom.de)
 *
 * November 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/16/1998 - added errror return code for ordinary file existing
 *                 instead of directory
 *
 */

#include <liblvm.h>

int vg_cfgrestore ( char *vg_name, char *vg_backup_path,
                    int opt_v, vg_t *vg) {
   int l = 0;
   int p = 0;
   int ret = 0;
   int vg_backup = -1;
   char directory[NAME_LEN] = { 0, };
   struct stat stat_buf;

#ifdef DEBUG
   debug ( "vg_cfgrestore -- CALLED\n");
#endif

   if ( vg_name == NULL || vg_backup_path == NULL ||
        strchr ( vg_backup_path, '/') == NULL ||
        opt_v < 0 || vg == NULL ||
        vg_check_name ( vg_name) < 0) return -LVM_EPARAM;

   strncpy ( directory, vg_backup_path, sizeof ( directory) - 1);
   directory[ sizeof ( directory) - 1] = 0;
   *(strrchr ( directory, '/')) = 0;

   if ( stat ( directory, &stat_buf) == 0) {
      if ( ! S_ISDIR ( stat_buf.st_mode)) {
         fprintf ( stderr, "%s -- ERROR: file %s exists; must be directory\n",
                   cmd, directory);
         ret = -LVM_EVG_CFGRESTORE_FILE_EXISTS;
         goto vg_cfgrestore_end;
      }
   }

   if ( opt_v > 0) printf ( "%s -- checking existence of %s\n",
                            cmd, vg_backup_path);
   if ( ( vg_backup = open ( vg_backup_path, O_RDONLY)) == -1) {
      fprintf ( stderr, "%s -- %s doesn't exist\n", cmd, vg_backup_path);
      ret = -LVM_EVG_CFGRESTORE_OPEN;
      goto vg_cfgrestore_end;
   }

   if ( opt_v > 0) printf ( "%s -- reading volume group data for %s "
                            "out of %s\n",
                            cmd, vg_name, vg_backup_path);

   VGCFG_READ ( vg_backup, vg, sizeof ( vg_t), vg_backup_path);

   if ( vg_check_consistency ( vg) < 0) {
      ret = -LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY;
      goto vg_cfgrestore_end;
   }

   if ( opt_v > 0) printf ( "%s -- reading physical volume data for %s "
                            "from %s\n",
                            cmd, vg_name, vg_backup_path);
   for ( p = 0; p < vg->pv_cur; p++) {
      if ( ( vg->pv[p] = malloc ( sizeof ( pv_t))) == NULL) {
         fprintf ( stderr, "%s -- malloc error in file %s [line %d]\n",
                           cmd, __FILE__, __LINE__);
         ret = -LVM_EVG_CFGRESTORE_MALLOC;
         goto vg_cfgrestore_end;
      }
      VGCFG_READ ( vg_backup, vg->pv[p], sizeof ( pv_t), vg_backup_path);
      if ( pv_check_consistency ( vg->pv[p]) < 0) {
         ret = -LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY;
         goto vg_cfgrestore_end;
      }
      if ( ( vg->pv[p]->pe =
                malloc ( vg->pv[p]->pe_total * sizeof ( disk_pe_t))) == NULL) {
         fprintf ( stderr, "%s -- malloc error in file %s [line %d]\n",
                           cmd, __FILE__, __LINE__);
         ret = -LVM_EVG_CFGRESTORE_MALLOC;
         goto vg_cfgrestore_end;
      }
      VGCFG_READ ( vg_backup, vg->pv[p]->pe,
                              vg->pv[p]->pe_total * sizeof ( disk_pe_t),
                              vg_backup_path);
   }

   if ( opt_v > 0) printf ( "%s -- reading logical volume data for %s "
                            "from %s\n",
                            cmd, vg_name, vg_backup_path);
   for ( l = 0; l < vg->lv_max; l++) {
      if ( ( vg->lv[l] = malloc ( sizeof ( lv_t))) == NULL) {
         fprintf ( stderr, "%s -- malloc error in file %s [line %d]\n",
                           cmd, __FILE__, __LINE__);
         ret = -LVM_EVG_CFGRESTORE_MALLOC;
         goto vg_cfgrestore_end;
      }
      VGCFG_READ ( vg_backup, vg->lv[l], sizeof ( lv_t), vg_backup_path);
      if ( vg->lv[l]->lv_name[0] != 0 &&
           lv_check_consistency ( vg->lv[l]) < 0) {
         ret = -LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY;
         goto vg_cfgrestore_end;
      }

      if ( lv_check_consistency ( vg->lv[l]) < 0) {
         free ( vg->lv[l]);
         vg->lv[l] = NULL;
      } else {
         if ( ( vg->lv[l]->lv_current_pe =
                   malloc ( vg->lv[l]->lv_allocated_le * \
                            sizeof ( pe_t))) == NULL) {
            fprintf ( stderr, "%s -- malloc error in file %s [line: %d]\n",
                              cmd, __FILE__, __LINE__);
            ret = -LVM_EVG_CFGRESTORE_MALLOC;
            goto vg_cfgrestore_end;
         }
         VGCFG_READ ( vg_backup, vg->lv[l]->lv_current_pe,
                                 vg->lv[l]->lv_allocated_le * sizeof ( pe_t),
                                 vg_backup_path);
      }
   }

   if ( vg_check_consistency_with_pv_and_lv ( vg) < 0)
      ret = -LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV;

vg_cfgrestore_end:
   if ( vg_backup != -1) close ( vg_backup);

#ifdef DEBUG
   debug ( "vg_cfgrestore -- LEAVING\n");
#endif
   return ret;
}
