/*
 * Author: Heinz Mauelshagen, Germany
 *
 * April 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int vg_extend_reduce ( char *, pv_t *, vg_t *, int);


int vg_extend ( char *vg_name, pv_t *pv, vg_t *vg) {
   return vg_extend_reduce ( vg_name, pv, vg, VG_EXTEND);
}


int vg_reduce ( char *vg_name, pv_t *pv, vg_t *vg) {
   return vg_extend_reduce ( vg_name, pv, vg, VG_REDUCE);
}


int vg_extend_reduce ( char *vg_name, pv_t *pv, vg_t *vg, int cr) {
   int group = -1;
   int ret = 0;
   char group_file[NAME_LEN];

#ifdef DEBUG
   debug ( "vg_extend_reduce -- CALLED\n");
#endif

   if ( vg_name == NULL ||
        vg_check_name ( vg_name) < 0 ||
        pv == NULL ||
        vg == NULL ||
        pv_check_consistency ( pv) < 0 ||
        vg_check_consistency_with_pv_and_lv ( vg) < 0) return -LVM_EPARAM;

   sprintf ( group_file, "/dev/%s/group%c", vg_name, 0);
   if ( ( group = open ( group_file, O_RDWR)) == -1)
      ret = -LVM_EVG_EXTEND_REDUCE_OPEN;
   else {
#ifdef DEBUG
      debug ( "vg_extend_reduce -- IOCTL\n");
#endif
      if ( cr == VG_EXTEND) ret = ioctl ( group, cr, pv);
      else                  ret = ioctl ( group, cr, pv->pv_name);
      if ( ret == -1) ret = -errno;
   }

   if ( group != -1) close ( group);
#ifdef DEBUG
   debug ( "vg_extend_reduce -- IOCTL returned: %d\n", ret);
#endif
   if ( ret == 0 && cr == VG_REDUCE)
      ret = pv_change_all_pv_of_vg ( vg_name, vg);

#ifdef DEBUG
   debug ( "vg_extend_reduce -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
