/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int vg_write ( char *pv_name, pv_t *pv, vg_t *vg) {
   int pv_handle = -1;
   int ret  = 0;

#ifdef DEBUG
   debug ( "vg_write -- CALLED  storing %s on %s\n", vg->vg_name, pv_name);
#endif

   if ( pv_name == NULL ||
        pv_check_name ( pv_name) < 0 ||
        vg == NULL ||
        vg_check_name ( vg->vg_name) < 0) return -LVM_EPARAM;

   if ( ( pv_handle = open ( pv_name, O_WRONLY)) == -1)
      ret = -LVM_EVG_STORE_OPEN;
   else if ( lseek ( pv_handle, pv->vg_on_disk.base, SEEK_SET) !=
                     pv->vg_on_disk.base)
      ret = -LVM_EVG_STORE_LSEEK;
   else if ( write ( pv_handle, vg, sizeof ( vg_t)) != sizeof ( vg_t))
      ret = -LVM_EVG_STORE_WRITE;

   if ( pv_handle != -1) {
      fsync ( pv_handle);
      close ( pv_handle);
   }

#ifdef DEBUG
   debug ( "vg_write -- LEAVING\n");
#endif
   return ret;
}


int vg_write_with_pv_and_lv ( vg_t *vg) {
   int p = 0;
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_write_with_pv_and_lv -- CALLED\n");
#endif

   if ( vg == NULL ||
        vg_check_name ( vg->vg_name) < 0) return -LVM_EPARAM;

   for ( p = 0; p < vg->pv_cur; p++) {
#ifdef DEBUG
      debug ( "vg_write_with_pv_and_lv -- BEFORE vg_write of %s\n",
               vg->pv[p]->pv_name);
#endif
      if ( ( ret = vg_write ( vg->pv[p]->pv_name, vg->pv[p], vg)) != 0) break;
      else if ( ( ret = pv_write_with_pe ( vg->pv[p]->pv_name,
                  vg->pv[p])) != 0) break;
      else if ( ( ret = pv_write_namelist ( vg->pv[p]->pv_name, vg)) != 0)
         break;
      else if ( ( ret = lv_write_all_lv_of_vg ( vg->pv[p]->pv_name, vg))
                != 0) break;
   }

#ifdef DEBUG
   debug ( "vg_write_with_pv_and_lv -- LEAVING\n");
#endif
   return ret;
}
