/*
 * Author: Heinz Mauelshagen, Germany
 *
 * March 1997
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    05/16/1998 - added macro LVMTAB_CHECK
 *
 */

#ifndef _LVM_USER_H_INCLUDE
#define _LVM_USER_H_INCLUDE

#include <liblvm.h>
#include <lvm_version.h>

#include <ctype.h>
#include <fcntl.h>
#include <malloc.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/ioctl.h>
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,0,1)
#  define _I386_STAT_H
#endif
#include <sys/stat.h>
#include <linux/genhd.h>
#include <linux/major.h>
#include <linux/msdos_fs.h>
#include <lvm.h>

#define	SUSER_CHECK { \
   if ( ! ( getuid () == 0 && geteuid () == 0)) { \
      fprintf ( stderr, "%s -- this command is for root only\n\n", cmd); \
      return 1; \
   } \
}

#define	LVMTAB_CHECK { \
   int lvmtab = -1; \
   if ( open ( LVMTAB, O_RDONLY) == -1) { \
      fprintf ( stderr, "%s -- %s doesn't exist; please run vgscan\n\n", \
                        cmd, LVMTAB); \
      return 1; \
   } \
   if ( lvmtab != -1) close ( lvmtab); \
   if ( open ( LVMTAB_DIR, O_RDONLY) == -1) { \
      fprintf ( stderr, "%s -- %s doesn't exist; please run vgscan\n\n", \
                        cmd, LVMTAB_DIR); \
      return 1; \
   } \
   if ( lvmtab != -1) close ( lvmtab); \
}

#define LVM_CHECK_IOP { \
   if ( lvm_get_iop_version () != LVM_IOP_VERSION) { \
      fprintf ( stderr, "%s -- invalid i/o protocol version\n\n", cmd); \
      return 1; \
   } \
}

#define	LVM_LOCK( level) { \
   if ( opt_v > level) printf ( "%s -- locking logical volume manager\n", cmd); \
   if ( ( ret = lvm_lock ()) < 0) { \
      if ( ret == -ENOENT) { \
         fprintf ( stderr, "%s -- no such file or directory while " \
                           "locking logical volume manager\n" \
                           "%s -- does %s (Char special; Major: %d, Minor: 0)" \
                           "exist?\n\n", \
                           cmd, cmd, LVM_DEV, LVM_MAJOR); \
         return 1; \
      } else if ( ret == -ENODEV) \
         fprintf ( stderr, "%s -- no such device while locking logical " \
                           "volume manager\n", cmd); \
      else if ( ret == -LVM_ELVM_LOCK_YET_LOCKED) { \
         fprintf ( stderr, "%s -- logical volume manager yet locked\n", cmd); \
         return 1; \
      } else \
         fprintf ( stderr, "%s -- ERROR %d locking logical volume manager\n", \
                           cmd, ret); \
      fprintf ( stderr, "%s -- LVM not in kernel/loaded?\n\n", cmd); \
      return 1; \
   }; \
}

#define	LVM_UNLOCK( level) { \
   if ( opt_v > level) printf ( "%s -- unlocking logical volume manager\n", cmd); \
   lvm_unlock (); \
}

#endif /* #ifndef _LVM_USER_H_INCLUDE */


/* return codes of the tools */
#define	VGDISPLAY_NOVG	1
