/*
 * tools/e2fsadm.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * June,September 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU CC; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    09/04/1998 - corrected some messages
 *
 */

#include <lvm_user.h>
/*
#include <sys/vfs.h>
#include <linux/ext2_fs.h>
*/

char *cmd = NULL;

#ifdef DEBUG
int opt_d = 0;
#endif

static char *bin_dirs[] = { "/sbin", "/usr/sbin", "/bin", "/usr/bin", NULL};
char *lvm_find_command ( char *);
void lvm_path_error ( char *, char *);
int lvm_is_ext2_fs ( char *);


int main ( int argc, char **argv) {
   int c = 0;
   int grow = UNDEF;
   int l = 0;
   int len = 0;
   int opt_l = 0;
   int opt_L = 0;
   int opt_n = 0;
   int opt_t = 0;
   int opt_v = 0;
   int ret = 0;
   int sign = 0;
   ulong size = 0;
   char size_option = 0;
   char *cmd_fsck = "e2fsck";
   char *cmd_resize = "resize2fs";
   char *cmd_extend = "lvextend";
   char *cmd_ptr = NULL;
   char *cmd_reduce = "lvreduce";
   char *dummy = NULL;
   char *lv_name = NULL;
   char *mount = NULL;
   char *vg_name = NULL;
   char *proc_mounts = "/proc/mounts";
   char *ptr = NULL;
   char *size_ptr = NULL;
   char buffer[2*NAME_LEN] = { 0, };
   char command[2*NAME_LEN] = { 0, };
#ifdef DEBUG
   char *options = "dh?L:l:ntv";
#else
   char *options = "h?L:l:ntv";
#endif
   FILE *proc = NULL;
   lv_t *lv = NULL;
   vg_t *vg = NULL;


   cmd = basename ( argv[0]);

   SUSER_CHECK;
   LVMTAB_CHECK;

   while ( ( c = getopt ( argc, argv, options)) != EOF) {
      switch ( c) {
#ifdef DEBUG
         case 'd':
            if ( opt_d > 0) {
               fprintf ( stderr, "%s -- d option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_d++;
            break;
#endif

         case 'h':
         case '?':
            printf ( "\n%s\n\n%s -- ext2 Filesystem and LVM Administration\n\n"
                     "Synopsis:\n"
                     "---------\n\n"
                     "%s\n"
#ifdef DEBUG
                     "\t[-d]\n"
#endif
                     "\t[-h/?]\n"
                     "\t{ -l [+/-]LogicalExtentsNumber |\n"
                     "\t  -L [+/-]LogicalVolumeSize}\n"
                     "\t[-n]\n"
                     "\t[-t]\n"
                     "\t[-v]\n"
                     "\tLogicalVolumePath\n\n",
                     lvm_version, cmd, cmd);
            return 0;
            break;

         case 'l':
            if ( opt_L > 0) {
               fprintf ( stderr, "%s -- L option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            if ( opt_l > 0) {
               fprintf ( stderr, "%s -- l option already given\n\n", cmd);
               return 1;
            }
            size_ptr = optarg;
            opt_l++;
            break;

         case 'L':
            if ( opt_l > 0) {
               fprintf ( stderr, "%s -- l option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            if ( opt_L > 0) {
               fprintf ( stderr, "%s -- L option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            size_ptr = optarg;
            opt_L++;
            break;

         case 'n':
            if ( opt_n > 0) {
               fprintf ( stderr, "%s -- n option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_n++;
            break;

         case 't':
            if ( opt_t > 0) {
               fprintf ( stderr, "%s -- t option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_t++;
            break;

         case 'v':
            if ( opt_v > 0) {
               fprintf ( stderr, "%s -- v option already given\n\n", cmd);
               return LVM_EINVALID_CMD_LINE;
            }
            opt_v++;
            break;

         default:
            fprintf ( stderr, "%s -- invalid command line option \"%c\"\n",
                      cmd, c);
            return LVM_EINVALID_CMD_LINE;
      }
   }

   CMD_MINUS_CHK;

   if ( lvm_find_command ( cmd_resize) == NULL) {
      lvm_path_error ( cmd_resize, "resize");
      return LVM_EE2FSADM_RESIZE_PATH;
   }

   if ( opt_l == 0 && opt_L == 0) {
      fprintf ( stderr, "%s -- please give either an l or an L option\n\n",
                        cmd);
      return LVM_EINVALID_CMD_LINE;
   }

   if ( lvm_check_number ( size_ptr) == FALSE) {
      fprintf ( stderr, "%s -- invalid size \"%s\" for the filesystem\n\n",
                        cmd, size_ptr);
      return LVM_EE2FSADM_FSSIZE;
   }

   if ( optind != argc - 1) {
      fprintf ( stderr, "%s -- please give a logical volume name\n\n",
                        cmd);
      return LVM_EE2FSADM_LV_MISSING;
   }

   lv_name = argv[optind];

   if ( opt_t > 0) printf ( "%s -- this is a test run and no real resize\n",
                            cmd);

   if ( opt_v > 0) printf ( "%s -- checking logical volume name\n", cmd);
   if ( lv_check_name ( lv_name) < 0) {
      fprintf ( stderr, "%s -- invalid logical volume name \"%s\"\n\n",
                        cmd, lv_name);
      return LVM_EE2FSADM_LVNAME;
   }

   if ( opt_v > 0) printf ( "%s -- checking for relative/absolute "
                            "size change\n", cmd);
   if ( opt_l > 0) size_option = 'l';
   else            size_option = 'L';

   if ( *size_ptr == '+') {
      sign = +1;
      size_ptr++;
   } else if ( *size_ptr == '-') {
      sign = -1;
      size_ptr++;
   }

   if ( lvm_check_number ( size_ptr) == FALSE) {
      fprintf ( stderr, "%s -- invalid filesystem size \"%s\"\n\n",
                        cmd, size_ptr);
      return LVM_EE2FSADM_FSSIZE;
   }

   if ( opt_v > 0) printf ( "%s -- checking logical volume \"%s\" existance\n",
                            cmd, lv_name);
   if ( lvm_tab_lv_check_exist ( lv_name) < 0) {
      fprintf ( stderr, "%s -- logical volume \"%s\" doesn't exist\n\n",
                        cmd, lv_name);
      return LVM_EE2FSADM_LV_EXIST;
   }

   vg_name = vg_name_of_lv ( lv_name);

   if ( opt_v > 0) printf ( "%s -- reading VGDA of volume group \"%s\" from "
                            "lvmtab\n", cmd, vg_name);
   if ( ( ret = lvm_tab_vg_read_with_pv_and_lv ( vg_name, &vg)) < 0) {
      fprintf ( stderr, "%s -- ERROR reading VGDA of \"%s\" from lvmtab\n\n",
                        cmd, vg_name);
      return LVM_EE2FSADM_VG_READ;
   }

   l = lv_get_index_by_name ( vg, lv_name);
   size = atol ( size_ptr);

   /* make size absolute */
   if ( opt_v > 0) printf ( "%s -- calculating absolute logical volume size\n",
                            cmd);
   if ( opt_L) size *= 2048;
   else        size *= vg->pe_size;
   if ( sign == 0) {
      if ( size < vg->lv[l]->lv_size) grow = FALSE;
      else if ( size > vg->lv[l]->lv_size) grow = TRUE;
      else {
         fprintf ( stderr, "%s -- size of \"%s\" doesn't change\n\n",
                           cmd, lv_name);
         return LVM_EE2FSADM_FSSIZE_CHANGE;
      }
   } else if ( sign == 1) {
      size += vg->lv[l]->lv_size;
      grow = TRUE;
   } else {
      size = vg->lv[l]->lv_size - size;
      grow = FALSE;
   }

   if ( opt_v > 0) printf ( "%s -- checking size modulo PE size\n", cmd);
   if ( size % vg->pe_size != 0) {
      printf ( "%s -- correcting size %s to physical extent boundary ",
               cmd, ( dummy = lvm_show_size ( size / 2, SHORT)));
      free ( dummy);
      size += vg->pe_size + ( size % vg->pe_size);
      printf ( "%s\n", ( dummy = lvm_show_size ( size / 2, SHORT)));
      free ( dummy); dummy = NULL;
   }

   if ( ( proc = fopen ( proc_mounts, "r")) == NULL) {
      fprintf ( stderr, "%s -- ERROR: can't open \"%s\"\n\n",
                        cmd, proc_mounts);
      return LVM_EE2FSADM_PROC_MOUNTS;
   }

   len = strlen ( lv_name);
   while ( fgets ( buffer, sizeof ( buffer), proc) != NULL) {
      if ( strncmp ( lv_name, buffer, len) == 0) {
         mount = buffer;
         while ( *mount != ' ') mount++;
         mount++;
         ptr = mount;
         while ( *ptr != ' ') ptr++;
         *ptr = 0;
         fprintf ( stderr, "%s -- ERROR: \"%s\" is mounted on \"%s\"\n"
                           "%s -- please umount it to resize\n\n",
                           cmd, lv_name, mount, cmd);
         fclose ( proc);
         return LVM_EE2FSADM_MOUNTED;
      }
   }
   fclose ( proc);

   if ( lvm_is_ext2_fs ( lv_name) == FALSE) return LVM_EE2FSADM_NO_EXT2;

   if ( opt_n == 0) {
      if ( opt_v > 0) printf ( "%s -- checking filesystem (this can "
                               "take a while)\n", cmd);
      if ( ( cmd_ptr = lvm_find_command ( cmd_fsck)) == NULL) {
         lvm_path_error ( cmd_fsck, "do filesystem check");
         return LVM_EE2FSADM_FSCK_PATH;
      }
      sprintf ( command, "%s -f %s%c", cmd_ptr, lv_name, 0);
      if ( opt_t == 0) {
         if ( system ( command) != 0) return  LVM_EE2FSADM_FSCK_RUN;
      }
   }

   /* GROW */
   if ( grow == TRUE) {
      if ( opt_v > 0) printf ( "%s -- extending logical volume size\n", cmd);
      if ( ( cmd_ptr = lvm_find_command ( cmd_extend)) == NULL) {
         lvm_path_error ( cmd_extend, "extend logical volume");
         return LVM_EE2FSADM_LV_EXTEND_PATH;
      }
      sprintf ( command, "%s -L %lu %s%c",
                         cmd_ptr, size / 2048, lv_name, 0);
      if ( opt_t == 0) {
         if ( system ( command) != 0) return LVM_EE2FSADM_LV_EXTEND_RUN;
         if ( ( ret = lvm_tab_lv_read_by_name ( vg_name, lv_name, &lv)) < 0) {
            fprintf ( stderr, "%s -- ERROR reading VGDA part of \"%s\" "
                              "from lvmtab\n\n",
                              cmd, lv_name);
            return LVM_EE2FSADM_LV_READ;
         }
         if ( size != lv->lv_size) {
            fprintf ( stderr, "%s -- logical volume size of \"%s\" changed "
                              "invalid\n\n",
                              cmd, lv_name);
            return LVM_EE2FSADM_LV_SIZE;
         }
      }
      if ( opt_v > 0) printf ( "%s -- resizing filesystem (this can "
                               "take a while)\n", cmd);
      if ( ( cmd_ptr = lvm_find_command ( cmd_resize)) == NULL) {
         lvm_path_error ( cmd_resize, "resize");
         return LVM_EE2FSADM_RESIZE_PATH;
      }
      sprintf ( command, "%s -p %s %lu%c",
                         cmd_ptr, lv_name, size / 2, 0);
      if ( opt_t == 0) {
         if ( system ( command) != 0) return LVM_EE2FSADM_RESIZE_RUN;
      }
   /* SHRINK */
   } else { /* grow == FALSE */
      if ( opt_v > 0) printf ( "%s -- resizing filesystem (this can "
                               "take a while)\n", cmd);
      if ( ( cmd_ptr = lvm_find_command ( cmd_resize)) == NULL) {
         lvm_path_error ( cmd_resize, "resize");
         return LVM_EE2FSADM_RESIZE_PATH;
      }
      sprintf ( command, "%s -p %s %lu%c",
                         cmd_ptr, lv_name, size / 2, 0);
      if ( opt_t == 0) {
         if ( system ( command) != 0) return LVM_EE2FSADM_RESIZE_RUN;
      }
      if ( opt_v > 0) printf ( "%s -- reducing logical volume size\n", cmd);
      if ( ( cmd_ptr = lvm_find_command ( cmd_reduce)) == NULL) {
         lvm_path_error ( cmd_reduce, "reduce logical volume");
         return LVM_EE2FSADM_LV_REDUCE_PATH;
      }
      sprintf ( command, "%s -L %lu %s%c",
                         cmd_ptr, size / 2048, lv_name, 0);
      if ( opt_t == 0) {
         if ( system ( command) != 0) return LVM_EE2FSADM_LV_REDUCE_RUN;
      }
   }

   printf ( "%s -- ext2 filesystem in logical volume \"%s\" successfully ",
            cmd, lv_name);
   if ( grow == TRUE) printf ( "extended");
   else               printf ( "reduced");
   printf ( " to %s\n\n", lvm_show_size ( size / 2, SHORT));

   return 0;
}


char *lvm_find_command ( char *cmd_to_find) {
   int i = 0;
   static char command[NAME_LEN];
   struct stat stat_b;

   if ( cmd_to_find == NULL || strlen ( cmd_to_find) == 0) return NULL;

   while ( bin_dirs[i] != NULL) {
      sprintf ( command, "%s/%s%c", bin_dirs[i], cmd_to_find, 0);
      if ( stat ( command, &stat_b) == 0) return command;
      i++;
   }

   return NULL;
}


void lvm_path_error ( char *cmd_to_find, char *comment) {
   int i = 0;

   if ( cmd_to_find == NULL || strlen ( cmd_to_find) == 0 ||
        comment     == NULL || strlen (     comment) == 0) return;

   fprintf ( stderr, "%s -- Sorry: \"%s\" not found in either of",
                     cmd, cmd_to_find);
   while ( bin_dirs[i] != NULL) fprintf ( stderr, " %s", bin_dirs[i++]);
   fprintf ( stderr, "\n%s -- ERROR: can't %s\n\n", cmd, comment);

   return;
}


int lvm_is_ext2_fs ( char *device) {
   int fs = -1;
   int ret = TRUE;
   struct {
      uint8_t dummy1[36];
      uint16_t s_magic;
      uint8_t dummy2[464];
   } super;

   if ( ( fs = open ( device, O_RDONLY)) == -1) {
      fprintf ( stderr, "%s -- ERROR %d opening logical volume \"%s\"\n\n",
                        cmd, errno, device);
      ret = FALSE;
      goto lvm_is_ext2_fs_end;
   }

   if ( lseek ( fs, 1024, SEEK_SET) == -1) {
      fprintf ( stderr, "%s -- ERROR %d seeking for superblock on \"%s\"\n\n",
                        cmd, errno, device);
      ret = FALSE;
      goto lvm_is_ext2_fs_end;
   }

   if ( read ( fs, &super, sizeof ( super)) != sizeof ( super)) {
      fprintf ( stderr, "%s -- ERROR %d reading superblock from \"%s\"\n\n",
                        cmd, errno, device);
      ret = FALSE;
      goto lvm_is_ext2_fs_end;
   }

   if ( super.s_magic != EXT2_SUPER_MAGIC) {
      fprintf ( stderr, "%s -- ERROR: \"%s\" doesn't contain an ext2 "
                        "filesystem\n\n",
                        cmd, device);
      ret = FALSE;
      goto lvm_is_ext2_fs_end;
   }

lvm_is_ext2_fs_end:
   if ( fs != -1) close ( fs);

   return ret;
}

