/*
 * tools/lib/liblvm.h
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March-June 1997
 * January 1998
 * January 1999
 *
 * liblvm is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * liblvm is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *   1/3/1999 - port to libc6
 *
 */

/* lvm_lib_version "LVM 0.5alpha by Heinz Mauelshagen   01/30/1999\n" */

#ifndef _LIBLVM_H_INCLUDE
#define _LIBLVM_H_INCLUDE

#include <features.h>

#ifndef LINUX_VERSION_CODE
#  include <linux/version.h>
   /* for 2.0.x series */
#  ifndef KERNEL_VERSION
#    define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
#  endif
#endif

#include <sys/ioctl.h>
#include <linux/genhd.h>
#include <linux/major.h>

#if __GLIBC__ > 1
#  ifndef uint8_t
#    define uint8_t	u_int8_t
#  endif
#  ifndef uint16_t
#    define uint16_t	u_int16_t
#  endif
#  ifndef uint32_t
#    define uint32_t	u_int32_t
#  endif
#  define	SECTOR_SIZE	512
#  define	BLKGETSIZE	_IO(0x12,96)	/* return device size */ 
#  define	BLKRASET	_IO(0x12,98)	/* Set read ahead */
#  define	BLOCK_SIZE	1024
#  define	EXT2_SUPER_MAGIC	0xEF53
#  include <sys/types.h>
#  include <sys/stat.h>
#  include <errno.h>
#  include <stdio.h>
#  include <fcntl.h>
#  include <unistd.h>
#  include <stdlib.h>
#  include <dirent.h>
#  include <string.h>
#  include <stdarg.h>
#  include <malloc.h>
#  include <ctype.h>
#  include <time.h>
int llseek ( unsigned int, unsigned long long, unsigned int);

#else /* __GLIBC__ < 2 */

#if LINUX_VERSION_CODE >= KERNEL_VERSION ( 2, 1, 0)
#  define _I386_STAT_H
#endif
#  include <sys/stat.h>
#  include <unistd.h>
#  include <fcntl.h>
#  include <dirent.h>
#  include <time.h>
#  include <stdlib.h>
#  include <ctype.h>
#  include <string.h>
#  include <linux/msdos_fs.h>
#  include <malloc.h>
#  include <stdio.h>
#endif /* __GLIBC__ > 1 */

#include <lvm.h>

#define	LVM_DIR_PREFIX	"/dev/"

#define	VGCFG_WRITE( handle, what, size, file_name) ( { \
      if ( write ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d writing volume group backup " \
                           "file %s in %s [line %d]\n", \
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         unlink ( file_name); \
         ret = -LVM_EVG_CFGBACKUP_WRITE; \
         goto vg_cfgbackup_end; \
      }; \
} )

#define	VGCFG_READ( handle, what, size, file_name) ( { \
      if ( read ( handle, what, size) != size) { \
         fprintf ( stderr, "%s -- ERROR %d reading volume group backup " \
                           "file %s in %s [ line %d]\n",\
                           cmd, errno, file_name, __FILE__, __LINE__); \
         close ( handle); \
         ret = -LVM_EVG_CFGRESTORE_READ; \
         goto vg_cfgrestore_end; \
      }; \
} )

#define LVM_TO_CORE16( a) ( \
   ( ( uint8_t*) &a)[0] + \
   ( ( uint8_t*) &a)[1] * 256 \
)

#define LVM_TO_DISK16( dest, src) ( { \
   int _i; \
   uint16_t _tmp = src; \
   for ( _i = 0; _i < 2; _i++) { \
      ( ( uint8_t*) &dest)[_i] = _tmp % 256; \
      _tmp /= 256; \
   } \
} )

#define LVM_TO_CORE32( a) ( \
   ( ( uint8_t*) &a)[0] + \
   ( ( uint8_t*) &a)[1] * 256 + \
   ( ( uint8_t*) &a)[2] * 256 * 256 + \
   ( ( uint8_t*) &a)[3] * 256 * 256 * 256 \
)

#define LVM_TO_DISK32( dest, src) ( { \
   int _i; \
   uint32_t _tmp = src; \
   for ( _i = 0; _i < 4; _i++) { \
      ( ( uint8_t*) &dest)[_i] = _tmp % 256; \
      _tmp /= 256; \
   } \
} )

extern int errno;
extern char *cmd;

#ifdef DEBUG
extern int opt_d;
#endif

/* for lvm_show_size () */
typedef	enum { SHORT, LONG} size_len_t;

/* for future use, maybe in pv_check_free () */
typedef	enum {
   NEXT_FREE,
   LINEAR,
   LINEAR_CONTIGUOUS,
   STRIPED,
   STRIPED_CONTIGUOUS}
alloc_t;

/* for lvm_dir_cache () */
typedef struct {
   char *dev_name;
   short st_rdev;
   short st_mode;
} dir_cache_t;

/* PE type data layer functions */
disk_pe_t *pe_copy_from_disk ( disk_pe_t*, int);
disk_pe_t *pe_copy_to_disk   ( disk_pe_t*, int);

/* VG functions */
int  vg_cfgbackup ( char *, char *, int, vg_t *);
int  vg_cfgrestore ( char *, char *, int, vg_t *);
int  vg_check_active ( char *);
int  vg_check_exist ( char *);
char ** vg_check_exist_all_vg ( void);
int  vg_check_name ( char *);
int  vg_check_consistency ( vg_t *);
int  vg_check_consistency_with_pv_and_lv ( vg_t *);
int  vg_check_online_all_pv ( vg_t*, pv_t***, pv_t***);
int  vg_check_pe_size ( ulong);
char ** vg_check_active_all_vg ( void);
vg_t      *vg_copy_from_disk ( vg_disk_t *);
vg_disk_t *vg_copy_to_disk ( vg_t *);
int  vg_create ( char *, vg_t *);
int  vg_create_dir_and_group ( vg_t *);
int  vg_create_dir_and_group_and_nodes ( vg_t *, int);
void vg_deactivate ( char *);
inline int vg_extend ( char *, pv_t *, vg_t *);
int  vg_free ( vg_t *, int);
char *vg_name_of_lv ( char *);
int  vg_remove ( char *);
int  vg_read ( char *, vg_t **);
int  vg_read_from_pv ( char *, vg_t **);
int  vg_read_with_pv_and_lv ( char *, vg_t **);
inline int vg_reduce ( char *, pv_t *, vg_t *);
int  vg_remove_dir_and_group_and_nodes ( char *);
int  vg_set_extendable ( char*);
int  vg_clear_extendable ( char*);
int  vg_setup_for_create ( char *, vg_t *, pv_t **, int, ulong, ulong);
int  vg_setup_for_extend ( char **, int, pv_t **, vg_t *, char **);
int  vg_setup_for_merge ( vg_t *, vg_t *);
int  vg_setup_for_reduce ( char **, int, vg_t *, pv_t ***, char **);
int  vg_setup_for_split ( vg_t *, char *, vg_t **, char **, char ***, char **);
void vg_show ( vg_t *);
void vg_show_with_pv_and_lv ( vg_t *);
int  vg_write ( char*, pv_t *, vg_t *);
int  vg_write_with_pv_and_lv ( vg_t *);
int  vg_status ( char *, vg_t **);
int  vg_status_get_count ( void);
int  vg_status_get_namelist ( char *);
int  vg_status_with_pv_and_lv ( char *, vg_t **, int);


/* PV functions */
int    pe_lock ( char *, kdev_t, ulong, ushort, ushort);
int    pe_unlock ( char *);
int    pv_change ( char *, pv_t *);
int    pv_change_all_pv_of_vg ( char *, vg_t *);
int    pv_change_all_pv_for_lv_of_vg ( char *, char *, vg_t *);
int    pv_check_active ( char *, char *);
int    pv_check_active_in_all_vg ( char *);
int    pv_check_free ( pv_t *, ulong, ulong *);
int    pv_check_free_contiguous ( pv_t *, ulong, ulong *);
int    pv_check_in_vg ( vg_t *, char *);
int    pv_check_new ( pv_t *);
int    pv_check_consistency ( pv_t *);
int    pv_check_consistency_all_pv ( vg_t *);
int    pv_check_name ( char *);
int    pv_check_number ( pv_t **, int);
int    pv_check_part ( char *);
int    pv_check_volume ( char *, pv_t *);
pv_t   *pv_copy_from_disk ( pv_disk_t *);
pv_disk_t *pv_copy_to_disk ( pv_t *);
char   **pv_find_all_pv_names ( void);
kdev_t pv_create_kdev_t ( char *);
char   *pv_create_name_from_kdev_t ( kdev_t);
int    pv_find_vg ( char *, char **);
int    pv_flush ( char *);
int    pv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    pv_get_index_by_name ( vg_t *, char *);
int    pv_get_size ( char *, struct partition *);
int    pv_move_pes ( vg_t*, char*, char**, int, int,
                     int*, int*, int*, int, int);
int    pv_move_pe ( vg_t*, char*, long, long, long, long,
                    int, int, int, int);
int    pv_read ( char *, pv_t **, int *);
int    pv_read_pe ( pv_t *, disk_pe_t **);
int    pv_read_all_pv ( pv_t ***, int);
int    pv_read_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_read_all_pe_of_vg ( char *, disk_pe_t ***, int);
int    pv_read_namelist ( char *, vg_t *, char **);
int    pv_release_pe ( vg_t *, disk_pe_t *, uint *, uint);
int    pv_reserve_pe ( pv_t *, disk_pe_t *, uint *, pe_t *, uint, int);
int    pv_setup_for_create ( char *, pv_t *, uint);
void   pv_show ( pv_t *);
void   pv_show_short ( pv_t *);
void   pv_show_all_pv_of_vg ( vg_t *);
void   pv_show_all_pv_of_vg_short ( vg_t *);
void   pv_show_pe ( pv_t *, disk_pe_t *, int);
int    pv_show_pe_text ( pv_t *, disk_pe_t *, int);
int    pv_status ( char *, char *, pv_t **);
int    pv_status_all_pv_of_vg ( char *, pv_t ***, int);
int    pv_write ( char*, pv_t *);
int    pv_write_all_pv_of_vg ( vg_t *);
int    pv_write_namelist ( char *, vg_t *);
int    pv_write_pe ( char*, pv_t *);
int    pv_write_with_pe ( char*, pv_t *);


/* LV functions */
char   *lv_change_vgname ( char *, char *);
int    lv_check_active ( char *, char *);
int    lv_check_on_pv ( pv_t *, int);
int    lv_check_contiguous ( vg_t *, int);
int    lv_check_consistency ( lv_t *);
int    lv_check_consistency_all_lv ( vg_t *);
int    lv_check_exist ( char *);
int    lv_check_name ( char *);
int    lv_check_stripesize ( int);
lv_t      *lv_copy_from_disk ( lv_disk_t *);
lv_disk_t *lv_copy_to_disk ( lv_t *);
int    lv_count_pe ( pv_t *, int);
inline int lv_create ( vg_t *, lv_t *, char *);
int    lv_create_name ( char *, char *, int);
int    lv_create_node ( char *, unsigned long, unsigned long);
kdev_t lv_create_kdev_t ( ulong, ulong);
inline int lv_extend ( vg_t *, lv_t *, char *);
int    lv_get_index_by_kdev_t ( vg_t *, kdev_t);
int    lv_get_index_by_name ( vg_t *, char *);
int    lv_get_le_on_pv ( pv_t *, int);
char   *lv_get_name ( vg_t*, int);
int    lv_number_from_name_in_vg ( char *, vg_t *);
int    lv_le_remap ( vg_t*, le_remap_req_t*);
int    lv_read ( char *, char *, lv_t **);
int    lv_read_byindex ( char *vg_name, ulong lv_index, lv_t **lv);
int    lv_read_with_pe ( char *, char *, lv_t **);
int    lv_read_all_lv_of_vg ( char *, lv_t ***, int);
inline int lv_reduce ( vg_t *, lv_t *, char *);
int    lv_release ( vg_t *, char *);
inline int lv_remove ( vg_t *, lv_t *, char *);
int    lv_setup_for_create ( char *, vg_t **, char *, int *,
                             uint, uint, uint, uint, uint, uint, char **);
int    lv_setup_for_extend ( char *, vg_t *, char *, uint, char **);
int    lv_setup_for_reduce ( char *, vg_t *, char *, uint);
void   lv_show ( lv_t *);
void   lv_show_all_lv_of_vg ( vg_t *);
void   lv_show_current_pe ( lv_t *);
int    lv_show_current_pe_text ( lv_t *);
int    lv_status_byname ( char *, char *, lv_t **);
int    lv_status_byindex ( char *, ulong, lv_t **);
int    lv_status_all_lv_of_vg ( char *, vg_t *, lv_t ***, int);
int    lv_write ( char *, vg_t *, lv_t *, int);
int    lv_write_all_pv ( vg_t *, int);
int    lv_write_all_lv_of_vg ( char*, vg_t *);


/* print debug info on stderr */
void debug ( const char *, ...);

/* generate nice KB/MB/... strings */
char *lvm_show_size ( unsigned long long, size_len_t);

/* get the basename (no slashes) of a path */
#if __GLIBC__ < 2
char *basename ( char *);
#endif

/* system identifier handling */
int system_id_set ( char *);
int system_id_set_exported ( char *);
int system_id_set_imported ( char *);
int system_id_check_exported ( char *);
int system_id_check_imported ( char *);

/* LVM locking / interrupt masking etc. */
int    lvm_check_dev ( struct stat*, int);
int    lvm_check_number ( char *);
int    lvm_dir_cache ( dir_cache_t**);
int    lvm_show_filetype ( ushort, char*);
int    lvm_lock ( void);
int    lvm_unlock ( void);
void   lvm_interrupt ( void);
void   lvm_dont_interrupt ( int);
int    lvm_get_col_numbers ( char *, int **);
ushort lvm_get_iop_version ( void);
int    lvm_check_chars ( char*);

/* LVMTAB based functions */
int  lvm_tab_create ( void);
int  lvm_tab_get_free_vg_number ( void);
int  lvm_tab_lv_check_exist ( char *);
int  lvm_tab_lv_read_by_name ( char *, char*, lv_t **);
int  lvm_tab_vg_insert ( char *);
int  lvm_tab_vg_read_with_pv_and_lv ( char *, vg_t **);
int  lvm_tab_vg_read ( char *, vg_t **);
int  lvm_tab_vg_remove ( char *);
int  lvm_tab_vg_check_exist ( char *, vg_t **);
char **lvm_tab_vg_check_exist_all_vg ( void);


/* return codes */
#define LVM_VG_CFGBACKUP_NO_DIFF                                           100


/* error return codes */
#define LVM_EPARAM                                                          99

#define LVM_ELVM_CHECK_CHARS                                                100
#define LVM_ELVM_FIND_VG_REALLOC                                            101
#define LVM_ELVM_IOP_VERSION_OPEN                                           102
#define LVM_ELVM_LOCK_YET_LOCKED                                            103
#define LVM_ELVM_READ_DEV_MAJOR                                             104
#define LVM_ELVM_READ_DEV_OPEN                                              105
#define LVM_ELVM_READ_DEV_RDEV                                              106
#define LVM_ELVM_READ_DEV_READ                                              107
#define LVM_ELVM_READ_DEV_STAT                                              108
#define LVM_ELVM_TAB_CREATE_LVMTAB                                          109
#define LVM_ELVM_TAB_CREATE_LVMTAB_DIR                                      110
#define LVM_ELVM_TAB_GET_FREE_VG_NUMBER_MALLOC                              111
#define LVM_ELVM_TAB_LV_READ_BY_NAME_LVM_TAB_VG_READ_WITH_PV_AND_LV         112
#define LVM_ELVM_TAB_LV_READ_BY_NAME_LV_GET_INDEX_BY_NAME                   113
#define LVM_ELVM_TAB_READ_FSTAT                                             114
#define LVM_ELVM_TAB_READ_MALLOC                                            115
#define LVM_ELVM_TAB_READ_OPEN                                              116
#define LVM_ELVM_TAB_READ_PV_CHECK_NAME                                     117
#define LVM_ELVM_TAB_READ_READ                                              118
#define LVM_ELVM_TAB_READ_SIZE                                              119
#define LVM_ELVM_TAB_READ_VG_CHECK_NAME                                     120
#define LVM_ELVM_TAB_STORE_FCHMOD                                           121
#define LVM_ELVM_TAB_STORE_OPEN                                             122
#define LVM_ELVM_TAB_STORE_WRITE                                            123
#define LVM_ELVM_TAB_VG_CHECK_EXIST_ALL_VG_REALLOC                          124
#define LVM_ELVM_TAB_VG_INSERT_REALLOC                                      125
#define LVM_ELVM_TAB_VG_INSERT_VG_EXISTS                                    126
#define LVM_ELVM_TAB_VG_REMOVE_NOT_EXISTS                                   127
#define LVM_ELVM_UNLOCK                                                     128
#define LVM_ELV_ACCESS                                                      129
#define LVM_ELV_ALLOCATED_LE                                                130
#define LVM_ELV_ALLOCATION                                                  131
#define LVM_ELV_BADBLOCK                                                    132
#define LVM_ELV_CHECK_NAME_LV_NAME                                          133
#define LVM_ELV_CHECK_NAME_LV_NUM                                           134
#define LVM_ELV_CHECK_NAME_VG_NAME                                          135
#define LVM_ELV_CHECK_STRIPE_SIZE                                           136
#define LVM_ELV_CREATE_MODE_CHMOD                                           137
#define LVM_ELV_CREATE_MODE_MKNOD                                           138
#define LVM_ELV_CREATE_NODE_UNLINK                                          139
#define LVM_ELV_CREATE_REMOVE_OPEN                                          140
#define LVM_ELV_CURRENT_LE                                                  141
#define LVM_ELV_DEV                                                         142
#define LVM_ELV_EXTEND_REDUCE_OPEN                                          143
#define LVM_ELV_LE_REMAP_OPEN                                               144
#define LVM_ELV_LVNAME                                                      145
#define LVM_ELV_MIRROR_COPIES                                               146
#define LVM_ELV_NUMBER                                                      147
#define LVM_ELV_OPEN                                                        148
#define LVM_ELV_READ_ALL_LV_OF_VG_LSEEK                                     149
#define LVM_ELV_READ_ALL_LV_OF_VG_MALLOC                                    150
#define LVM_ELV_READ_ALL_LV_OF_VG_NL                                        151
#define LVM_ELV_READ_ALL_LV_OF_VG_OPEN                                      152
#define LVM_ELV_READ_ALL_LV_OF_VG_READ                                      153
#define LVM_ELV_READ_ALL_LV_OF_VG_VGREAD                                    154
#define LVM_ELV_READ_BYINDEX_LV_READ_ALL_LV_OF_VG                           155
#define LVM_ELV_READ_BYINDEX_VGREAD                                         156
#define LVM_ELV_READ_BYINDEX_VG_NAME                                        157
#define LVM_ELV_READ_LV                                                     158
#define LVM_ELV_READ_LV_NAME                                                159
#define LVM_ELV_READ_LV_READ_ALL_LV_OF_VG                                   160
#define LVM_ELV_READ_VGREAD                                                 161
#define LVM_ELV_READ_VG_NAME                                                162
#define LVM_ELV_RECOVERY                                                    163
#define LVM_ELV_RELEASE_LV_NUM                                              164
#define LVM_ELV_SCHEDULE                                                    165
#define LVM_ELV_SETUP_FOR_CREATE_LV_MAX                                     166
#define LVM_ELV_SETUP_FOR_CREATE_MALLOC                                     167
#define LVM_ELV_SETUP_FOR_CREATE_PE                                         168
#define LVM_ELV_SETUP_FOR_CREATE_STRIPES                                    169
#define LVM_ELV_SETUP_FOR_CREATE_STRIPESIZE                                 170
#define LVM_ELV_SETUP_FOR_EXTEND_LV_INDEX                                   171
#define LVM_ELV_SETUP_FOR_EXTEND_REALLOC                                    172
#define LVM_ELV_SETUP_FOR_EXTEND_STRIPES                                    173
#define LVM_ELV_SETUP_FOR_REDUCE_LV_INDEX                                   174
#define LVM_ELV_SETUP_FOR_REDUCE_MALLOC                                     175
#define LVM_ELV_SHOW_CURRENT_PE_TEXT_LV_INDEX                               176
#define LVM_ELV_SIZE                                                        177
#define LVM_ELV_STATUS                                                      178
#define LVM_ELV_STATUS_ALL_LV_OF_VG_MALLOC                                  179
#define LVM_ELV_STATUS_INTERNAL_OPEN                                        180
#define LVM_ELV_STATUS_NL                                                   181
#define LVM_ELV_STATUS_WITH_PE_MALLOC                                       182
#define LVM_ELV_STORE_ALL_LV_OF_VG_LSEEK                                    183
#define LVM_ELV_STORE_ALL_LV_OF_VG_MALLOC                                   184
#define LVM_ELV_STORE_ALL_LV_OF_VG_OPEN                                     185
#define LVM_ELV_STORE_ALL_LV_OF_VG_WRITE                                    186
#define LVM_ELV_STORE_LSEEK                                                 187
#define LVM_ELV_STORE_OPEN                                                  188
#define LVM_ELV_STORE_WRITE                                                 189
#define LVM_ELV_STRIPES                                                     190
#define LVM_ELV_STRIPESIZE                                                  191
#define LVM_ELV_TIMEOUT                                                     192
#define LVM_ELV_VGNAME                                                      193
#define LVM_EPE_LOCK                                                        194
#define LVM_EPE_MOVE_LV_LE_REMAP                                            195
#define LVM_EPE_MOVE_PE_LLSEEK_IN                                           196
#define LVM_EPE_MOVE_PE_LLSEEK_OUT                                          197
#define LVM_EPE_MOVE_PE_LOCK                                                198
#define LVM_EPE_MOVE_PE_LV_GET_NAME                                         199
#define LVM_EPE_MOVE_PE_OPEN                                                200
#define LVM_EPE_MOVE_PE_OPEN_IN                                             201
#define LVM_EPE_MOVE_PE_READ_IN                                             202
#define LVM_EPE_MOVE_PE_UNLOCK                                              203
#define LVM_EPE_MOVE_PE_WRITE_OUT                                           204
#define LVM_EPE_MOVE_PV_CHANGE_DEST                                         205
#define LVM_EPE_MOVE_PV_CHANGE_SRC                                          206
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_DEST                               207
#define LVM_EPE_MOVE_PV_PV_STORE_WITH_PE_SRC                                208
#define LVM_EPV_CHANGE_ALL_PV_FOR_LV_OF_VG_LV_NUM                           209
#define LVM_EPV_CHANGE_OPEN                                                 210
#define LVM_EPV_CHECK_CONSISTENCY_ALL_PV_PE                                 211
#define LVM_EPV_CHECK_CONSISTENCY_LVM_ID                                    212
#define LVM_EPV_CHECK_CONSISTENCY_LV_CUR                                    213
#define LVM_EPV_CHECK_CONSISTENCY_MAJOR                                     214
#define LVM_EPV_CHECK_CONSISTENCY_PE_ALLOCATED                              215
#define LVM_EPV_CHECK_CONSISTENCY_PE_SIZE                                   216
#define LVM_EPV_CHECK_CONSISTENCY_PE_STALE                                  217
#define LVM_EPV_CHECK_CONSISTENCY_PE_TOTAL                                  218
#define LVM_EPV_CHECK_CONSISTENCY_PV_ALLOCATABLE                            219
#define LVM_EPV_CHECK_CONSISTENCY_PV_NAME                                   220
#define LVM_EPV_CHECK_CONSISTENCY_PV_SIZE                                   221
#define LVM_EPV_CHECK_CONSISTENCY_PV_STATUS                                 222
#define LVM_EPV_CHECK_CONSISTENCY_VG_NAME                                   223
#define LVM_EPV_CHECK_DEV_NAME                                              224
#define LVM_EPV_CHECK_NAME                                                  225
#define LVM_EPV_CHECK_NAME_STAT                                             226
#define LVM_EPV_CHECK_NUMBER_MALLOC                                         227
#define LVM_EPV_CHECK_NUMBER_MAX_NUMBER                                     228
#define LVM_EPV_CHECK_NUMBER_PV_NUMBER                                      229
#define LVM_EPV_CHECK_PART                                                  230
#define LVM_EPV_FIND_ALL_PV_PV_READ                                         231
#define LVM_EPV_FLUSH_OPEN                                                  232
#define LVM_EPV_GET_SIZE_IOCTL                                              233
#define LVM_EPV_GET_SIZE_LLSEEK                                             234
#define LVM_EPV_GET_SIZE_NO_EXTENDED                                        235
#define LVM_EPV_GET_SIZE_NO_PRIMARY                                         236
#define LVM_EPV_GET_SIZE_OPEN                                               237
#define LVM_EPV_GET_SIZE_PART                                               238
#define LVM_EPV_GET_SIZE_READ                                               239
#define LVM_EPV_MOVE_PES_ALLOC_STRIPES                                      240
#define LVM_EPV_MOVE_PES_NO_PES                                             241
#define LVM_EPV_MOVE_PES_NO_SPACE                                           242
#define LVM_EPV_MOVE_PES_REALLOC                                            243
#define LVM_EPV_READ_ALL_PE_OF_VG_MALLOC                                    244
#define LVM_EPV_READ_ALL_PE_OF_VG_PV_NUMBER                                 245
#define LVM_EPV_READ_ALL_PV_LVM_DIR_CACHE                                   246
#define LVM_EPV_READ_ALL_PV_MALLOC                                          247
#define LVM_EPV_READ_ALL_PV_OF_VG_MALLOC                                    248
#define LVM_EPV_READ_ALL_PV_OF_VG_NP                                        249
#define LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT                                   250
#define LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER                                 251
#define LVM_EPV_READ_ID_INVALID                                             252
#define LVM_EPV_READ_LVM_STRUCT_VERSION                                     253
#define LVM_EPV_READ_MAJOR                                                  254
#define LVM_EPV_READ_MD_DEVICE                                              255
#define LVM_EPV_READ_NAMELIST_LSEEK                                         256
#define LVM_EPV_READ_NAMELIST_MALLOC                                        257
#define LVM_EPV_READ_NAMELIST_OPEN                                          258
#define LVM_EPV_READ_NAMELIST_READ                                          259
#define LVM_EPV_READ_OPEN                                                   260
#define LVM_EPV_READ_PE_LSEEK                                               261
#define LVM_EPV_READ_PE_MALLOC                                              262
#define LVM_EPV_READ_PE_OPEN                                                263
#define LVM_EPV_READ_PE_READ                                                264
#define LVM_EPV_READ_PE_SIZE                                                265
#define LVM_EPV_READ_PV_EXPORTED                                            266
#define LVM_EPV_READ_PV_FLUSH                                               267
#define LVM_EPV_READ_RDEV                                                   268
#define LVM_EPV_READ_READ                                                   269
#define LVM_EPV_READ_STAT                                                   270
#define LVM_EPV_READ_VG_LSEEK                                               271
#define LVM_EPV_READ_VG_MAJOR                                               272
#define LVM_EPV_READ_VG_OPEN                                                273
#define LVM_EPV_READ_VG_RDEV                                                274
#define LVM_EPV_READ_VG_READ                                                275
#define LVM_EPV_READ_VG_STAT                                                276
#define LVM_EPV_RELEASE_PE_NO_PV                                            277
#define LVM_EPV_RELEASE_PE_REALLOC                                          278
#define LVM_EPV_SHOW_PE_TEXT_MALLOC                                         280
#define LVM_EPV_SHOW_PE_TEXT_REALLOC                                        281
#define LVM_EPV_SHOW_PE_TEXT_VG_READ_WITH_PV_AND_LV                         282
#define LVM_EPV_STATUS_ALL_PV_LVM_DIR_CACHE                                 283
#define LVM_EPV_STATUS_ALL_PV_OF_VG_MALLOC                                  284
#define LVM_EPV_STATUS_ALL_PV_OF_VG_NP                                      285
#define LVM_EPV_STATUS_OPEN                                                 286
#define LVM_EPV_STORE_LSEEK                                                 287
#define LVM_EPV_STORE_NAMELIST_LSEEK                                        288
#define LVM_EPV_STORE_NAMELIST_MALLOC                                       289
#define LVM_EPV_STORE_NAMELIST_OPEN                                         290
#define LVM_EPV_STORE_NAMELIST_WRITE                                        291
#define LVM_EPV_STORE_OPEN                                                  292
#define LVM_EPV_STORE_PE_LSEEK                                              293
#define LVM_EPV_STORE_PE_OPEN                                               294
#define LVM_EPV_STORE_PE_SIZE                                               295
#define LVM_EPV_STORE_PE_WRITE                                              296
#define LVM_EPV_STORE_WRITE                                                 297
#define LVM_ESIZE                                                           298
#define LVM_ESYSTEM_ID_SET_UNAME                                            299
#define LVM_EVG_CFGBACKUP_FILE_EXISTS                                       300
#define LVM_EVG_CFGBACKUP_MALLOC                                            301
#define LVM_EVG_CFGBACKUP_OPEN                                              302
#define LVM_EVG_CFGBACKUP_READ                                              303
#define LVM_EVG_CFGBACKUP_RENAME                                            304
#define LVM_EVG_CFGBACKUP_TMP_FILE                                          305
#define LVM_EVG_CFGBACKUP_UNLINK                                            306
#define LVM_EVG_CFGBACKUP_VG_CHECK_EXIST                                    307
#define LVM_EVG_CFGBACKUP_VG_READ_WITH_PV_AND_LV                            308
#define LVM_EVG_CFGBACKUP_WRITE                                             309
#define LVM_EVG_CFGRESTORE_FILE_EXISTS                                      310
#define LVM_EVG_CFGRESTORE_LV_CHECK_CONSISTENCY                             311
#define LVM_EVG_CFGRESTORE_MALLOC                                           312
#define LVM_EVG_CFGRESTORE_OPEN                                             313
#define LVM_EVG_CFGRESTORE_PV_CHECK_CONSISTENCY                             314
#define LVM_EVG_CFGRESTORE_READ                                             315
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY                             316
#define LVM_EVG_CFGRESTORE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV              317
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_COUNT                                   318
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_MALLOC                                  319
#define LVM_EVG_CHECK_ACTIVE_ALL_VG_NAMELIST                                320
#define LVM_EVG_CHECK_CONSISTENCY                                           321
#define LVM_EVG_CHECK_CONSISTENCY_LV_CUR                                    322
#define LVM_EVG_CHECK_CONSISTENCY_MAX_PE_PER_PV                             323
#define LVM_EVG_CHECK_CONSISTENCY_PE_ALLOCATED                              324
#define LVM_EVG_CHECK_CONSISTENCY_PE_TOTAL                                  325
#define LVM_EVG_CHECK_CONSISTENCY_PVG_TOTAL                                 326
#define LVM_EVG_CHECK_CONSISTENCY_PV_ACT                                    327
#define LVM_EVG_CHECK_CONSISTENCY_PV_CUR                                    328
#define LVM_EVG_CHECK_CONSISTENCY_SIZE                                      329
#define LVM_EVG_CHECK_CONSISTENCY_VGDA                                      330
#define LVM_EVG_CHECK_CONSISTENCY_VG_ACCESS                                 331
#define LVM_EVG_CHECK_CONSISTENCY_VG_NAME                                   332
#define LVM_EVG_CHECK_CONSISTENCY_VG_STATUS                                 333
#define LVM_EVG_CHECK_EXIST_PV_COUNT                                        334
#define LVM_EVG_CHECK_NAME                                                  335
#define LVM_EVG_CHECK_ONLINE_ALL_PV                                         336
#define LVM_EVG_CHECK_ONLINE_ALL_PV_MALLOC                                  337
#define LVM_EVG_CHECK_PE_SIZE                                               338
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_DIR                              339
#define LVM_EVG_CREATE_DIR_AND_GROUP_CHMOD_GROUP                            340
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKDIR                                  341
#define LVM_EVG_CREATE_DIR_AND_GROUP_MKNOD                                  342
#define LVM_EVG_CREATE_REMOVE_OPEN                                          343
#define LVM_EVG_EXTEND_REDUCE_OPEN                                          344
#define LVM_EVG_READ_FROM_PV_CHECK_CONSISTENCY                              345
#define LVM_EVG_READ_FROM_PV_LSEEK                                          346
#define LVM_EVG_READ_FROM_PV_LVM_STRUCT_VERSION                             347
#define LVM_EVG_READ_FROM_PV_OPEN                                           348
#define LVM_EVG_READ_FROM_PV_PV_READ                                        349
#define LVM_EVG_READ_FROM_PV_READ                                           350
#define LVM_EVG_READ_LSEEK                                                  351
#define LVM_EVG_READ_LVM_STRUCT_VERSION                                     352
#define LVM_EVG_READ_OPEN                                                   353
#define LVM_EVG_READ_PV                                                     354
#define LVM_EVG_READ_READ                                                   355
#define LVM_EVG_READ_VG_EXPORTED                                            356
#define LVM_EVG_READ_WITH_PV_AND_LV_LV_ALLOCATED_LE                         357
#define LVM_EVG_READ_WITH_PV_AND_LV_MALLOC                                  358
#define LVM_EVG_READ_WITH_PV_AND_LV_PV_CUR                                  359
#define LVM_EVG_SETUP_FOR_CREATE_MALLOC                                     360
#define LVM_EVG_SETUP_FOR_CREATE_PV_SIZE                                    361
#define LVM_EVG_SETUP_FOR_CREATE_VG_NUMBER                                  362
#define LVM_EVG_SETUP_FOR_EXTEND_MALLOC                                     363
#define LVM_EVG_SETUP_FOR_EXTEND_MAX_PV                                     364
#define LVM_EVG_SETUP_FOR_EXTEND_NO_PV                                      365
#define LVM_EVG_SETUP_FOR_EXTEND_PV_ALLREADY                                366
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NAME                              367
#define LVM_EVG_SETUP_FOR_EXTEND_PV_CHECK_NEW                               368
#define LVM_EVG_SETUP_FOR_EXTEND_PV_GET_SIZE                                369
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE                                    370
#define LVM_EVG_SETUP_FOR_EXTEND_PV_SIZE_REL                                371
#define LVM_EVG_SETUP_FOR_MERGE_LV_MAX                                      372
#define LVM_EVG_SETUP_FOR_MERGE_PE_SIZE                                     373
#define LVM_EVG_SETUP_FOR_MERGE_PV_MAX                                      374
#define LVM_EVG_SETUP_FOR_MERGE_VG_CHECK_CONSISTENCY_WITH_PV_AND_LV         375
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV                                    376
#define LVM_EVG_SETUP_FOR_REDUCE_LAST_PV_NOT_IN_VG                          377
#define LVM_EVG_SETUP_FOR_REDUCE_LV                                         378
#define LVM_EVG_SETUP_FOR_REDUCE_NO_PV_TO_REDUCE                            379
#define LVM_EVG_SETUP_FOR_REDUCE_PV_INVALID                                 380
#define LVM_EVG_SETUP_FOR_REDUCE_REALLOC                                    381
#define LVM_EVG_SETUP_FOR_SPLIT_LV_ON_PV                                    382
#define LVM_EVG_SETUP_FOR_SPLIT_MALLOC                                      383
#define LVM_EVG_SETUP_FOR_SPLIT_PV                                          384
#define LVM_EVG_SETUP_FOR_SPLIT_PV_COUNT                                    385
#define LVM_EVG_SETUP_FOR_SPLIT_VG_NUMBER                                   386
#define LVM_EVG_SET_CLEAR_EXTENDABLE_OPEN                                   387
#define LVM_EVG_STATUS_GET_COUNT_OPEN                                       388
#define LVM_EVG_STATUS_GET_NAMELIST_OPEN                                    389
#define LVM_EVG_STATUS_OPEN                                                 390
#define LVM_EVG_STORE_LSEEK                                                 391
#define LVM_EVG_STORE_OPEN                                                  392
#define LVM_EVG_STORE_WRITE                                                 393

#endif /* #ifndef _LIBLVM_H_INCLUDE */
