/*
 * tools/lib/lvm_check_number.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * June 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lvm_check_number ( char *number_str) {
   int ret = 0;

#ifdef DEBUG
   debug ( "lvm_check_number -- CALLED with \"%s\"\n", number_str);
#endif

   if ( number_str == NULL) {
      ret = -LVM_EPARAM;
      goto lvm_check_number_end;
   }

   ret = TRUE;
   while ( *number_str != 0) {
      if ( number_str[1] == 0 &&
           ( *number_str == 'k' ||
             *number_str == 'k' ||
             *number_str == 'm' ||
             *number_str == 'M' ||
             *number_str == 'g' ||
             *number_str == 'G' ||
             *number_str == 't' ||
             *number_str == 'T')) {
         break;
      } else if ( ! isdigit ( *number_str)) {
         ret = FALSE;
         break;
      }
      number_str++;
   }

lvm_check_number_end:
#ifdef DEBUG
   debug ( "lvm_check_number -- LEAVING with ret: %d\n", ret);
#endif

   return ret;
}
