/*
 * tools/lib/lvm_get_iop_version.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * November 1997
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

ushort lvm_get_iop_version ( void) {
   int group = -1;
   int ret = 0;
   ushort lvm_iop_version = 0;

#ifdef DEBUG
   debug ( "lvm_iop_version -- CALLED\n");
#endif

   if ( ( group = open ( LVM_DEV, O_RDONLY)) == -1)
      ret = -LVM_ELVM_IOP_VERSION_OPEN;
   else if ( ( ret = ioctl ( group, LVM_GET_IOP_VERSION,
                             &lvm_iop_version)) == -1) ret = -errno;

#ifdef DEBUG
   debug ( "lv_status_internal -- AFTER ioctl ret: %d\n", ret);
#endif
   if ( group != -1) close ( group);

#ifdef DEBUG
   debug ( "lvm_iop_version -- LEAVING with ret: %d\n", ret);
#endif
   if ( ret == 0) return lvm_iop_version;
   else           return ret;
}
