/*
 * tools/lib/lvm_show_filetype.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * May 1998
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

#include <liblvm.h>

int lvm_show_filetype ( ushort mode, char *name) {
   char *what_file = "file";

   if ( name == NULL) return -LVM_EPARAM;

   if ( S_ISLNK  ( mode)) what_file = "symlink";
   if ( S_ISDIR  ( mode)) what_file = "directory";
   if ( S_ISCHR  ( mode)) what_file = "character special";
   if ( S_ISBLK  ( mode)) what_file = "block special";
   if ( S_ISFIFO ( mode)) what_file = "fifo";
   if ( S_ISSOCK ( mode)) what_file = "socket";
   fprintf ( stderr, "%s -- %s %s allready exists\n\n",
                     cmd, what_file, name);
   return 0;
}
