/*
 * tools/lib/vg_check_name.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March-May 1997
 * January,May,June,September 1998
 * January 1999
 *
 * LVM is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * LVM is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with GNU CC; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA. 
 *
 */

/*
 * Changelog
 *
 *    01/11/1998 - seperated from previous vg_name.c
 *    02/12/1998 - changed for free volume group names
 *    05/12/1998 - avoided checking vg_name against LVM_PV_NEW
 *    05/27/1998 - checking vg_name against EXPORTED
 *    06/06/1998 - checking vg_name against EXPORTED was an error
 *                 for vgexport
 *    09/06/1998 - checked VG characters with new lvm_check_chars()
 *    01/26/1999 - made volume group directory prefix a preprocessor option
 *
 */

#include <liblvm.h>

int vg_check_name ( char *vg_name) {
   int length = 0;
   int ret = 0;

#ifdef DEBUG
   debug ( "vg_check_name -- CALLED\n");
#endif

   if ( vg_name == NULL) return -LVM_EPARAM;

#ifdef DEBUG
   debug ( "vg_check_name -- vg_name: \"%s\"\n", vg_name);
#endif

   length = strlen ( LVM_DIR_PREFIX);
   if ( strncmp ( vg_name, LVM_DIR_PREFIX, length) == 0)
      strcpy ( vg_name, &vg_name[length]);

   if ( lvm_check_chars ( vg_name) < 0 ||
        strchr ( vg_name, '/') != NULL ||
        strlen ( vg_name) > ( NAME_LEN / 2)) ret = -LVM_EVG_CHECK_NAME;

#ifdef DEBUG
   debug ( "vg_check_name -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
