/*
 * tools/lib/pv_read_all_pv_of_vg.c
 *
 * Copyright (C) 1997 - 1999  Heinz Mauelshagen, Germany
 *
 * March-May,October-November 1997
 * May,August,November 1998
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

#include <liblvm.h>


int pv_read_all_pv_of_vg ( char *vg_name, pv_t ***pv, int reread) {
   int p  = 0;
   int np = 0;
   int pv_number = 0;
   int ret = 0;
   static int first = 0;
   static char vg_name_sav[NAME_LEN] = { 0, };
   pv_t **pv_tmp = NULL;
   static pv_t **pv_this = NULL;
   
#ifdef DEBUG
   debug ( "pv_read_all_pv_of_vg -- CALLED with vg_name: \"%s\"\n", vg_name);
#endif

   if ( pv == NULL || vg_name == NULL ||
        ( reread != TRUE && reread != FALSE) ||
        vg_check_name ( vg_name) < 0) return -LVM_EPARAM;

   *pv = NULL;

   if ( strcmp ( vg_name_sav, vg_name) != 0) {
      strcpy ( vg_name_sav, vg_name);
      reread = TRUE;
   }

   if ( reread == TRUE) {
      if ( pv_this != NULL) {
         free ( pv_this);
         pv_this = NULL;
      }
      first = 0;
   }

   if ( first == 0) {
      if ( ( ret = pv_read_all_pv ( &pv_tmp, FALSE)) < 0) return ret;
   
      /* find all PVs of this VG */
   
      /* first pass to find highest pv_number */
      np = pv_number = 0;

      for ( p = 0; pv_tmp != NULL && pv_tmp[p] != NULL; p++) {
         if ( pv_check_consistency ( pv_tmp[p]) == 0 &&
              strcmp ( pv_tmp[p]->vg_name, vg_name) == 0) {
            if ( pv_number < pv_tmp[p]->pv_number)
               pv_number = pv_tmp[p]->pv_number;
            np++;
         }
      }
      if ( np == 0) return -LVM_EPV_READ_ALL_PV_OF_VG_NP;
      if ( pv_number != np) return -LVM_EPV_READ_ALL_PV_OF_VG_PV_NUMBER;

      if ( ( pv_this = malloc ( ( np + 1) * sizeof ( pv_t*))) == NULL) {
         fprintf ( stderr, "malloc error in %s [line %d]\n",
                           __FILE__, __LINE__);
         return -LVM_EPV_READ_ALL_PV_OF_VG_MALLOC;
      }
      memset ( pv_this, 0, ( np + 1) * sizeof ( pv_t*));
   
      /* second pass to fill array */
      np = 0;
      for ( p = 0; pv_tmp[p] != NULL; p++) {
#ifdef DEBUG
         debug ( "pv_read_all_pv_of_vg:  pv_name: %s  vg_name: %s  p: %d\n",
                  pv_tmp[p]->pv_name, pv_tmp[p]->vg_name, p);
#endif
         if ( strcmp ( pv_tmp[p]->vg_name, vg_name) == 0) {
#ifdef DEBUG
            debug ( "pv_read_all_pv_of_vg: %s[%lu] hit %s[%d]\n",
                      pv_tmp[p]->pv_name, pv_tmp[p]->pv_number-1,
                      pv_tmp[p]->vg_name, p);
#endif
            pv_this[pv_tmp[p]->pv_number-1] = pv_tmp[p];
            np++;
         }
      }
      pv_this[np] = NULL;

      /* Check for contiguous PV array */
      for ( p = 0; pv_this[p] != NULL; p++)
         if ( pv_this[p] == NULL && p < np)
            ret = -LVM_EPV_READ_ALL_PV_OF_VG_NP_SORT;

      first = 1;
   }

   if ( ret == 0) *pv = pv_this;

#ifdef DEBUG
   debug ( "pv_read_all_pv_of_vg -- LEAVING with ret: %d\n", ret);
#endif
   return ret;
}
