/*
 * tools/lib/pv_check_part.c
 *
 * Copyright (C) 1997 - 2000  Heinz Mauelshagen, Sistina Software
 *
 * March,October,November 1997
 * January,August 1999
 * February 2000
 *
 *
 * This LVM library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This LVM library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this LVM library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 *
 */

/*
 * Changelog
 *
 *    08/10/1997 - changed partition number to absolute
 *    07/11/1997 - added debug info
 *    23/01/1999 - extension for devfs names
 *    15/08/1999 - rewritten based on lvm_dir_cache_find()
 *    31/01/2000 - use debug_enter()/debug_leave()
 *
 */

#include <liblvm.h>

int pv_check_part ( char *dev_name) {
   int ret = 0;
   dir_cache_t *cache_entry = NULL;

#ifdef DEBUG
   debug_enter ( "pv_check_part -- CALLED with %s\n", dev_name);
#endif

   if ( dev_name == NULL || pv_check_name ( dev_name) < 0) ret = -LVM_EPARAM;
   else {
      if ( ( cache_entry = lvm_dir_cache_find ( dev_name)) != NULL) {
         ret = MINOR ( cache_entry->st_rdev) %
               lvm_partition_count ( cache_entry->st_rdev);
      } else ret = -1;
      if ( ret < MIN_PART || ret > MAX_PART) ret = -LVM_EPV_CHECK_PART;
   }

#ifdef DEBUG
   debug_leave ( "pv_check_part -- LEAVING with %d\n", ret);
#endif
   return ret;
}
