/* Copyright (c) 1987, 1988, 1991  Stanley T. Shebs. */
/* Copyright (c) 1995 Michael J. Peters */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact.  */

#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/Frame.h>
#include <Xm/DrawingA.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/DialogS.h>
#include <Xm/PanedW.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/CascadeBG.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/Protocols.h>
#include <Xm/AtomMgr.h>
#include <Xm/ScrollBar.h>


#include "config.h"
#include "misc.h"
#include "dir.h"
#include "period.h"
#include "side.h"
#include "unit.h"
#include "map.h"
#include "X11.h"
#include "Motif.h"
#include "global.h"


MenuItem GAME_menu[] = {
    {"Resign", &xmPushButtonGadgetClass, NULL, "Shift<Key>x", "<Key>X",
     do_resign, NOT_SENSITIVE, "resign from the game"},
    {"Save", &xmPushButtonGadgetClass, NULL, "Shift<Key>s", "<Key>S",
     do_save, NOT_SENSITIVE, "save the game into a file"},
    NULL,
};

MenuItem MESSAGE_menu[] = {
    {"Send message", &xmPushButtonGadgetClass, NULL, "Shift<Key>m", "<Key>M",
     do_message, NOT_SENSITIVE, "send a message to other sides" },
    {"Declare war", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_war, NOT_SENSITIVE, "declare war to other sides" },
    {"Declare neutrality", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_neutral, NOT_SENSITIVE, "declare neutrality to other sides" },
    {"Declare alliance", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_alliance, NOT_SENSITIVE, "declare alliance to other sides" },
    {"Send briefing", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_briefing, NOT_SENSITIVE, "send briefing to other sides" },
    NULL,
};

MenuItem OPTIONS_menu[] = {
    {"Name", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_rename, NOT_SENSITIVE, "change side's name"},
    {"Beep time", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_beeptime, NOT_SENSITIVE, "change side's beep time"},
    {"Order iteration", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_itertime, NOT_SENSITIVE, "change side's default order iteration"},
    {"Display mode", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_showmode, NOT_SENSITIVE, "change side's map display mode"},
    {"Map background", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_background, NOT_SENSITIVE, "change side's map background color"},
    {"Metamorphose", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_morph, NOT_SENSITIVE, "covert yourself into a machine/human player"},
    NULL,
};

MenuItem HELP_menu[] = {
    {"Side commands", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_side_help, NOT_SENSITIVE, "display side commands" },
    {"Map commands", &xmPushButtonGadgetClass, NULL, "Shift<Key>question", "<Key>?",
     do_map_commands_help, NOT_SENSITIVE, "display map commands" },
    {"Map", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_map_help, NOT_SENSITIVE, "display map information" },
    {"Period", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_period_help, NOT_SENSITIVE, "display period information" },
    {"Terrain", &xmPushButtonGadgetClass, NULL, NULL, NULL,
     do_terrain_help, NOT_SENSITIVE, "display terrain information" },
    {"Version", &xmPushButtonGadgetClass, NULL, "Shift<Key>v", "<Key>V",
     do_version_help, NOT_SENSITIVE, "display XConq version" },
    {"Dump all help", &xmPushButtonGadgetClass, NULL, "Shift<Key>plus", "<Key>+",
     do_dump_help, NOT_SENSITIVE, "put various data into files for printing" },
    NULL,
};

MenuItem CONSCIOUSNESS_menu[] = {
    {"Sentry one turn", &xmPushButtonGadgetClass, NULL, "<Key>space", "space",
     do_sit, UNIT_SENSITIVE , "make unit be on sentry this turn only"},
    {"Sentry iterate turns", &xmPushButtonGadgetClass, NULL, "<Key>s", "<Key>s",
     do_sentry_iterate, UNIT_SENSITIVE, "put a unit on sentry duty" },
    {"Sentry until embark", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>e", "Ctrl+e",
     do_sentry_embark, UNIT_SENSITIVE, "order unit to sleep until embarked" },
    {"Sentry until full", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>f", "Ctrl+f",
     do_fill, UNIT_SENSITIVE, "order transport to sleep until full" },
    {"Wake", &xmPushButtonGadgetClass, NULL, "<Key>w", "<Key>w",
     do_wake_it, UNIT_SENSITIVE, "wake units up from whatever they were doing" },
    {"Wake all", &xmPushButtonGadgetClass, NULL, "Shift<Key>w", "<Key>W",
     do_wake_all, UNIT_SENSITIVE, "wake ALL units including occupants" },
    {"Wake area", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>w", "Ctrl+w",
     do_wake_area, NOT_SENSITIVE, "wake ALL units in area, including occupants" },
    NULL,
};

MenuItem MOVE_menu[] = {
    {"Return to transport", &xmPushButtonGadgetClass, NULL, "<Key>r", "<Key>r",
     do_return, UNIT_SENSITIVE, "return unit to nearest city/transport" },
    {"Move to position", &xmPushButtonGadgetClass, NULL, "<Key>m", "<Key>m",
     do_moveto, UNIT_SENSITIVE, "move to given location" },
    {"Move to marked unit", &xmPushButtonGadgetClass, NULL, "<Key>Return", "<CR>",
     do_movetounit, UNIT_SENSITIVE, "move to the marked unit" },
    {"Move to filling transport", &xmPushButtonGadgetClass, NULL, "Shift<Key>e", "<Key>E",
     do_movetotransport, UNIT_SENSITIVE, "move to filling transport" },
    {"Follow leader", &xmPushButtonGadgetClass, NULL, "<Key>f", "<Key>f",
     do_follow, UNIT_SENSITIVE, "follow a designated leader" },
    {"Follow coast", &xmPushButtonGadgetClass, NULL, "Shift<Key>f", "<Key>F",
     do_coast, UNIT_SENSITIVE, "follow a coastline" },
    {"Patrol", &xmPushButtonGadgetClass, NULL, "<Key>p", "<Key>p", do_patrol,
     UNIT_SENSITIVE, "go on a patrol" },
    {"Delay move", &xmPushButtonGadgetClass, NULL, "<Key>d", "<Key>d", do_delay,
     UNIT_SENSITIVE, "delay unit's move until later in turn" },
    {"Toggle Mode", &xmPushButtonGadgetClass, NULL, "<Key>z", "<Key>z", do_survey_mode,
     NOT_SENSITIVE, "toggle between survey and move modes" },
    NULL,
};

MenuItem PRODUCTION_menu[] = {
    {"Set production", &xmPushButtonGadgetClass, NULL, "Shift<Key>p", "<Key>P",
     do_product, UNIT_SENSITIVE | PRODUCE_SENSITIVE, "set/change unit production" },
    {"Set next production", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>p", "Ctrl+p",
     do_next_product, UNIT_SENSITIVE | PRODUCE_SENSITIVE, "set next product" },
    {"Idle production", &xmPushButtonGadgetClass, NULL, "Shift<Key>i", "<Key>I",
     do_idle, UNIT_SENSITIVE | PRODUCE_SENSITIVE, "set unit to not produce anything" },
    NULL,
};

MenuItem TRANSPORT_menu[] = {
    {"Cycle occupants", &xmPushButtonGadgetClass, NULL, "<Key>i", "<Key>i",
     do_occupant,  SURVEY_SENSITIVE | UNIT_SENSITIVE, "look at the occupants" },
    {"Mark unit", &xmPushButtonGadgetClass, NULL, "<Key>x", "<Key>x",
     do_mark_unit, UNIT_SENSITIVE, "mark unit for later reference" },
    {"Embark unit", &xmPushButtonGadgetClass, NULL, "<Key>e", "<Key>e",
     do_embark_unit, UNIT_SENSITIVE, "embark units onto transport occupying same unit" },
    {"Disembark unit", &xmPushButtonGadgetClass, NULL, "Shift<Key>at", "<Key>@",
     do_disembark, UNIT_SENSITIVE, "disembark units from one transport into unit" },
    {"Give supplies", &xmPushButtonGadgetClass, NULL, "<Key>g", "<Key>g",
     do_give, UNIT_SENSITIVE, "give supplies to the transport" },
    {"Take supplies", &xmPushButtonGadgetClass, NULL, "<Key>t", "<Key>t",
     do_take, UNIT_SENSITIVE, "take supplies from the transport" },
    {"Set standing order", &xmPushButtonGadgetClass, NULL, "Shift<Key>o", "<Key>O",
     do_standing, UNIT_SENSITIVE, "set standing orders for occupants" },
    {"Delete standing order", &xmPushButtonGadgetClass, NULL, "<Key>Delete", "<Del>",
     do_nothing, UNIT_SENSITIVE, "Delete a standing order" },
    NULL,
};

MenuItem MAP_menu[] = {
    {"Identify position", &xmPushButtonGadgetClass, NULL, "<Key>slash", "<Key>/",
     do_ident, NOT_SENSITIVE, "identify things on screen" },
    {"Flash position", &xmPushButtonGadgetClass, NULL, "<Key>v", "<Key>v", do_flash,
     NOT_SENSITIVE, "highlight current position" },
    {"Recenter map", &xmPushButtonGadgetClass, NULL, "<Key>period", "<Key>.",
     do_recenter, NOT_SENSITIVE, "center the screen around current location" },
    {"Refresh map", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>r", "Ctrl+r",
     do_refresh, NOT_SENSITIVE, "redraw screen erase very old views" },
    {"Redraw map", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>l", "Ctrl+l",
     do_redraw, NOT_SENSITIVE, "redraw screen" },
    {"Toggle look mode", &xmPushButtonGadgetClass, NULL, "Shift<Key>l", "<Key>L",
     do_look, NOT_SENSITIVE, "watch the action point when not your turn" },
    NULL,
};

MenuItem MISC_menu[] = {
    {"Name unit", &xmPushButtonGadgetClass, NULL, "Shift<Key>c", "<Key>C",
     do_unit_name, UNIT_SENSITIVE, "call a unit or side by a name" },
    {"Disband unit", &xmPushButtonGadgetClass, NULL, "Shift<Key>d", "<Key>D",
     do_disband, UNIT_SENSITIVE, "disband a unit and send it home" },
    {"Give unit", &xmPushButtonGadgetClass, NULL, "Shift<Key>g", "<Key>G",
     do_give_unit, UNIT_SENSITIVE, "turn unit over to another side" },
    {"Automate unit", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>a", "Ctrl+a",
     do_auto, UNIT_SENSITIVE, "turn unit over to machine control" },
    {"Center units", &xmPushButtonGadgetClass, NULL, "<Key>c", "<Key>c",
     do_center, UNIT_SENSITIVE, "designate current location as center of action" },
    {"Find unit", &xmPushButtonGadgetClass, NULL, "Shift<Key>t", "<Key>T",
     do_find_unit, SURVEY_SENSITIVE, "find a unit type" },
    {"Find next unit", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>t", "Ctrl+t",
     do_find_next_unit_by_type, SURVEY_SENSITIVE, "find next unit" },
    {"Find next dead unit", &xmPushButtonGadgetClass, NULL, "Ctrl<Key>d", "Ctrl+d",
     do_next_dead, SURVEY_SENSITIVE, "find next dead unit" },
    {"Determine distance", &xmPushButtonGadgetClass, NULL, "<Key>numbersign",
     "<Key>#", do_distance, SURVEY_SENSITIVE, "measure the distance from the current point" },
    NULL,
};

void init_WM(Side *side) {

    XtVaSetValues(side->top,
        XmNiconPixmap, side->logostipple,
        XmNdeleteResponse, XmDO_NOTHING, 
        NULL);

    XmAddWMProtocolCallback(side->top, 
        XmInternAtom(XtDisplay(side->top), "WM_DELETE_WINDOW", False), 
        do_save, (XtPointer)side);
}        

void add_sensitive_item(Side *side, Widget widget, int sensitivity) {

    Sensitive_item *item, *cur_item;

    item = (Sensitive_item *)malloc(sizeof(Sensitive_item));
    item->widget = widget;
    item->sensitivity = sensitivity;
    item->next = NULL;


    if (side->unit_sensitivities == NULL)
        side->unit_sensitivities = item;
    else {
        cur_item = side->unit_sensitivities;
        while (cur_item->next != NULL) cur_item = cur_item->next;
        cur_item->next = item;
    }
}

void BuildPulldownMenu(Widget parent, Side *side, char *menu_title, char menu_mnemonic,
                       Boolean tear_off, MenuItem *items) {

    Widget pulldown, widget, cascade;
    XmString str;
    int i;

    pulldown = XmCreatePulldownMenu (parent, "pulldown", NULL, 0);
    if (tear_off)
        XtVaSetValues (pulldown, 
            XmNtearOffModel, XmTEAR_OFF_ENABLED, NULL);

    cascade = XtVaCreateManagedWidget (menu_title,
        xmCascadeButtonGadgetClass, parent,
        XmNsubMenuId,   pulldown,
        XmNmnemonic,    menu_mnemonic,
        NULL);
    if (strcmp(menu_title, "Help") == 0)
        XtVaSetValues(parent,
            XmNmenuHelpWidget, cascade,
            NULL);

    /* Now add the menu items */

    for (i = 0; items[i].label != NULL; i++) {

        widget = XtVaCreateManagedWidget (items[i].label,
            *items[i].class, pulldown,
            NULL);

        if (items[i].mnemonic)
            XtVaSetValues (widget, XmNmnemonic, items[i].mnemonic, NULL);

        if (items[i].accelerator) {
            str = XmStringCreateLocalized (items[i].accel_text);
            XtVaSetValues (widget,
                XmNaccelerator, items[i].accelerator,
                XmNacceleratorText, str,
                NULL);
            XmStringFree (str);
        }

        if (items[i].callback)
            XtAddCallback(widget,
                (items[i].class == &xmToggleButtonWidgetClass ||
                items[i].class == &xmToggleButtonGadgetClass) ?
                    XmNvalueChangedCallback : /* ToggleButton class */
                    XmNactivateCallback,      /* PushButton class */
                items[i].callback, (XtPointer)side);

        if (items[i].sensitivity > 0)
            add_sensitive_item(side, widget, items[i].sensitivity);
    }

}

void create_side_menu_window(Side *side) {

    Arg args[5];
    int n=0;

    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
    side->side_menu = XmCreateMenuBar (side->main, "menu", args, n);
    side->unit_sensitivities = NULL;

    BuildPulldownMenu (side->side_menu, side, "Game", NULL, False, GAME_menu);
    BuildPulldownMenu (side->side_menu, side, "Message", NULL, False, MESSAGE_menu);
    BuildPulldownMenu (side->side_menu, side, "Options", NULL, False, OPTIONS_menu);
    BuildPulldownMenu (side->side_menu, side, "Help", NULL, False, HELP_menu);

    XtManageChild (side->side_menu);
}

/*
 * Create main geometry management widget.
 */

void create_main_window(Side *side) {

    XmFontList font_list;
    XmFontContext font_context;
    XmFontListEntry entry1;
    XmFontType font_type;
    XtPointer font_ptr;
    
    /* 
     * Create a Form manager widget to manage two columns of
     * PanedWindow manager widgets
     */

    side->main = XtVaCreateWidget ("main",
        xmFormWidgetClass, side->top,
        XmNfractionBase, 4,
        NULL);
                
    XtVaGetValues(side->main,
        XtNbackground, &(side->appdata.bgcolor),
        XtNforeground, &(side->appdata.fgcolor),
        NULL);

    XtVaGetValues(side->main, XmNlabelFontList, &font_list, NULL);
    XmFontListInitFontContext(&font_context, font_list);
    entry1 = XmFontListNextEntry(font_context);
    font_ptr = XmFontListEntryGetFont(entry1, &font_type);
    side->appdata.labelfont = (XFontStruct *)font_ptr;
    XmFontListFreeFontContext(font_context);

    create_side_menu_window(side);

    side->separator = XtVaCreateManagedWidget ("separator",
        xmSeparatorWidgetClass, side->main,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 3,
        XmNtopAttachment,  XmATTACH_WIDGET,
        XmNtopWidget, side->side_menu,
        XmNbottomAttachment,  XmATTACH_FORM,
        XmNorientation, XmVERTICAL,
        NULL);

    side->right = XtVaCreateWidget ("right",
        xmFormWidgetClass, side->main,
        XmNfractionBase, 6,
        XmNleftAttachment,  XmATTACH_WIDGET,
        XmNleftWidget, side->separator,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_WIDGET,
        XmNtopWidget, side->side_menu,
        XmNbottomAttachment,  XmATTACH_FORM,
        NULL);

    side->left = XtVaCreateWidget ("left",
        xmPanedWindowWidgetClass, side->main,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_WIDGET,
        XmNrightWidget, side->separator,
        XmNtopAttachment,  XmATTACH_WIDGET,
        XmNtopWidget, side->side_menu,
        XmNbottomAttachment,  XmATTACH_FORM,
        NULL);
}

void create_msg_window(Side *side) {

    side->msg = XtVaCreateManagedWidget ("msg",
        xmScrolledWindowWidgetClass, side->left,
        XmNscrollingPolicy, XmAPPLICATION_DEFINED,
        XmNvisualPolicy, XmVARIABLE,
        XmNscrollBarDisplayPolicy, XmSTATIC,
        NULL);

    side->msg_text = XtVaCreateManagedWidget ("msg_text",
        xmTextWidgetClass, side->msg,
        XmNrows, 6,
        XmNcolumns, 80,
        XmNeditable, False,
        XmNeditMode, XmMULTI_LINE_EDIT,
        XmNwordWrap, True,
        XmNscrollHorizontal, False,
        XmNcursorPositionVisible, False,
        NULL);        
}    

int pane_height(Side *side, int text_lines) {

    int margin_height = 2;	/* default marginHeight */
    int shadow_thickness = 2;	/* default shadowThickness */
    int spacing = 16;		/* pane spacing */
    int height;

    height = spacing + ((margin_height*2) + (shadow_thickness *2) + 
                   side->appdata.labelfont->max_bounds.ascent +
                   side->appdata.labelfont->max_bounds.descent) * text_lines;
    return height;
}

void create_info_window(Side *side) {

    int height;
    int info_lines = 5;

    height = pane_height(side, info_lines);

    side->info = XtVaCreateWidget ("info",
        xmFormWidgetClass, side->left,
        XmNpaneMaximum, height,
        XmNpaneMinimum, height,
        NULL);

    side->info_mgr = XtVaCreateWidget ("info_mgr",
        xmFormWidgetClass, side->info,
        XmNfractionBase, 4,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_FORM,
        NULL);

    side->info_misc2 = XtVaCreateManagedWidget ("info_misc2",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 2,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 3,
        XmNbottomAttachment,  XmATTACH_FORM,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_resources = XtVaCreateManagedWidget ("info_resources",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 3,
        XmNbottomAttachment,  XmATTACH_FORM,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_misc1 = XtVaCreateManagedWidget ("info_misc1",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 2,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 2,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 3,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_next_product = XtVaCreateManagedWidget ("info_next_product",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 2,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 3,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_terrain = XtVaCreateManagedWidget ("info_terrain",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 2,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 1,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 2,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_production = XtVaCreateManagedWidget ("info_production",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 1,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 2,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_handle = XtVaCreateManagedWidget ("info_handle",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 2,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 1,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    side->info_hp = XtVaCreateManagedWidget ("info_hp",
        xmLabelWidgetClass, side->info_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 1,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);
    XtManageChild (side->info_mgr);

    side->info_status = XtVaCreateManagedWidget ("info_status",
        xmLabelWidgetClass, side->info,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_WIDGET,
        XmNtopWidget, side->info_mgr,
        XmNbottomAttachment,  XmATTACH_FORM,
        XtVaTypedArg, XmNlabelString, XtRString,
            " ", 1,
        NULL);

    XtManageChild (side->info);        
}

void set_menu_sensitivity(Widget menu, Boolean sensitive) {

    XtSetSensitive(menu, sensitive);
}

void set_item_sensitivity(Side *side, int sensitivity, Boolean sensitive) {

    Sensitive_item *cur_item;

    if (sensitive)
        side->sensitivity = side->sensitivity | sensitivity;
    else
        side->sensitivity = side->sensitivity & ~sensitivity;

    cur_item = side->unit_sensitivities;
    while (cur_item != NULL) {
        if ((cur_item->sensitivity & sensitivity) != 0) {
            if (!sensitive)
                XtSetSensitive(cur_item->widget, False);
            else if ((cur_item->sensitivity & side->sensitivity) == cur_item->sensitivity)
                XtSetSensitive(cur_item->widget, True);
        }
        cur_item = cur_item->next;
    }
}

void create_unit_menu_window(Side *side) {

    Arg args[5];
    int n=0;
    int height;
    int menu_lines = 1;

    height = pane_height(side, menu_lines);
    XtSetArg(args[n], XmNpaneMaximum, height); n++;
    XtSetArg(args[n], XmNpaneMinimum, height); n++;
    side->unit_menu = XmCreateMenuBar (side->left, "unit_menu", args, n);
    side->sensitivity = 0;

    BuildPulldownMenu (side->unit_menu, side, "Consciousness", NULL, False, CONSCIOUSNESS_menu);
    BuildPulldownMenu (side->unit_menu, side, "Move", NULL, False, MOVE_menu);
    BuildPulldownMenu (side->unit_menu, side, "Production", NULL, False, PRODUCTION_menu);
    BuildPulldownMenu (side->unit_menu, side, "Transport", NULL, False, TRANSPORT_menu);
    BuildPulldownMenu (side->unit_menu, side, "Map", NULL, False, MAP_menu);
    BuildPulldownMenu (side->unit_menu, side, "Misc", NULL, False, MISC_menu);

    XtManageChild (side->unit_menu);
    set_menu_sensitivity(side->unit_menu, False);
}

void redraw_map(Widget map_w, XtPointer client_data, XtPointer call_data) {

    Side *side = (Side *)client_data;

    XmDrawingAreaCallbackStruct *cbs =
        (XmDrawingAreaCallbackStruct *)call_data;

    if (cbs->event->xexpose.count == 0) {
        if (active_display(side)) {
            XCopyArea(side->display, side->map_pix, XtWindow(side->map_area), 
                side->icongc, 0, 0,
                side->mw, side->mh, 0, 0);
            draw_cursor(side);
            return;
        }

        printf("\nX map redraw error on display %s\n", 
            DisplayString(cbs->event->xexpose.display));
    }
}

void scroll_map(Widget map_w, XtPointer client_data, XtPointer call_data) {

    Side *side = (Side *)client_data;

    XmScrollBarCallbackStruct *cbs =
        (XmScrollBarCallbackStruct *)call_data;

    if (cbs->reason == XmCR_VALUE_CHANGED) {
        if (active_display(side)) {
            show_map(side);
            return;
        }

        printf("\nX map scrolling error on display %s\n", 
            DisplayString(cbs->event->xany.display));
    }
}

void create_map_window(Side *side) {

    int min_map = 20;    
    XmFontListEntry entry1;

    side->map = XtVaCreateManagedWidget ("map",
        xmScrolledWindowWidgetClass, side->left,
        XmNpaneMinimum, (min_map * side->hch + (side->hh - side->hch)),
        XmNscrollingPolicy, XmAUTOMATIC,        
        XmNscrollBarDisplayPolicy, XmSTATIC,
        NULL);
/*    XtVaGetValues(side->map, XmNverticalScrollBar, &(side->map_sb_ver), NULL); */
/*    XtAddCallback(side->map_sb_ver, XmNvalueChangedCallback, scroll_map, (XtPointer)side); */ 

    side->mw = world.width * side->hw;
    side->mh = world.height * side->hch + (side->hh - side->hch);

    side->map_area = XtVaCreateManagedWidget ("map_area",
        xmDrawingAreaWidgetClass, side->map,
        XmNwidth, side->mw,
        XmNheight, side->mh,
        XmNresizePolicy, XmNONE,       
        XmNbackground, side->appdata.bgcolor,
        XmNforeground, side->appdata.fgcolor,
        NULL);

    side->map_pix = XCreatePixmap(side->display, 
        RootWindowOfScreen(XtScreen(side->top)), side->mw,  
        side->mh, side->default_depth);

    XtAddCallback(side->map_area, XmNexposeCallback, redraw_map, (XtPointer)side);    

    side->map_cb = NULL;

    entry1 = XmFontListEntryLoad(side->display, ICONFONT,
        XmFONT_IS_FONT, XmFONTLIST_DEFAULT_TAG);
    side->iconfontlist = XmFontListAppendEntry (NULL, entry1);
    XtFree((char *)entry1);
}

void redraw_world(Widget world_w, XtPointer client_data, XtPointer call_data) {

    Side *side = (Side *)client_data;

    XmDrawingAreaCallbackStruct *cbs =
        (XmDrawingAreaCallbackStruct *)call_data;

    if (cbs->event->xexpose.count == 0) {
        if (active_display(side)) {
            show_world(side);
            return;
        }

        printf("\nX map redraw error on display %s\n", 
            DisplayString(cbs->event->xexpose.display));
            
    }
}

void recenter_world(Widget world_w, XtPointer client_data, XtPointer call_data) {

    Side *side = (Side *)client_data;

    XmDrawingAreaCallbackStruct *cbs =
        (XmDrawingAreaCallbackStruct *)call_data;

    if (cbs->event->xany.type == ButtonPress) {
        if (active_display(side)) {
            recenter(side, cbs->event->xbutton.x, cbs->event->xbutton.y);
            return;
        }

        printf("\nX map recenter error on display %s\n", 
            DisplayString(cbs->event->xany.display));
    }
}

void create_world_window(Side *side) {

    side->mm = min(5, (max(world.width, (side->appdata.labelfont->max_bounds.width * MINRIGHT) / world.width)));

    side->worldf = XtVaCreateManagedWidget ("worldf",
        xmFrameWidgetClass, side->right,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_FORM,
        XmNshadowType, XmSHADOW_IN,
        NULL);

    side->world = XtVaCreateManagedWidget ("world",
        xmDrawingAreaWidgetClass, side->worldf,
        XmNwidth, (world.width * side->mm),
        XmNheight, (world.height * side->mm),
        XmNresizePolicy, XmNONE,
        XmNbackground, side->appdata.bgcolor,
        XmNforeground, side->appdata.fgcolor,
        NULL);

    XtAddCallback(side->world, XmNexposeCallback, redraw_world, (XtPointer)side);    
    XtAddCallback(side->world, XmNinputCallback, recenter_world, (XtPointer)side);    
}

void create_state_window(Side *side) {

    int u;
    XmFontListEntry entry1;

    side->state = XtVaCreateManagedWidget ("state",
        xmScrolledWindowWidgetClass, side->right,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 2,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->world,
        XmNscrollingPolicy, XmAUTOMATIC,        
        NULL);

    side->state_col = XtVaCreateManagedWidget ("state_col",
        xmRowColumnWidgetClass, side->state,
        NULL);

    entry1 = XmFontListEntryLoad(side->display, UNITFONT,
        XmFONT_IS_FONT, XmFONTLIST_DEFAULT_TAG);
    side->unitfontlist = XmFontListAppendEntry (NULL, entry1);
    XtFree((char *)entry1);

    for_all_unit_types(u) {

        side->unitslist[u].mgr = XtVaCreateManagedWidget ("state_mgr",
            xmRowColumnWidgetClass, side->state_col,
            XmNorientation, XmHORIZONTAL,
            NULL);

        if (utypes[u].bitmapname != NULL ) {
            side->unitslist[u].icon = XtVaCreateManagedWidget ("state_icon",
                xmPushButtonWidgetClass, side->unitslist[u].mgr,
                XmNlabelType, XmPIXMAP,
                XmNlabelPixmap, side->unitslist[u].pic,
                NULL);
        }
        else {
            side->unitslist[u].icon = XtVaCreateManagedWidget ("state_icon",
                xmPushButtonWidgetClass, side->unitslist[u].mgr,
                XtVaTypedArg, XmNlabelString, XtRString,
                    &(utypes[u].uchar), 1,
                XmNfontList,  side->unitfontlist,           
                NULL);
        }
        XtAddCallback(side->unitslist[u].icon, XmNactivateCallback, x_unit_info, (XtPointer)side);
        side->unitslist[u].state = XtVaCreateManagedWidget ("state_state",
            xmLabelGadgetClass, side->unitslist[u].mgr,
            XmNalignment, XmALIGNMENT_END,
            XtVaTypedArg, XmNlabelString, XtRString,
                "               ", 15,
            NULL);
    }
}

void create_clock_window(Side *side) {

    sprintf(spbuf, "%02d:%02d:%02d",
            global.elapsedtime/360000,		/* hours */
            (global.elapsedtime/6000)%60,	/* minutes */
            (global.elapsedtime/100)%60);	/* seconds */
    side->turnclock = XtVaCreateManagedWidget ("turnclock",
        xmPushButtonWidgetClass, side->right,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 3,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->state,
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, 8,
        NULL);
    XtAddCallback(side->turnclock, XmNactivateCallback, do_turnclock, (XtPointer)side);

    sprintf(spbuf, "%02d:%02d:%02d",
            side->timetaken/360000,		/* hours */
            (side->timetaken/6000)%60,		/* minutes */
            (side->timetaken/100)%60);		/* seconds */
    side->sideclock = XtVaCreateManagedWidget ("sideclock",
        xmPushButtonWidgetClass, side->right,
        XmNleftAttachment,  XmATTACH_WIDGET,
        XmNleftWidget, side->turnclock,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->state,
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, 8,
        NULL);
    XtAddCallback(side->sideclock, XmNactivateCallback, do_sideclock, (XtPointer)side);
}

void create_timemode_window(Side *side) {

    sprintf(spbuf, "Turn %4d", global.time);
    side->time = XtVaCreateManagedWidget ("time",
        xmPushButtonWidgetClass, side->right,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 3,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->turnclock,
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, 9,
        NULL);
    XtAddCallback(side->time, XmNactivateCallback, do_time, (XtPointer)side);

    side->sidemode = XtVaCreateManagedWidget ("sidemode",
        xmPushButtonWidgetClass, side->right,
        XmNleftAttachment,  XmATTACH_WIDGET,
        XmNleftWidget, side->time,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->turnclock,
        XtVaTypedArg, XmNlabelString, XtRString,
            "survey", 6,
        NULL);
}

void create_sides_window(Side *side) {

    Side *side2;
    Sides_status *newside;
    Sides_status *lastside=NULL;
    int n=0;
    Pixel fg;

    side->sides = XtVaCreateManagedWidget ("sides",
        xmRowColumnWidgetClass, side->right,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_WIDGET,
        XmNbottomWidget, side->time,
        NULL);

    /* Create widget list of all sides */

    for_all_sides(side2) {
        newside = (Sides_status *)malloc(sizeof(Sides_status));
        newside->side = side2;
        newside->selected = FALSE;
        newside->next = NULL;

        newside->mgr = XtVaCreateWidget ("side_mgr", 
            xmRowColumnWidgetClass, side->sides,
            XmNorientation, XmHORIZONTAL,
            NULL);

        sprintf(spbuf, "%2d%n", side_number(side2), &n);
        fg = side_color(side, side2),
        
        newside->side_no = XtVaCreateManagedWidget ("side_no", 
            xmLabelWidgetClass, newside->mgr,
            XmNforeground, fg,
            XtVaTypedArg, XmNlabelString, XtRString,
                spbuf, n,
            NULL);
        newside->status = XtVaCreateManagedWidget ("status", 
            xmLabelWidgetClass, newside->mgr,
            XtVaTypedArg, XmNlabelString, XtRString,
                " ", 1,
            NULL);
        sprintf(spbuf, "The %s%n", plural_form(side2->name), &n);
        newside->name = XtVaCreateManagedWidget ("name", 
            xmLabelWidgetClass, newside->mgr,
            XmNforeground, fg,
            XtVaTypedArg, XmNlabelString, XtRString,
                spbuf, n,
            NULL);
        if (side == side2)
            XtVaSetValues(newside->name, 
                XmNbackground, white_color(side),
                NULL);

        XtManageChild (newside->mgr);

        if (side2 == sidelist)
            side->sideslist = newside;
        else
            lastside->next = newside;
        lastside=newside;
    }                
}

/* Write text into message window */

void write_msg_text(Side *side, char *fmt, ... ) {

    va_list args;

    char msgbuf[256];
    static XmTextPosition wpr_position;

    va_start (args, fmt);
    (void) vsprintf (msgbuf, fmt, args);
    va_end (args);

    XmTextInsert (side->msg_text, wpr_position, msgbuf);
    wpr_position = wpr_position + strlen (msgbuf);
    XtVaSetValues (side->msg_text, XmNcursorPosition, wpr_position, NULL);
    XmTextShowPosition (side->msg_text, wpr_position);
}

/* Update side clock */

void draw_side_clock(Side *side, char *buf) {

    XtVaSetValues(side->sideclock, 
        XtVaTypedArg, XmNlabelString, XtRString,
            buf, 8,
        NULL);
}

/* Update turn clock */

void draw_turn_clock(Side *side, char *buf) {

    XtVaSetValues(side->turnclock, 
        XtVaTypedArg, XmNlabelString, XtRString,
            buf, 8,
        NULL);
}

/* Update units state */

void draw_state(Side *side, int u, char *buf) {

    XtVaSetValues(side->unitslist[u].state, 
        XtVaTypedArg, XmNlabelString, XtRString,
            buf, strlen(buf),
        NULL);
}

void update_sides(Side *side) {

    Sides_status *side_w;

    if (active_display(side)) {
        for (side_w = side->sideslist; side_w != NULL; side_w = side_w->next) {
            if (!side_w->side->lost) {
                if (side_w->side->more_units)
                    XtVaSetValues(side_w->status, 
                        XtVaTypedArg, XmNlabelString, XtRString,
                            "*", 1,
                        NULL);
                else
                    XtVaSetValues(side_w->status, 
                        XtVaTypedArg, XmNlabelString, XtRString,
                            " ", 1,
                        NULL);
            }
        }
    }
}

/* Show a list of all sides in action, drawing a line through any that have */
/* lost out.  This has to be called for each side if everybody's list is */
/* to be updated. */

/* Highlight the side whose turn it is, using reverse video for current */
/* player's own display (to wake she/he/it up) and white instead of gray */
/* for everybody else.  Also add a star for the benefit of monochrome. */

void draw_all_sides(Side *side) {

    Sides_status *side_w;
    int n;
    Pixel fg;

    if (active_display(side)) {
        for (side_w = side->sideslist; side_w != NULL; side_w = side_w->next) {
            sprintf(spbuf, "%2d%n", side_number(side_w->side), &n);
            fg = side_color(side, side_w->side);
            XtVaSetValues(side_w->side_no, 
                XmNforeground, fg,
                NULL);
            XtVaSetValues(side_w->side_no, 
                XtVaTypedArg, XmNlabelString, XtRString,
                    spbuf, n,
                NULL);

            sprintf(spbuf, "The %s%n", plural_form(side_w->side->name), &n);
            XtVaSetValues(side_w->side_no, 
                XmNforeground, fg,
                NULL);
            if (side == side_w->side)
                XtVaSetValues(side_w->name, 
                    XmNbackground, white_color(side),
                    NULL);
            XtVaSetValues(side_w->name, 
                XtVaTypedArg, XmNlabelString, XtRString,
                    spbuf, n,
                NULL);

            if (side_w->side->lost) {
                XmChangeColor(side_w->name, side->appdata.graycolor);
                XtVaSetValues(side_w->status, 
                    XtVaTypedArg, XmNlabelString, XtRString,
                        " ", 1,
                    NULL);
            }
        }
    }
    update_sides(side);
}

/* Update time */

void draw_time(Side *side) {

    sprintf(spbuf, "Turn %4d", global.time);
    XtVaSetValues(side->time, 
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, 9,
        NULL);
}

/* Update mode */

char *modenames[] = MODENAMES;  /* names of the modes */

void draw_mode(Side *side) {

    sprintf(spbuf, "%s%s%n",
            modenames[side->mode],
            (side->teach ? "*" : (Build ? "B" : (side->followaction ? "L" : " "))),
            &splen);
    XtVaSetValues(side->sidemode, 
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, splen,
        NULL);
}

/* Update info */

void draw_info_text(Widget info_w, char* buf) {

    XtVaSetValues(info_w, 
        XtVaTypedArg, XmNlabelString, XtRString,
            buf, strlen(buf),
        NULL);
}

void add_move_callbacks(Side *side) {

    XtAddCallback(side->sidemode, XmNactivateCallback, do_survey_mode, (XtPointer)side);
    XtAddCallback(side->map_area, XmNinputCallback, do_map, (XtPointer)side);
    set_menu_sensitivity(side->unit_menu, True);
}

void remove_move_callbacks(Side *side) {

    XtRemoveCallback(side->sidemode, XmNactivateCallback, do_survey_mode, (XtPointer)side);
    XtRemoveCallback(side->map_area, XmNinputCallback, do_map, (XtPointer)side);
    set_menu_sensitivity(side->unit_menu, False);
}

void remove_map_callbacks(Side *side) {

    if (side->map_cb != NULL) {
        XtRemoveCallback(side->map_area, XmNinputCallback, side->map_cb, (XtPointer)side);
        side->map_cb = NULL;
    }
}

void start_dialog(Side *side, char *name, char *prompt) {

    side->dialog = XtVaCreatePopupShell("dialog", 
        xmDialogShellWidgetClass, side->map,
        XmNtitle, name,
        XmNdeleteResponse, XmDESTROY,
        NULL);
    side->dialog_mgr = XtVaCreateWidget("dialog_mgr",
        xmPanedWindowWidgetClass, side->dialog,
        XmNsashWidth, 1,
        XmNsashHeight, 1,
        NULL);
    side->dialog_prompt = XtVaCreateManagedWidget("dialog_prompt",
        xmLabelGadgetClass, side->dialog_mgr,
        XtVaTypedArg, XmNlabelString, XtRString,
            prompt, strlen(prompt),
        NULL);
}

void finish_dialog(Side *side) {

    XtAddCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtManageChild(side->dialog_mgr);
    XtPopup(side->dialog, XtGrabNone);
}

void create_unit_dialog(Side *side, char *prompt, int default_type, void (*product_callback)()) {

    short u;
    int rows = 0;
    Widget unit_w;

    start_dialog(side, "products", prompt);

    side->dialog_action_mgr = XtVaCreateWidget("dialog_action_mgr", 
        xmRowColumnWidgetClass, side->dialog_mgr,
        XmNorientation, XmHORIZONTAL,
        XmNpacking, XmPACK_COLUMN,
        NULL);        

    for_all_unit_types(u) {
        if (side->unitslist[u].bvec) {
            unit_w = XtVaCreateWidget("unit", 
                xmRowColumnWidgetClass, side->dialog_action_mgr,
                XmNorientation, XmHORIZONTAL,
                NULL);        
            if (utypes[u].bitmapname != NULL ) {
                side->dialog_action[u] = XtVaCreateWidget ("dialog_action",
                    xmPushButtonWidgetClass, unit_w,
                    XmNlabelType, XmPIXMAP,
                    XmNlabelPixmap, side->unitslist[u].pic,
                    XmNdefaultButtonShadowThickness, 1,
                    NULL);
            }
            else {
                side->dialog_action[u] = XtVaCreateWidget("dialog_action",
                    xmPushButtonWidgetClass, unit_w,
                    XtVaTypedArg, XmNlabelString, XtRString,
                        &(utypes[u].uchar), 1,
                    XmNfontList,  side->unitfontlist,           
                    XmNdefaultButtonShadowThickness, 1,
                    NULL);
            }
            if (default_type == u) {
                XtVaSetValues(side->dialog_action[u],
                    XmNshowAsDefault, 1,
                    NULL);
            }
            XtManageChild(side->dialog_action[u]);
            XtAddCallback(side->dialog_action[u], XmNactivateCallback, product_callback, (XtPointer)side);

            XtVaCreateManagedWidget ("unit_name",
                xmLabelGadgetClass, unit_w,
                XmNalignment, XmALIGNMENT_BEGINNING,
                XtVaTypedArg, XmNlabelString, XtRString,
                    utypes[u].name, strlen(utypes[u].name),
                NULL);
            rows++;
            XtManageChild(unit_w);
        }
        else 
            side->dialog_action[u] = NULL;
    }
    XtVaSetValues(side->dialog_action_mgr,
        XmNnumColumns, rows,
        NULL);

    XtManageChild(side->dialog_action_mgr);
    finish_dialog(side);
}

void create_dir_dialog(Side *side, char *prompt) {

    Pixmap pixmap;

    start_dialog(side, "set_direction", prompt);

    side->dialog_action_mgr = XtVaCreateWidget("dialog_action_mgr",
        xmFormWidgetClass, side->dialog_mgr, 
        XmNfractionBase, 3,
        NULL);        

    strcpy(spbuf, XCONQLIB "/dir_hex.b_m");
    pixmap = XmGetPixmap(XtScreen(side->top), spbuf, 
        side->appdata.fgcolor, side->appdata.bgcolor);
    if (pixmap == XmUNSPECIFIED_PIXMAP)
        printf("Could not load directional hex pixmap %s\n", spbuf);

    XtVaCreateManagedWidget("dir_hex",
        xmLabelWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 1,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 2,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_FORM,
        XmNlabelType, XmPIXMAP,
        XmNlabelPixmap, pixmap,
        NULL);
    
    side->dialog_action[NW] = XtVaCreateManagedWidget("arrow_NW",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 1,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 1,
        XtVaTypedArg, XmNlabelString, XtRString,
            "NW", 2,
        NULL);
    XtAddCallback(side->dialog_action[NW], XmNactivateCallback, x_coast, (XtPointer)side);

    side->dialog_action[NE] = XtVaCreateManagedWidget("arrow_NE",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_FORM,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 1,
        XtVaTypedArg, XmNlabelString, XtRString,
            "NE", 2,
        NULL);
    XtAddCallback(side->dialog_action[NE], XmNactivateCallback, x_coast, (XtPointer)side);

    side->dialog_action[WEST] = XtVaCreateManagedWidget("arrow_WEST",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 1,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 1,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 2,
        XtVaTypedArg, XmNlabelString, XtRString,
            "W", 1,
        NULL);
    XtAddCallback(side->dialog_action[WEST], XmNactivateCallback, x_coast, (XtPointer)side);

    side->dialog_action[EAST] = XtVaCreateManagedWidget("arrow_EAST",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 1,
        XmNbottomAttachment,  XmATTACH_POSITION,
        XmNbottomPosition, 2,
        XtVaTypedArg, XmNlabelString, XtRString,
            "E", 1,
        NULL);
    XtAddCallback(side->dialog_action[EAST], XmNactivateCallback, x_coast, (XtPointer)side);

    side->dialog_action[SW] = XtVaCreateManagedWidget("arrow_SW",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_FORM,
        XmNrightAttachment,  XmATTACH_POSITION,
        XmNrightPosition, 1,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 2,
        XmNbottomAttachment,  XmATTACH_FORM,
        XtVaTypedArg, XmNlabelString, XtRString,
            "SW", 2,
        NULL);
    XtAddCallback(side->dialog_action[SW], XmNactivateCallback, x_coast, (XtPointer)side);

    side->dialog_action[SE] = XtVaCreateManagedWidget("arrow_SE",
        xmPushButtonWidgetClass, side->dialog_action_mgr,
        XmNleftAttachment,  XmATTACH_POSITION,
        XmNleftPosition, 2,
        XmNrightAttachment,  XmATTACH_FORM,
        XmNtopAttachment,  XmATTACH_POSITION,
        XmNtopPosition, 2,
        XmNbottomAttachment,  XmATTACH_FORM,
        XtVaTypedArg, XmNlabelString, XtRString,
            "SE", 2,
        NULL);
    XtAddCallback(side->dialog_action[SE], XmNactivateCallback, x_coast, (XtPointer)side);

    XtManageChild(side->dialog_action_mgr);

    finish_dialog(side);
}

void create_give_dialog(Side *side, char *prompt, void (*callback)()) {

    Side *side2;
    int n=0;
    
    start_dialog(side, "select_side", prompt);

    side->dialog_action_mgr = XmCreateRadioBox(side->dialog_mgr, 
        "dialog_action_mgr", NULL, 0);        

    for_all_sides(side2) {
        if (side != side2) {
            side->dialog_action[n] = XtVaCreateManagedWidget("dialog_action",
                xmToggleButtonWidgetClass, side->dialog_action_mgr,
                XtVaTypedArg, XmNlabelString, XtRString,
                    side2->name, strlen(side2->name),
                NULL);
            XtAddCallback(side->dialog_action[n], XmNvalueChangedCallback, callback, (XtPointer)side);
            n++;
        }
    }
    XtManageChild(side->dialog_action_mgr);

    finish_dialog(side);
}

void create_map_dialog(Side *side, char *prompt, char *name, 
    void (*map_callback)(), void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;

    strcpy(spbuf, "Use mouse to ");
    strcat(spbuf, prompt);
    msg_str = XmStringCreateLocalized(spbuf);
    XtSetArg(args[n], XmNmessageString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->dialog = XmCreateMessageDialog(side->map, name, args, n);
    XmStringFree(msg_str);


    XtAddCallback(side->map_area, XmNinputCallback, map_callback, (XtPointer)side);
    side->map_cb = map_callback;
    XtAddCallback(side->dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->dialog, XmNcancelCallback, cancel_dialog, (XtPointer)side);
    XtAddCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtSetSensitive(
        XmMessageBoxGetChild(side->dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->dialog);
    XtPopup(XtParent(side->dialog), XtGrabNone);
}

void create_prompt_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;

    msg_str = XmStringCreateLocalized(prompt);
    XtSetArg(args[n], XmNselectionLabelString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->dialog = XmCreatePromptDialog(side->map, name, args, n);
    XmStringFree(msg_str);
    XtAddCallback(side->dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->dialog, XmNcancelCallback, cancel_dialog, (XtPointer)side);
    XtAddCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtSetSensitive(
        XmSelectionBoxGetChild(side->dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->dialog);
    XtPopup(XtParent(side->dialog), XtGrabNone);
}

void create_question_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;

    msg_str = XmStringCreateLocalized(prompt);
    XtSetArg(args[n], XmNmessageString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->dialog = XmCreateQuestionDialog(side->map, name, args, n);
    XmStringFree(msg_str);
    XtAddCallback(side->dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->dialog, XmNcancelCallback, cancel_dialog, (XtPointer)side);
    XtAddCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtSetSensitive(
        XmMessageBoxGetChild(side->dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->dialog);
    XtPopup(XtParent(side->dialog), XtGrabNone);
}

void destroy_dialog(Side *side) {

    XtRemoveCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    if (XmIsDialogShell(side->dialog))
        XtDestroyWidget(side->dialog);
    else
        XtDestroyWidget(XtParent(side->dialog));
    side->dialog = NULL;
}

bool dialog_active(Side *side) {

    if (side->dialog != NULL)
        return TRUE;
    else
        return FALSE;
}

bool side_dialog_active(Side *side) {

    if (side->side_dialog != NULL)
        return TRUE;
    else
        return FALSE;
}

void destroy_side_dialog(Side *side) {

    XtRemoveCallback(side->side_dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    if (XmIsDialogShell(side->side_dialog))
        XtDestroyWidget(side->side_dialog);
    else
        XtDestroyWidget(XtParent(side->side_dialog));
    side->side_dialog = NULL;
}

void create_options_dialog(Side *side, char *prompt, char *name,
    void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;

    msg_str = XmStringCreateLocalized(prompt);
    XtSetArg(args[n], XmNselectionLabelString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->side_dialog = XmCreatePromptDialog(side->main, name, args, n);
    XmStringFree(msg_str);
    XtAddCallback(side->side_dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNcancelCallback, cancel_side_dialog, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
    XtSetSensitive(
        XmSelectionBoxGetChild(side->side_dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->side_dialog);
    XtPopup(XtParent(side->side_dialog), XtGrabNone);
}

void create_msg_dialog(Side *side) {

    XmString msg_str;
    Arg args[5];
    int n=0;
    Side *side2;

    msg_str = XmStringCreateLocalized("Broadcast:");
    XtSetArg(args[n], XmNselectionLabelString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->side_dialog = XmCreatePromptDialog(side->main, side->name, args, n);
    XmStringFree(msg_str);
    XtVaSetValues(XmSelectionBoxGetChild(side->side_dialog, XmDIALOG_TEXT), 
        XmNcolumns, 80,
        NULL);        

    side->side_dialog_action_mgr = XtVaCreateWidget("side_dialog_action_mgr",
        xmRowColumnWidgetClass, side->side_dialog, 
        XmNorientation, XmVERTICAL,
        NULL);        

    n = 0;
    for_all_sides(side2) {
        if (side != side2) {
            side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
                xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
                XtVaTypedArg, XmNlabelString, XtRString,
                    side2->name, strlen(side2->name),
                NULL);
            XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_sidelist, (XtPointer)side);
            n++;
        }
    }
    XtManageChild(side->side_dialog_action_mgr);

    XtAddCallback(side->side_dialog, XmNokCallback, x_message, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNcancelCallback, cancel_side_dialog, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
    XtSetSensitive(
        XmSelectionBoxGetChild(side->side_dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->side_dialog);
    XtPopup(XtParent(side->side_dialog), XtGrabNone);
}

void create_declare_dialog(Side *side, char *name, char *prompt, void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;
    Side *side2;

    msg_str = XmStringCreateLocalized(prompt);
    XtSetArg(args[n], XmNmessageString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->side_dialog = XmCreateMessageDialog(side->main, name, args, n);
    XmStringFree(msg_str);

    side->side_dialog_action_mgr = XtVaCreateWidget("side_dialog_action_mgr",
        xmRowColumnWidgetClass, side->side_dialog, 
        XmNorientation, XmVERTICAL,
        NULL);        

    n = 0;
    for_all_sides(side2) {
        if (side != side2) {
            side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
                xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
                XtVaTypedArg, XmNlabelString, XtRString,
                    side2->name, strlen(side2->name),
                NULL);
            XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_sidelist2, (XtPointer)side);
            n++;
        }
    }
    XtManageChild(side->side_dialog_action_mgr);

    XtAddCallback(side->side_dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNcancelCallback, cancel_side_dialog, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
    XtSetSensitive(
        XmMessageBoxGetChild(side->side_dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->side_dialog);
    XtPopup(XtParent(side->side_dialog), XtGrabNone);
}

void create_game_dialog(Side *side, char *prompt, char *name, 
    void (*ok_callback)()) {

    XmString msg_str;
    Arg args[5];
    int n=0;

    msg_str = XmStringCreateLocalized(prompt);
    XtSetArg(args[n], XmNmessageString, msg_str); n++;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->side_dialog = XmCreateWarningDialog(side->main, name, args, n);
    XmStringFree(msg_str);
    XtAddCallback(side->side_dialog, XmNokCallback, ok_callback, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNcancelCallback, cancel_side_dialog, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
    XtSetSensitive(
        XmMessageBoxGetChild(side->side_dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->side_dialog);
    XtPopup(XtParent(side->side_dialog), XtGrabNone);
}

/* Leave screen up so everybody can study it, and allow any input to take */
/* it down.  OK to freeze all the other sides at once here. */

void wait_to_exit(Side *side, void (*cancel_callback)()) {

    XmString msg_str, cancel_str;
    Arg args[10];
    int n=0;

    if (!humanside(side) || !active_display(side))
        return;

    if (side->side_dialog != NULL) {
        XtRemoveCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
        XtDestroyWidget(side->side_dialog);
    }

    msg_str = XmStringCreateLocalized("OK to exit?");
    XtSetArg(args[n], XmNmessageString, msg_str); n++;
    cancel_str = XmStringCreateLocalized("OK");
    XtSetArg(args[n], XmNcancelLabelString, cancel_str); n++;
/*    XtSetArg(args[n], XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL); n++; */
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    side->side_dialog = XmCreateWarningDialog(side->main, "exit", args, n);
    XmStringFree(msg_str);

    XtAddCallback(side->side_dialog, XmNcancelCallback, cancel_callback, (XtPointer)side);
    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_callback, (XtPointer)side);
    XtUnmanageChild(XmMessageBoxGetChild(side->side_dialog, XmDIALOG_OK_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(side->side_dialog, XmDIALOG_HELP_BUTTON));

    XtManageChild(side->side_dialog);
    XtPopup(XtParent(side->side_dialog), XtGrabNone);
}

void create_find_dialog(Side *side, Specific_unit *firstunit, int items_size) {

    XmString msg_str, *unit_str;
    Arg args[10];
    int n=0;
    Specific_unit *curunit;

    XtRemoveCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtDestroyWidget(side->dialog);

    msg_str = XmStringCreateLocalized("Select a unit type:");

    unit_str = (XmString *)malloc(items_size * sizeof(XmString));
    curunit = firstunit;
    while (n < items_size && curunit != NULL) {
        unit_str[n] = XmStringCreateLocalized(short_unit_handle(curunit->unit));
        curunit = curunit->next;
        n++;
    }

    n = 0;
    XtSetArg(args[n], XmNdeleteResponse, XmDESTROY); n++;
    XtSetArg(args[n], XmNlistLabelString, msg_str); n++;
    XtSetArg(args[n], XmNlistItems, unit_str); n++;
    XtSetArg(args[n], XmNlistItemCount, items_size); n++;
    XtSetArg(args[n], XmNmustMatch, True); n++;
    side->dialog = XmCreateSelectionDialog(side->map, "find_unit", args, n);

    XmStringFree(msg_str);
    for (n = 0; n < items_size; n++)
        XmStringFree(unit_str[n]);
    XtFree((XtPointer)unit_str);

    XtAddCallback(side->dialog, XmNokCallback, x_flash_unit, (XtPointer)firstunit);
    XtAddCallback(side->dialog, XmNnoMatchCallback, x_flash_unit, (XtPointer)side);
    XtAddCallback(side->dialog, XmNcancelCallback, cancel_dialog, (XtPointer)side);
    XtAddCallback(side->dialog, XmNdestroyCallback, cancel_dialog, (XtPointer)side);
    XtUnmanageChild(XmSelectionBoxGetChild(side->dialog, XmDIALOG_APPLY_BUTTON));
    XtSetSensitive(
        XmSelectionBoxGetChild(side->dialog, XmDIALOG_HELP_BUTTON), False);

    XtManageChild(side->dialog);
    XtPopup(XtParent(side->dialog), XtGrabNone);
}

/* Write text into help window */

void write_help_text(Side *side, char *fmt, ... ) {

    va_list args;

    char msgbuf[256];
    static XmTextPosition wpr_position;

    va_start (args, fmt);
    (void) vsprintf (msgbuf, fmt, args);
    va_end (args);

    XmTextInsert (side->help_text, wpr_position, msgbuf);
    wpr_position = wpr_position + strlen (msgbuf);
    XtVaSetValues (side->help_text, XmNcursorPosition, wpr_position, NULL);
    XmTextShowPosition (side->help_text, wpr_position);
}

void map_help_dialog(Side *side) {

    Widget help_sb;

    if (wline > 48) wline = 48;
    XtVaSetValues (side->help_text,
        XmNrows, wline,
        NULL);

    XtManageChild(side->help_dialog_mgr);
    XtPopup(side->help_dialog, XtGrabNone);

    XtVaGetValues(XtParent(side->help_text), 
        XmNverticalScrollBar, &(help_sb),
        NULL);
    XmScrollBarSetValues(help_sb, 
        0, wline, 1, 10, True);
        
}

void create_utype_dialog(Side *side, int u) {

    Widget help_text_mgr;

    side->help_dialog = XtVaCreatePopupShell("help_dialog", 
        xmDialogShellWidgetClass, side->state,
        XmNtitle, "unit_description",
        XmNdeleteResponse, XmDESTROY,
        NULL);
    side->help_dialog_mgr = XtVaCreateWidget("help_dialog_mgr",
        xmPanedWindowWidgetClass, side->help_dialog,
        XmNsashWidth, 1,
        XmNsashHeight, 1,
        NULL);

    side->help_dialog_control = XtVaCreateWidget("help_dialog_control",
        xmRowColumnWidgetClass, side->help_dialog_mgr,
        XmNorientation, XmHORIZONTAL,
        NULL);        
    if (utypes[u].bitmapname != NULL ) {
        XtVaCreateManagedWidget ("unit_icon",
            xmLabelWidgetClass, side->help_dialog_control,
            XmNlabelType, XmPIXMAP,
            XmNlabelPixmap, side->unitslist[u].pic,
            NULL);
    }
    else {
        XtVaCreateManagedWidget("unit_icon",
            xmLabelWidgetClass, side->help_dialog_control,
            XtVaTypedArg, XmNlabelString, XtRString,
                &(utypes[u].uchar), 1,
            XmNfontList,  side->unitfontlist,           
            NULL);
    }
    sprintf(spbuf, "%s (%s)", utypes[u].name, utypes[u].help);
    XtVaCreateManagedWidget ("unit_name",
        xmLabelGadgetClass, side->help_dialog_control,
        XmNalignment, XmALIGNMENT_BEGINNING,
        XtVaTypedArg, XmNlabelString, XtRString,
            spbuf, strlen(spbuf),
        NULL);

    help_text_mgr = XtVaCreateManagedWidget ("text_mgr",
        xmScrolledWindowWidgetClass, side->help_dialog_mgr,
        XmNscrollingPolicy, XmAPPLICATION_DEFINED,
        XmNvisualPolicy, XmVARIABLE,
        XmNscrollBarDisplayPolicy, XmSTATIC,
        NULL);
    side->help_text = XtVaCreateManagedWidget ("text",
        xmTextWidgetClass, help_text_mgr,
        XmNcolumns, 80,
        XmNeditable, False,
        XmNeditMode, XmMULTI_LINE_EDIT,
        XmNwordWrap, True,
        XmNscrollHorizontal, False,
        XmNcursorPositionVisible, False,
        NULL);        
    XtManageChild(side->help_dialog_control);
}

void create_legend_dialog(Side *side) {

    Widget icon_w;
    int t;

    side->help_dialog = XtVaCreatePopupShell("help_dialog", 
        xmDialogShellWidgetClass, side->state,
        XmNtitle, "terrain_legend",
        XmNdeleteResponse, XmDESTROY,
        NULL);
    side->help_dialog_mgr = XtVaCreateWidget("help_dialog_mgr",
        xmPanedWindowWidgetClass, side->help_dialog,
        XmNsashWidth, 1,
        XmNsashHeight, 1,
        NULL);

    side->help_dialog_control = XtVaCreateWidget("help_dialog_control",
        xmRowColumnWidgetClass, side->help_dialog_mgr,
        XmNorientation, XmVERTICAL,
        XmNpacking, XmPACK_COLUMN,
        NULL);        

    for_all_terrain_types(t) {
        icon_w = XtVaCreateWidget("icon", 
            xmRowColumnWidgetClass, side->help_dialog_control,
            XmNorientation, XmHORIZONTAL,
            NULL);        
        XtVaCreateManagedWidget("terrain_icon",
            xmLabelWidgetClass, icon_w,
            XtVaTypedArg, XmNlabelString, XtRString,
                &(ttypes[t].tchar), 1,
            XmNfontList,  side->iconfontlist,
            XmNbackground, side->hexcolor[t],         
            XmNforeground, side->appdata.bgcolor,         
            NULL);
        
        XtVaCreateManagedWidget ("terrain_name",
            xmLabelGadgetClass, icon_w,
            XmNalignment, XmALIGNMENT_BEGINNING,
            XtVaTypedArg, XmNlabelString, XtRString,
                ttypes[t].name, strlen(ttypes[t].name),
            NULL);
        XtManageChild(icon_w);
    }
    XtManageChild(side->help_dialog_control);

    XtManageChild(side->help_dialog_mgr);
    XtPopup(side->help_dialog, XtGrabNone);
}

void create_showmode_dialog(Side *side) {

    int n=0;

    side->side_dialog = XtVaCreatePopupShell("display_mode", 
        xmDialogShellWidgetClass, side->main,
        XmNdeleteResponse, XmDESTROY,
        NULL);
    side->side_dialog_mgr = XtVaCreateWidget("display_mode_mgr",
        xmPanedWindowWidgetClass, side->side_dialog,
        XmNsashWidth, 1,
        XmNsashHeight, 1,
        NULL);

    side->side_dialog_action_mgr = XmCreateRadioBox(side->side_dialog_mgr, 
        "dialog_action_mgr", NULL, 0);        

    side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
        xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
        XtVaTypedArg, XmNlabelString, XtRString,
            "Full Hex", 8,
        NULL);
    XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_showmode, (XtPointer)side);
    n++;

    side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
        xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
        XtVaTypedArg, XmNlabelString, XtRString,
            "Border Hex", 10,
        NULL);
    XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_showmode, (XtPointer)side);
    n++;

    side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
        xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
        XtVaTypedArg, XmNlabelString, XtRString,
            "Terrain Hex", 11,
        NULL);
    XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_showmode, (XtPointer)side);
    n++;

    side->side_dialog_action[n] = XtVaCreateManagedWidget("side_dialog_action",
        xmToggleButtonWidgetClass, side->side_dialog_action_mgr,
        XtVaTypedArg, XmNlabelString, XtRString,
            "Full Terrain Hex", 16,
        NULL);
    XtAddCallback(side->side_dialog_action[n], XmNvalueChangedCallback, x_showmode, (XtPointer)side);
    n++;

    XtManageChild(side->side_dialog_action_mgr);

    XtAddCallback(side->side_dialog, XmNdestroyCallback, cancel_side_dialog, (XtPointer)side);
    XtManageChild(side->side_dialog_mgr);
    XtPopup(side->side_dialog, XtGrabNone);
}

void create_help_dialog(Side *side) {

    Widget help_text_mgr;

    side->help_dialog = XtVaCreatePopupShell("help_dialog", 
        xmDialogShellWidgetClass, side->state,
        XmNtitle, "side_help",
        XmNdeleteResponse, XmDESTROY,
        NULL);
    side->help_dialog_mgr = XtVaCreateWidget("help_dialog_mgr",
        xmPanedWindowWidgetClass, side->help_dialog,
        XmNsashWidth, 1,
        XmNsashHeight, 1,
        NULL);


    help_text_mgr = XtVaCreateManagedWidget ("text_mgr",
        xmScrolledWindowWidgetClass, side->help_dialog_mgr,
        XmNscrollingPolicy, XmAPPLICATION_DEFINED,
        XmNvisualPolicy, XmVARIABLE,
        XmNscrollBarDisplayPolicy, XmSTATIC,
        NULL);
    side->help_text = XtVaCreateManagedWidget ("text",
        xmTextWidgetClass, help_text_mgr,
        XmNcolumns, 80,
        XmNeditable, False,
        XmNeditMode, XmMULTI_LINE_EDIT,
        XmNwordWrap, True,
        XmNscrollHorizontal, False,
        XmNcursorPositionVisible, False,
        NULL);        
}
