/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* Copyright (c) 1995 Michael J. Peters */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

#define PROGRAMNAME "mconq"
#define PROGRAMCLASS "MConq"

#define CLOCK_INTERVAL 100	/* a second */

typedef short HexDisplayMode;
extern char *hexdispmodes[];

/* External functions */
extern void init_Xt();
extern int open_display(Side *side, int argc, char *argv[]);
extern Pixel white_color(Side *side);
extern Pixel black_color(Side *side);
extern Pixel request_color(Side *side, char *colorname);
extern void change_bgcolor(Side *side, Pixel bgcolor);
extern void init_colors(Side *side);
extern Pixel side_color(Side *side, Side *side2);
extern int init_misc(Side *side);
extern void fixup_windows(Side *side);

extern void close_display(Side *side);
extern void flush_output(Side *side);
extern void flush_events();
extern void process_events();
extern void init_sighandlers();

extern void stop_timer();
extern void start_timer();
extern void beep(Side *side);
extern void clear_window(Side *side, Window win);
extern void clear_map_pix(Side *side);
extern void draw_terrain_row(Side *side, int sx, int sy, char *buf, int len, Pixel color);
extern void draw_hex_icon(Side *side, int sx, int sy, char t, Pixel color);
extern void draw_unit_icon(Side *side, int x, int y, int u, Pixel color);
extern void draw_side_number(Side *side, int sx, int sy, int n, Pixel color);
extern void invert_whole_map(Side *side);
extern void draw_mushroom(Side *side, int x, int y, int i);
extern void draw_blast_icon(Side *side, int sx, int sy, char type, Pixel color);
extern void flash_position(Side *side, int sx, int sy, int tm);
extern void draw_cursor_icon(Side *side, int sx, int sy);
extern void draw_bar(Side *side, int x, int y, int len, Pixel color);
extern void invert_box(Side *side, int vcx, int vcy);
extern void add_work_proc(Boolean (*work_proc)(XtPointer));
