/* Copyright (c) 1987, 1988  Stanley T. Shebs. */
/* Copyright (c) 1995 Michael J. Peters */
/* This program may be used, copied, modified, and redistributed freely */
/* for noncommercial purposes, so long as this notice remains intact. */

/* Definitions about sides need terrain.h, unit.h, map.h */

#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <Xm/Xm.h>


/* Modes governing the interpretation of input. */

#define WEDGED    0
#define MOVE      1
#define SURVEY    2

/* These are 7-char strings (except for the first) so hiliting works right. */

#define MODENAMES { "       ", "  Move ", " Survey" }

#define REASONNAMES \
  { "Ini", "Pro", "Cap", "   ", "Cbt", "Pri", "Gar", "Acc", "Sup", "Dis", \
    "Sur", "Win", "End", "Gift" }

/* Input request results - tells what came back as answer to a request. */

#define GARBAGE  0
#define KEYBOARD 1
#define MAPPOS   2
#define UNITTYPE 3
#define SCROLLUP 4
#define SCROLLDOWN 5

/* Color display modes. */

#define NUMSHOWMODES 4

#define FULLHEX   0
#define BORDERHEX 1
#define TERRICONS 2
#define BOTHICONS 3

/* Attitude boundaries of one side with respect to another. */

#define ENEMY   (-100)
#define NEUTRAL     0
#define ALLY      100

/* Possible ideologies of a machine player - determines general behavior. */
/* Very crude - really more for color than anything else. */

#define EXPANSIONIST 0
#define ISOLATIONIST 1
#define FASCIST      2
#define FANATICAL    3
#define DEMOCRATIC   4

/* Some convenient macros. */

#define humanside(x) ((x) != NULL && (x)->humanp)

/* Iteration over all sides. */

#define for_all_sides(v) for (v = sidelist; v != NULL; v = v->next)

/* Manipulation of bytes encoding views of things. */
/* Types 254, 255 reserved for "seen but unoccupied" and "unseen". */

#define buildview(s,t) (((s)<<8)|(t))


#define vside(v) ((short)(((short)(v)>>8) & 0x0ff))
/* #define vside(v) ((v).side) */
#define vtype(v) ((short)((v) & 0xff))
/* #define vtype(v) ((v).utype) */
#define vside_neutral(v) ((vside(v) == vside(buildview(MAXSIDES,0))))


#define UNSEEN (MAXUTYPES)
#define EMPTY  (MAXUTYPES+1)

#define side_view(s,x,y) ( ((s)->view)[world.width*(y)+(x)] )

#define cover(s,x,y) (((s)->coverage)[world.width*(y)+(x)])

#define set_cover(s,x,y,v) (((s)->coverage)[world.width*(y)+(x)] = (v))

#define add_cover(s,x,y,v) (((s)->coverage)[world.width*(y)+(x)] += (v))

#ifdef PREVVIEW
#define side_view_timestamp(s,x,y) (((s)->viewtimestamp)[world.width*(y)+(x)])

#define side_view_age(s,x,y) \
            ((cover(s,x,y) > 0) ? 0 : \
	     (global.time - (((s)->viewtimestamp)[world.width*(y)+(x)])))

#define side_prevview(s,x,y) (((s)->prevview)[world.width*(y)+(x)])
#endif

/* Reasons for gains and losses of units. */

#define NUMREASONS 14

#define FIRSTUNIT   0
#define PRODUCED    1
#define CAPTURE     2
#define DUMMYREAS   3
#define COMBAT      4
#define PRISONER    5
#define GARRISON    6
#define DISASTER    7
#define STARVATION  8
#define DISBAND     9
#define SURRENDER  10
#define VICTOR     11
#define ENDOFWORLD 12
#define GIFT       13

/* An area of control is a block that is treated as a single */
/* location. All information on the whole area is combined so that the */
/* machine can do some planning.  */

typedef struct a_control_area {
  short enemy_strength;   /* Estimate of enemy unit strength */
  short enemy_seen_recently; /* How many enemy have we seen in last */
			     /* turn. */
  short units_lost;       /* How many units have we lost here. */
			  /* Weighted average of last few turns. */
  short capturers_approaching; /* number of units comming to capture bases */
  short capture_time;     /* When do we expect to have capturers here */
  short safe_area;        /* do we really need to move units here */
} Control_area;

typedef struct {
    XFontStruct *labelfont;	/* default label font */
    XFontStruct *iconfont;	/* utility font with assorted icons */
    XFontStruct *unitfont;	/* font for unit characters */
    short showmode;		/* one of four color display modes */
    Pixel bgcolor;		/* background color */
    Pixel owncolor;		/* color for us (usually black) */
    Pixel altcolor;		/* another color for us (usually blue) */
    Pixel diffcolor;		/* unusual/distinct color (usually maroon) */
    Pixel fgcolor;		/* foreground color */
    Pixel bdcolor;		/* color for borders */
    Pixel graycolor;		/* color for graying out (usually gray) */
    Pixel enemycolor;		/* color for them (usually red) */
    Pixel neutcolor;		/* color for fencesitters (usually gray) */
    Pixel goodcolor;		/* color for OKness (usually green) */
    Pixel badcolor;		/* color for none-OKness (usually red) */
} AppData;

#define NUM_SENSITIVITIES 2
#define NOT_SENSITIVE 0
#define SURVEY_SENSITIVE 1
#define UNIT_SENSITIVE 2
#define PRODUCE_SENSITIVE 4

typedef struct a_sensitive_item{
    Widget widget;
    int sensitivity;
    struct a_sensitive_item *next;
} Sensitive_item;

/* Sides unit list */

typedef struct a_sides_unit {
  Widget mgr;		/* Row manager for a unit */
  Widget name;		/* Unit name */
  Widget icon;		/* Unit icon (char or Pixmap) */
  Pixmap pic;		/* used instead of font sometimes in labels */
  Pixmap mask;		/* used instead of font sometimes in map area */
  Widget state;		/* Unit status (units(building) total_gain total_loss) */

  short units;		/* cached count of units */
  short building;	/* cached count of units being built */

  bool bvec;		/* bit vector of allowed unit types to input */
} Sides_unit;
			     
typedef unsigned short viewdata;

/* Each xconq player is a "side" - more or less one country.  A side may or */
/* may not be played by a person, and may or may not have a display attached */
/* to it.  Each side has a different view of the world.  Zillions of slots */
/* are needed because each side needs to keep its own interaction/display */
/* data - a side is almost like a full-blown process... */

typedef struct a_side {
    /* Level 1 detail */
    char *name;			/* name used for display */

    /* Level 2 detail */
    short ideology;           /* what kind of people are on this side */
    short attitude[MAXSIDES];   /* war/peace/ally status of other sides */
    short counts[MAXUTYPES];	/* array of numbers for identifying units */

    /* Level 3 detail */
    viewdata *view;		/* pointer to array of view info */
#ifdef LARGE
    short *viewtimestamp;	/* indicates when we last looked at this hex */
    viewdata *prevview;		/* what we saw before what we see now. */
#endif

    /* Level 4 detail */
    short humanp;		/* is this side played by a person? */
    short lost;			/* true if this side was knocked out */
    short cx, cy;		/* current center of player's focus */
    struct a_unit *markunit;	/* unit being remembered for later use */
    long timetaken;		/* seconds played by this side */
    char timetakenbuf[9];	/* seconds played by this side (ascii) */
    bool timedout;		/* true when clock has run out for this side */
    short itertime;		/* length of order repetition */

    /* Statistics */
    short balance[MAXUTYPES][NUMREASONS];  /* what happened to units */
    short atkstats[MAXUTYPES][MAXUTYPES];  /* how many attacks */
    short hitstats[MAXUTYPES][MAXUTYPES];  /* how many hits */

    /* Never saved */
    struct a_unit *unithead;	/* all units on the side */
    short mode;			/* player's mode (move/survey) */
    int curx, cury;		/* current spot being looked at */
    struct a_unit *curunit;	/* unit under cursor */
    struct a_unit *movunit;	/* unit being moved currently */
    struct a_unit *last_unit;	/* last unit moved */
    bool more_units;		/* TRUE if more units to more this turn */
    short directorder;		/* true if order has just been given */
    short *coverage;		/* indicates how many looking at this hex */
    short resources[MAXRTYPES];	/* cached count of resources */
    bool followaction;		/* move to where a change has occured */

    /* machine player */
    long plan;			/* all the machine's strategy and tactics */
    struct a_unit *unitlist[MAXUTYPES];	/* lists to help mplay efficiency */
    short unitlistcount[MAXUTYPES];	/* counts of above lists */
    int numunits;		/* number of units the side has */

    /* Higher level control information for machine */
    Control_area *areas;

    /* Random input data slots */
    int reqx, reqy;		/* map Screen coordinates */
    struct a_unit *tmpcurunit;	/* saved value of curunit */
    int tmpcurx, tmpcury;	/* saved values of curx and cury */

    /* Machinery for standing orders */
    bool teach;			/* true when only setting a standing order */
    struct a_unit *sounit;	/* unit that stores standing order for occs */
    int soutype;		/* unit type that will get standing orders */
    struct a_order *tmporder;	/* holding place for orders */

    /* Working variables for the display */
    short vcx, vcy;		/* center hex in the viewport */
    short lastvcx, lastvcy;	/* last center hex (-1,-1 initially) */
    short lastx, lasty;		/* last current x and y (-1,-1 initially) */
    long flashtimer;		/* flash timer */
    int flashx1;		/* flash map coordinates */
    int flashy1;
    int flashx2;
    int flashy2;

    /* Keep track of units that have died.  Flush them at the end of the */
    /* players turn.  Player is reponsible for keeping track of units he kills. */
    struct a_unit *deadunits;	/* list of units killed in last turn. */
    struct a_unit *curdeadunit;	/* Dead unit we are looking at. */

    /* Display Things */
    char *host;			/* which host is this side attached to */
    Display *display;		/* side's specific display structure */
    int screen_num;		/* side's screen number */
    int default_depth;		/* side's screen depth */
    bool monochrome;		/* StaticGray visual */
    AppData appdata;		/* application resources */
    GC icongc;			/* icon graphics context */
    GC invicongc;		/* icon gc inverted colors. */
    GC flashgc;			/* The gc for drawing the flash lines. */
    GC unittextgc;		/* unit text printing gc. */
    GC unitgc;			/* unit bitmap printing gc. */
    GC worldgc;			/* world map gc. */
    XmFontList unitfontlist;	/* unit text printing font. */
    XmFontList iconfontlist;	/* icon text printing font. */
    short hw, hh;		/* dimensions of general icon font (in pixels) */
    short hch;			/* center-to-center distance between hexes */
    short mm;			/* magnification of world hexes (in pixels) */
    short uw, uh;		/* dimensions of unit font/bitmaps (in pixels) */
    short mask_offx;		/* unit clip mask offsets from terrain */
    short mask_offy;
    Pixel hexcolor[MAXTTYPES];	/* the color of each terrain type */
    Pixmap bombpics[4];         /* mushroom clouds */
    Pixmap logostipple;         /* the XConq logo pixmap */
    Cursor curs;		/* the cursor object itself */
    Widget top;			/* root shell widget */
    Widget side_menu;		/* sides's pulldown menu */
    Widget side_dialog;		/* dialog shell widget */
    Widget side_dialog_mgr;	/* dialog pane mgr widget */
    Widget side_dialog_prompt;	/* dialog prompt widget */
    Widget side_dialog_action_mgr;	/* dialog action mgr widget */
    Widget side_dialog_action[MAXSIDES];	/* dialog action widgets */
    Widget help_dialog;		/* help dialog shell widget */
    Widget help_dialog_mgr;	/* help dialog pane mgr widget */
    Widget help_dialog_control;	/* help dialog control mgr widget */
    Widget help_text;		/* help dialog text widget */
    Widget main;		/* main geometry management widget */
    Widget separator;		/* widget between left and right */
    Widget left;		/* left geometry management widget */
    Widget right;		/* right geometry management widget */
    Widget help;		/* help window */
    Widget msg;			/* places for notices/warnings */
    Widget msg_text;		/* places for notices/warnings */
    Widget info;		/* widget mgr of info */
    Widget info_mgr;		/* form widget of info */
    Widget info_handle;		/* details about a unit */
    Widget info_hp;		/* details about a unit */
    Widget info_terrain;	/* details about a unit */
    Widget info_production;	/* details about a unit */
    Widget info_misc1;		/* details about a unit */
    Widget info_next_product;	/* details about a unit */
    Widget info_misc2;		/* details about a unit */
    Widget info_resources;	/* details about a unit */
    Widget info_status;		/* details about a unit */
    Widget unit_menu;		/* unit menu */
    Sensitive_item *unit_sensitivities;	/* unit menu items with sensitivity */
    int sensitivity;		/* sensitivity bits */
    Widget map;			/* widget mgr of detailed map */
    Widget map_sb_ver;		/* vertical scroll bar of detailed map */
    Widget map_area;		/* detailed map drawing area of vicinity */
    Pixmap map_pix;		/* detailed map drawing area of vicinity */
    int mw;			/* map width */
    int mh;			/* map height */
    void (*map_cb)(Widget, XtPointer, XtPointer);	/* map/dialog callback */
    Widget sides;		/* widget mgr of list of sides and their status */
    Widget dialog;		/* dialog shell widget */
    Widget dialog_mgr;		/* dialog pane mgr widget */
    Widget dialog_prompt;	/* dialog prompt widget */
    Widget dialog_action_mgr;	/* dialog action mgr widget */
    Widget dialog_action[MAXUTYPES];	/* dialog action widgets */
    struct a_sides_status *sideslist;		/* widget list of sides */
    Widget time;		/* turn number */
    Widget sidemode;		/* mode (survey || move) */
    Widget turnclock;		/* chess clock display for turn */
    Widget sideclock;		/* chess clock display for side */
    Widget state;		/* widget mgr1 of status of units on side */
    Widget state_col;		/* widget mgr2 of status of units on side */
    struct a_sides_unit unitslist[MAXUTYPES];	/* misc unit data */
    Widget worldf;		/* frame of entire world */
    Widget world;		/* display of entire world */

    /* Filled during side creation */
    struct a_side *next;	/* pointer to next in list */
    int startbeeptime;		/* beep at start of turn if this many */
				/* seconds past */
} Side;

/* Sides status list */

typedef struct a_sides_status {
  Widget mgr;		/* Row manager for a side */
  Widget side_no;	/* Side number */
  Widget status;	/* Activity status */
  Widget name;		/* side name */
  Side *side; 		/* pointer back to this side */
  bool selected; 	/* selected for a request? */
  struct a_sides_status *next;	/* pointer to next in list */
} Sides_status;

/* Side externals. */

extern Side neutral_placeholder;
extern Side sides[];
extern Side *sidelist;
extern Side *tmpside;
extern int numsides;

extern void init_sides();
extern int side_number(Side *side);
extern bool allied_side(Side *s1, Side *s2);
extern bool enemy_side(Side *s1, Side *s2);
extern bool neutral_side(Side *s1, Side *s2);
extern void declare_war(Side *side1, Side *side2);
extern void declare_neutrality(Side *side1, Side *side2);
extern void declare_alliance(Side *side1, Side *side2);
extern Side *create_side(char *name, bool person, char *host);
extern void set_side_view(Side *s, int x, int y, viewdata v);
extern Side *side_n(int n);
extern void remove_images(Side *side, int n);
