/*  This file is part of ksquirrel-libs (http://ksquirrel.sf.net)

    Copyright (c) 2005 Dmitry Baryshev <ksquirrel@tut.by>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation;
    either version 2 of the License, or (at your option) any later
    version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KSQUIRREL_CODEC_DEFS_wal
#define KSQUIRREL_CODEC_DEFS_wal

typedef struct
{
    s8   name[32];        /* name of the texture */

    u32  width;           /* width (in pixels) of the largest mipmap level */
    u32  height;          /* height (in pixels) of the largest mipmap level */

    s32  offset[4];       /* byte offset of the start of each of the 4 mipmap levels */

    s8   next_name[32];   /* name of the next texture in the animation */

    u32  flags;
    u32  contents;
    u32  value;

}wal_header;

#endif
