#################################################
#
#  (C) 2017 Slávek Banko
#  slavek (DOT) banko (AT) axis.cz
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

if( NOT ATTRIBUTE_ALIGNED_MAX )
  foreach( ATTRIBUTE_ALIGNED_TEST 2 4 8 16 32 64 )
    check_c_source_compiles(
      "int main() { static char c __attribute__ ((aligned(${ATTRIBUTE_ALIGNED_TEST}))) = 0; return c; }"
      ATTRIBUTE_ALIGNED_MAX_${ATTRIBUTE_ALIGNED_TEST}
    )
    if( ATTRIBUTE_ALIGNED_MAX_${ATTRIBUTE_ALIGNED_TEST} )
      set( ATTRIBUTE_ALIGNED_MAX ${ATTRIBUTE_ALIGNED_TEST} CACHE INTERNAL "" FORCE )
    else( )
      break( )
    endif( )
  endforeach( )
endif( NOT ATTRIBUTE_ALIGNED_MAX )


check_function_exists( strlcpy HAVE_STRLCPY )
check_symbol_exists( strlcpy "string.h" HAVE_STRLCPY_PROTO )


tde_save_and_set( CMAKE_REQUIRED_FLAGS "-include X11/Xlib.h" )

pkg_search_module( XEXT xext )

check_include_file( "X11/extensions/XShm.h" X11_SHARED_MEM )

check_include_file( "X11/extensions/Xxf86dga.h" X11_DGA2 )
if( X11_DGA2 )
  set( DGA_LIBRARIES Xxf86dga )
endif( )

check_include_file( "X11/extensions/Xvlib.h" X11_XV )
if( X11_XV )
  set( XV_LIBRARIES Xv )
endif( )

check_include_file( "X11/extensions/xf86vmode.h" X11_XVIDMODE )
if( X11_XVIDMODE )
  set( XVIDMODE_LIBRARIES Xxf86vm )
endif( )

tde_restore( CMAKE_REQUIRED_FLAGS )
