//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.QtSupport;
import java.util.Calendar;

/**

 CalendarSystem abstract class, default derived kde gregorian class and
 factory class. Provides support for different calendar types for kde
 calendar widget and related stuff.
 Derived classes must be created through KCalendarFactory class
		@author Carlos Moro <cfmoro@correo.uniovi.es>

		@short    CalendarSystem abstract class, default derived kde gregorian class and  factory class.

*/
public class KCalendarSystem implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KCalendarSystem(Class dummy){}

	/**
		 Constructor of abstract calendar class. This will be called by the derived classes.
			@param locale It will use this locale for translations, 0 means global.
		   		@short    Constructor of abstract calendar class.
	*/
	/**
		 Gets specific calendar type year for a given gregorian date
			@param date gregorian date
				@return year

		@short    Gets specific calendar type year for a given gregorian date
	*/
	public native int year(Calendar date);
	/**
		 Converts a date into a year literal
			@param pDate The date to convert
			@param bShort If the short version of should be used
				@return The year literal of the date

		@short    Converts a date into a year literal
	*/
	public native String yearString(Calendar pDate, boolean bShort);
	/**
		 Converts a year literal of a part of a string into a integer starting at the beginning of the string
			@param sNum The string to parse
			@param iLength The number of chars used, and 0 if no valid symbols was found in the string
				@return An integer corresponding to the year

		@short    Converts a year literal of a part of a string into a integer starting at the beginning of the string
	*/
	public native int yearStringToInteger(String sNum, int[] iLength);
	/**
		 Gets specific calendar type month for a given gregorian date
			@param date gregorian date
				@return month number

		@short    Gets specific calendar type month for a given gregorian date
	*/
	public native int month(Calendar date);
	/**
		 Converts a date into a month literal
			@param pDate The date to convert
			@param bShort If the short version of should be used
				@return The month literal of the date

		@short    Converts a date into a month literal
	*/
	public native String monthString(Calendar pDate, boolean bShort);
	/**
		 Converts a month literal of a part of a string into a integer starting at the beginning of the string
			@param sNum The string to parse
			@param iLength The number of chars used, and 0 if no valid symbols was found in the string
				@return An integer corresponding to the month

		@short    Converts a month literal of a part of a string into a integer starting at the beginning of the string
	*/
	public native int monthStringToInteger(String sNum, int[] iLength);
	/**
		 Gets specific calendar type day number of month for a given date
			@param date gregorian date equivalent to the specific one
				@return day of the month

		@short    Gets specific calendar type day number of month for a given date
	*/
	public native int day(Calendar date);
	/**
		 Converts a date into a day literal
			@param pDate The date to convert
			@param bShort If the short version of should be used
				@return The day literal of the date

		@short    Converts a date into a day literal
	*/
	public native String dayString(Calendar pDate, boolean bShort);
	/**
		 Converts a day literal of a part of a string into a integer starting at the beginning of the string
			@param sNum The string to parse
			@param iLength The number of chars used, and 0 if no valid symbols was found in the string
				@return An integer corresponding to the day

		@short    Converts a day literal of a part of a string into a integer starting at the beginning of the string
	*/
	public native int dayStringToInteger(String sNum, int[] iLength);
	/**
		 Gets specific calendar type number of day of week number for a given
		 date
			@param date gregorian date
				@return day of week

		@short    Gets specific calendar type number of day of week number for a given  date
	*/
	public native int dayOfWeek(Calendar date);
	/**
		 Gets specific calendar type day number of year for a given date
			@param date gregorian date equivalent to the specific one
				@return day number

		@short    Gets specific calendar type day number of year for a given date
	*/
	public native int dayOfYear(Calendar date);
	/**
		 Changes the date's year, month and day. The range of the year, month
		 and day depends on which calendar is being used.
			@param date Date to change
			@param y Year
			@param m Month number
			@param d Day of month
				@return true if the date is valid; otherwise returns false.

		@short    Changes the date's year, month and day.
	*/
	public native boolean setYMD(Calendar date, int y, int m, int d);
	/**
		 Returns a Calendar object containing a date nyears later.
			@param date The old date
			@param nyears The number of years to add
				@return The new date

		@short    Returns a TQDate object containing a date nyears later.
	*/
	public native Calendar addYears(Calendar date, int nyears);
	/**
		 Returns a Calendar object containing a date nmonths later.
			@param date The old date
			@param nmonths The number of months to add
				@return The new date

		@short    Returns a TQDate object containing a date nmonths later.
	*/
	public native Calendar addMonths(Calendar date, int nmonths);
	/**
		 Returns a Calendar object containing a date ndays later.
			@param date The old date
			@param ndays The number of days to add
				@return The new date

		@short    Returns a TQDate object containing a date ndays later.
	*/
	public native Calendar addDays(Calendar date, int ndays);
	/**
		 Gets specific calendar type number of month for a given year
			@param date The date whose year to use
				@return The number of months in that year

		@short    Gets specific calendar type number of month for a given year
	*/
	public native int monthsInYear(Calendar date);
	/**
		 Gets the number of days in date whose years specified.
			@param date Gregorian date equivalent to the specific one
				@return The number of days in year

		@short    Gets the number of days in date whose years specified.
	*/
	public native int daysInYear(Calendar date);
	/**
		 Gets specific calendar type number of days in month for a given date
			@param date gregorian date
				@return number of days for month in date

		@short    Gets specific calendar type number of days in month for a given date
	*/
	public native int daysInMonth(Calendar date);
	/**
		 Gets the number of weeks in a specified year
			@param year the year
				@return number of weeks in year

		@short    Gets the number of weeks in a specified year
	*/
	public native int weeksInYear(int year);
	/**
		 Gets specific calendar type week number for a given date
			@param date gregorian date
			@param yearNum The year the date belongs to
				@return week number

		@short    Gets specific calendar type week number for a given date
	*/
	public native int weekNumber(Calendar date, int[] yearNum);
	public native int weekNumber(Calendar date);
	/**
		 Gets specific calendar type month name for a given month number
		 If an invalid month is specified, null is returned.
			@param month The month number
			@param year The year the month belongs to
			@param shortName Specifies if the short month name should be used
				@return The name of the month

		@short    Gets specific calendar type month name for a given month number  If an invalid month is specified, String.null is returned.
	*/
	public native String monthName(int month, int year, boolean shortName);
	public native String monthName(int month, int year);
	/**
		 Gets specific calendar type month name for a given gregorian date
			@param date Gregorian date
			@param shortName Specifies if the short month name should be used
				@return The name of the month

		@short    Gets specific calendar type month name for a given gregorian date
	*/
	public native String monthName(Calendar date, boolean shortName);
	public native String monthName(Calendar date);
	/**
		 Returns a string containing the possessive form of the month name.
		 ("of January", "of February", etc.)
		 It's needed in long format dates in some languages.
		 If an invalid month is specified, null is returned.
			@param month The month number
			@param year The year the month belongs to
			@param shortName Specifies if the short month name should be used
				@return The possessive form of the name of the month

		@short    Returns a string containing the possessive form of the month name.
	*/
	public native String monthNamePossessive(int month, int year, boolean shortName);
	public native String monthNamePossessive(int month, int year);
	/**
		 Returns a string containing the possessive form of the month name.
		 ("of January", "of February", etc.)
		 It's needed in long format dates in some languages.
			@param date Gregorian date
			@param shortName Specifies if the short month name should be used
				@return The possessive form of the name of the month

		@short    Returns a string containing the possessive form of the month name.
	*/
	public native String monthNamePossessive(Calendar date, boolean shortName);
	public native String monthNamePossessive(Calendar date);
	/**
		 Gets specific calendar type week day name
		 If an invalid week day is specified, null is returned.
			@param weekDay number of day in week (1 . Monday)
			@param shortName short or complete day name
				@return day name

		@short    Gets specific calendar type week day name  If an invalid week day is specified, String.null is returned.
	*/
	public native String weekDayName(int weekDay, boolean shortName);
	public native String weekDayName(int weekDay);
	/**
		 Gets specific calendar type week day name
			@param date the date
			@param shortName short or complete day name
				@return day name

		@short    Gets specific calendar type week day name
	*/
	public native String weekDayName(Calendar date, boolean shortName);
	public native String weekDayName(Calendar date);
	/**
		 Gets the first year value supported by specific calendar type
		 algorithms.
				@return first year supported

		@short    Gets the first year value supported by specific calendar type  algorithms.
	*/
	public native int minValidYear();
	/**
		 Gets the maximum year value supported by specific calendar type
		 algorithms (Calendar, 8000)
				@return maximum year supported

		@short    Gets the maximum year value supported by specific calendar type  algorithms (TQDate, 8000)
	*/
	public native int maxValidYear();
	/**
		 Gets the day of the week traditionaly associated with pray
				@return day number

		@short    Gets the day of the week traditionaly associated with pray
	*/
	public native int weekDayOfPray();
	/**
		 Gets the string representing the calendar
		   		@short    Gets the string representing the calendar
	*/
	public native String calendarName();
	/**
		 Gets if the calendar is lunar based
				@return if the calendar is lunar based

		@short    Gets if the calendar is lunar based
	*/
	public native boolean isLunar();
	/**
		 Gets if the calendar is lunisolar based
				@return if the calendar is lunisolar based

		@short    Gets if the calendar is lunisolar based
	*/
	public native boolean isLunisolar();
	/**
		 Gets if the calendar is solar based
				@return if the calendar is solar based

		@short    Gets if the calendar is solar based
	*/
	public native boolean isSolar();
}
