//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.Qt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQObject;

/**

 The command history stores a (user) configurable amount of
 Commands. It keeps track of its size and deletes commands
 if it gets too large. The user can set a maximum undo and
 a maximum redo limit (e.g. max. 50 undo / 30 redo commands).
 The KCommandHistory keeps track of the "borders" and deletes
 commands, if appropriate. It also activates/deactivates the
 undo/redo actions in the menu and changes the text according
 to the name of the command.
  See {@link KCommandHistorySignals} for signals emitted by KCommandHistory
		@short    The command history stores a (user) configurable amount of  Commands.

*/
public class KCommandHistory extends TQObject  {
	protected KCommandHistory(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Creates a command history, to store commands.
		 This constructor doesn't create actions, so you need to call
		 #undo and #redo yourself.
		     		@short    Creates a command history, to store commands.
	*/
	public KCommandHistory() {
		super((Class) null);
		newKCommandHistory();
	}
	private native void newKCommandHistory();
	/**
		 Creates a command history, to store commands.
		 This also creates an undo and a redo action, in the <code>actionCollection</code>,
		 using the standard names ("edit_undo" and "edit_redo").
			@param withMenus if true, the actions will display a menu when plugged
		 into a toolbar.
			@param actionCollection the parent collection
		     		@short    Creates a command history, to store commands.
	*/
	public KCommandHistory(TDEActionCollection actionCollection, boolean withMenus) {
		super((Class) null);
		newKCommandHistory(actionCollection,withMenus);
	}
	private native void newKCommandHistory(TDEActionCollection actionCollection, boolean withMenus);
	public KCommandHistory(TDEActionCollection actionCollection) {
		super((Class) null);
		newKCommandHistory(actionCollection);
	}
	private native void newKCommandHistory(TDEActionCollection actionCollection);
	/**
		 Erases all the undo/redo history.
		 Use this when reloading the data, for instance, since this invalidates
		 all the commands.
		     		@short    Erases all the undo/redo history.
	*/
	public native void clear();
	/**
		 Adds a command to the history. Call this for each <code>command</code> you create.
		 Unless you set <code>execute</code> to false, this will also execute the command.
		 This means, most of the application's code will look like
		    MyCommand  cmd = new MyCommand(i18n("Capitalized Name"), parameters);
		    m_historyCommand.addCommand( cmd );
		     		@short    Adds a command to the history.
	*/
	public native void addCommand(KCommand command, boolean execute);
	public native void addCommand(KCommand command);
	/**
				@return the maximum number of items in the undo history

		@short
	*/
	public native int undoLimit();
	/**
		 Sets the maximum number of items in the undo history.
		     		@short    Sets the maximum number of items in the undo history.
	*/
	public native void setUndoLimit(int limit);
	/**
				@return the maximum number of items in the redo history

		@short
	*/
	public native int redoLimit();
	/**
		 Sets the maximum number of items in the redo history.
		     		@short    Sets the maximum number of items in the redo history.
	*/
	public native void setRedoLimit(int limit);
	/**
		 Enable or disable the undo and redo actions.
		 This isn't usually necessary, but this method can be useful if
		 you disable all actions (to go to a "readonly" state), and then
		 want to come back to a readwrite mode.
		     		@short    Enable or disable the undo and redo actions.
	*/
	public native void updateActions();
	/**
		 Undoes the last action.
		 Call this if you don't use the builtin TDEActions.
		     		@short    Undoes the last action.
	*/
	public native void undo();
	/**
		 Redoes the last undone action.
		 Call this if you don't use the builtin TDEActions.
		     		@short    Redoes the last undone action.
	*/
	public native void redo();
	/**
		 Remembers when you saved the document.
		 Call this right after saving the document. As soon as
		 the history reaches the current index again (via some
		 undo/redo operations) it will emit documentRestored
		 If you implemented undo/redo properly the document is
		 the same you saved before.
		     		@short    Remembers when you saved the document.
	*/
	public native void documentSaved();
	protected native void slotUndoAboutToShow();
	protected native void slotUndoActivated(int arg1);
	protected native void slotRedoAboutToShow();
	protected native void slotRedoActivated(int arg1);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
