#ifndef FEEDBROWSER_H
#define FEEDBROWSER_H

#include <tqobject.h>
#include <dcopobject.h>
#include <kdialogbase.h>
#include <tdelistview.h>

class DCOPRSSIface : public TQObject, public DCOPObject
{
	K_DCOP
	TQ_OBJECT
//	
	public:
		DCOPRSSIface( TQObject *parent, const char *name = 0 );

	k_dcop:
		void slotGotCategories( const TQStringList &categories );

	public slots:
		void getCategories( const TQString &cat = "Top" );

	signals:
		void gotCategories( const TQStringList &categories );
};

class CategoryItem : public TQObject, public TDEListViewItem
{
	TQ_OBJECT
//	
	public:
		CategoryItem( TDEListView *parent, const TQString &category );
		CategoryItem( TDEListViewItem *parent, const TQString &category );

		virtual void setOpen( bool open );

	private slots:
		void gotCategories( const TQStringList &categories );

	private:
		void populate();
		void init();

		TQString m_category;
		bool m_populated;
		DCOPRSSIface *m_dcopIface;
};

class FeedBrowserDlg : public KDialogBase
{
	TQ_OBJECT
//	
	friend class CategoryItem;
	public:
		FeedBrowserDlg( TQWidget *parent, const char *name = 0 );

	private slots:
		void itemSelected( TQListViewItem *item );
		void gotTopCategories( const TQStringList &categories );

	private:
		void getTopCategories();

		DCOPRSSIface *m_dcopIface;
		TDEListView *m_feedList;
};

#endif // FEEDBROWSER_H
