/*
    Kopete Groupwise Protocol
    gwchatsearchdialog.cpp - dialog for searching for chatrooms

    Copyright (c) 2005      SUSE Linux AG	 	 http://www.suse.com
    
    Kopete (c) 2002-2005 by the Kopete developers <kopete-devel@kde.org>
 
    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU General Public                   *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#include <tqmap.h>

#include <tdelistview.h>
#include <tdelistviewsearchline.h>

#include <kpushbutton.h>
#include <kdebug.h>
#include <tdelocale.h>
#include "client.h"
#include "chatroommanager.h"

#include "gwaccount.h"
#include "gwprotocol.h"
#include "gwchatsearchwidget.h"
#include "gwchatpropsdialog.h"

#include "gwchatsearchdialog.h"

GroupWiseChatSearchDialog::GroupWiseChatSearchDialog( GroupWiseAccount * account, TQWidget *parent, const char *name )
	: KDialogBase(  parent, name, false, i18n( "Search Chatrooms" ),
					KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel, Ok, true ), m_account( account )
{
	m_widget = new GroupWiseChatSearchWidget( this );
//	m_widget->m_searchLineWidget->createSearchLine( m_widget->m_chatrooms );
	setMainWidget( m_widget );

	m_manager = m_account->client()->chatroomManager();
	
	connect ( m_manager, TQ_SIGNAL( updated() ), TQ_SLOT( slotManagerUpdated() ) );
	connect ( m_manager, TQ_SIGNAL( gotProperties( const GroupWise::Chatroom & ) ),
			  TQ_SLOT( slotGotProperties( const GroupWise::Chatroom & ) ) );

	connect( m_widget->m_btnRefresh, TQ_SIGNAL( clicked() ), TQ_SLOT( slotUpdateClicked() ) );
	connect( m_widget->m_btnProperties, TQ_SIGNAL( clicked() ), TQ_SLOT( slotPropertiesClicked() ) );

	m_manager->updateRooms();
	show();
}

GroupWiseChatSearchDialog::~GroupWiseChatSearchDialog()
{
}

void GroupWiseChatSearchDialog::slotUpdateClicked()
{
	kdDebug ( GROUPWISE_DEBUG_GLOBAL ) << "updating chatroom list " << endl;
	m_widget->m_chatrooms->clear();
	TQListViewItem * first = m_widget->m_chatrooms->firstChild();
	TQString updateMessage = i18n("Updating chatroom list..." );
/*	if ( first )
		new TQListViewItem( first, updateMessage );
	else*/
		new TQListViewItem( m_widget->m_chatrooms, updateMessage );
	m_manager->updateRooms();

}

void GroupWiseChatSearchDialog::slotManagerUpdated()
{
	ChatroomMap rooms = m_manager->rooms();
	ChatroomMap::iterator it = rooms.begin();
	const ChatroomMap::iterator end = rooms.end();
	while ( it != end )
	{
		new TQListViewItem( m_widget->m_chatrooms,
						   it.data().displayName,
						   m_account->protocol()->dnToDotted( it.data().ownerDN ),
						   TQString::number( it.data().participantsCount ) );
		++it;
	}
}

void GroupWiseChatSearchDialog::slotPropertiesClicked()
{
	TQListViewItem * selected  = m_widget->m_chatrooms->selectedItem();
	if ( selected )
	{
		m_manager->requestProperties( selected->text( 0 ) );
	}
}

void GroupWiseChatSearchDialog::slotGotProperties(const GroupWise::Chatroom & room)
{
	kdDebug( GROUPWISE_DEBUG_GLOBAL ) << k_funcinfo << endl;
	new GroupWiseChatPropsDialog( room, true, this, "chatpropsdlg" );
}

#include "gwchatsearchdialog.moc"
