/*
 *            kPPP: A pppd front end for the KDE project
 *
 * $Id$
 *
 *            Copyright (C) 1997 Bernd Johannes Wuebben
 *                   wuebben@math.cornell.edu
 *
 * based on EzPPP:
 * Copyright (C) 1997  Jay Painter
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <tqlayout.h>
#include <kbuttonbox.h>
#include <twin.h>
#include <tdeapplication.h>
#include "pppdargs.h"
#include "pppdata.h"
#include <tdelocale.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlistbox.h>
#include <tqlabel.h>
#include <kstdguiitem.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>

PPPdArguments::PPPdArguments(TQWidget *parent, const char *name)
  : TQDialog(parent, name, TRUE)
{
  setCaption(i18n("Customize pppd Arguments"));
  KWin::setIcons(winId(), kapp->icon(), kapp->miniIcon());
  TQVBoxLayout *l = new TQVBoxLayout(this, 10, 10);
  TQHBoxLayout *tl = new TQHBoxLayout(10);
  l->addLayout(tl);
  TQVBoxLayout *l1 = new TQVBoxLayout();
  TQVBoxLayout *l2 = new TQVBoxLayout();
  tl->addLayout(l1, 1);
  tl->addLayout(l2, 0);

  TQHBoxLayout *l11 = new TQHBoxLayout(10);
  l1->addLayout(l11);

  argument_label = new TQLabel(i18n("Arg&ument:"), this);
  l11->addWidget(argument_label);

  argument = new TQLineEdit(this);
  argument_label->setBuddy(argument);
  connect(argument, TQ_SIGNAL(returnPressed()),
	  TQ_SLOT(addbutton()));
  l11->addWidget(argument);
  connect(argument, TQ_SIGNAL(textChanged(const TQString &)),
	  this, TQ_SLOT(textChanged(const TQString &)));

  arguments = new TQListBox(this);
  arguments->setMinimumSize(1, fontMetrics().lineSpacing()*10);
  connect(arguments, TQ_SIGNAL(highlighted(int)),
	  this, TQ_SLOT(itemSelected(int)));
  l1->addWidget(arguments, 1);

  add = new TQPushButton(i18n("&Add"), this);
  connect(add, TQ_SIGNAL(clicked()), TQ_SLOT(addbutton()));
  l2->addWidget(add);
  l2->addStretch(1);

  remove = new TQPushButton(i18n("&Remove"), this);
  connect(remove, TQ_SIGNAL(clicked()), TQ_SLOT(removebutton()));
  l2->addWidget(remove);

  defaults = new KPushButton(KStdGuiItem::defaults(), this);
  connect(defaults, TQ_SIGNAL(clicked()), TQ_SLOT(defaultsbutton()));
  l2->addWidget(defaults);

  l->addSpacing(5);

  KButtonBox *bbox = new KButtonBox(this);
  bbox->addStretch(1);
  closebtn = bbox->addButton(KStdGuiItem::ok());
  connect(closebtn, TQ_SIGNAL(clicked()), TQ_SLOT(closebutton()));
  TQPushButton *cancel = bbox->addButton(KStdGuiItem::cancel());
  connect(cancel, TQ_SIGNAL(clicked()),
	  this, TQ_SLOT(reject()));
  bbox->layout();
  l->addWidget(bbox);

  setFixedSize(sizeHint());

  //load info from gpppdata
  init();

  add->setEnabled(false);
  remove->setEnabled(false);
  argument->setFocus();
}


void PPPdArguments::addbutton() {
  if(!argument->text().isEmpty() && arguments->count() < MAX_PPPD_ARGUMENTS) {
    arguments->insertItem(argument->text());
    argument->setText("");
  }
}


void PPPdArguments::removebutton() {
  if(arguments->currentItem() >= 0)
    arguments->removeItem(arguments->currentItem());
}


void PPPdArguments::defaultsbutton() {
  // all of this is a hack
  // save current list
  TQStringList arglist(gpppdata.pppdArgument());

  // get defaults
  gpppdata.setpppdArgumentDefaults();
  init();

  // restore old list
  gpppdata.setpppdArgument(arglist);
}


void PPPdArguments::closebutton() {
  TQStringList arglist;
  for(uint i=0; i < arguments->count(); i++)
    arglist.append(arguments->text(i));
  gpppdata.setpppdArgument(arglist);

  done(0);
}


void PPPdArguments::init() {
  while(arguments->count())
    arguments->removeItem(0);

  TQStringList &arglist = gpppdata.pppdArgument();
  for ( TQStringList::Iterator it = arglist.begin();
        it != arglist.end();
        ++it )
    arguments->insertItem(*it);
}


void PPPdArguments::textChanged(const TQString &s) {
  add->setEnabled(s.length() > 0);
}


void PPPdArguments::itemSelected(int idx) {
  remove->setEnabled(idx != -1);
}

#include "pppdargs.moc"
