#ifndef ENTER_COMBO_H
#define ENTER_COMBO_H

#include <tqcombobox.h>
#include <tqevent.h>
#include <tqkeycode.h>
#include <tqlineedit.h>

#undef KeyPress // X headers...

class EnterCombo : public TQComboBox {
  TQ_OBJECT
  
public:
  EnterCombo ( TQWidget * parent=0, const char * name=0 )
    : TQComboBox(TRUE, parent, name)
    {
    }
  EnterCombo ( bool rw, TQWidget * parent=0, const char * name=0 )
      : TQComboBox(rw, parent, name)
      {
        TQKeyEvent ke(TQEvent::KeyPress, SHIFT|Key_Home, 0, 0);
        keyPressEvent(&ke);
      }

  virtual void show(){
    TQComboBox::show();
    lineEdit()->selectAll();    
  }

signals:
  void enterPressed();
  
protected:
  virtual void keyPressEvent( TQKeyEvent *e );
};

#endif
