/***************************************************************************
                          utils.cpp  -  description
                             -------------------
    begin                : Don Jan 9 2003
    copyright            : (C) 2003 by Martin Witte / Frank Schwanz
    email                : witte@kawo1.rwth-aachen.de / schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tqregexp.h>
#include "include/utils.h"
#include <linux/soundcard.h>

//const char *mixerChannelLabels[] = SOUND_DEVICE_LABELS;
//const char *mixerChannelNames[]  = SOUND_DEVICE_NAMES;


TQString XMLEscape (const TQString &s)
{
    TQString c = s;
    c.replace(TQRegExp("&"),  "&amp;");
    c.replace(TQRegExp("<"),  "&lt;");
    c.replace(TQRegExp(">"),  "&gt;");
    c.replace(TQRegExp("\""), "&quot;");
    c.replace(TQRegExp("'"),  "&apos;");
    return c;
}


TQString xmlOpenTag (const TQString &tag, bool nl)
{
    return "<" + tag + ">" + (nl ? TQString("\n") : TQString());
}


TQString xmlCloseTag (const TQString &tag, bool nl)
{
    return "</" + tag + ">" + (nl ? TQString("\n") : TQString());
}


TQString xmlTag (const TQString &tag, int v, bool nl)
{
    return xmlTag (tag, TQString().setNum(v), nl);
}


TQString xmlTag (const TQString &tag, float f, bool nl)
{
    return xmlTag(tag, TQString().setNum(f), nl);
}


TQString xmlTag (const TQString &tag, const TQString &data, bool nl)
{
    return   xmlOpenTag(tag, false)
           + XMLEscape(data)
           + xmlCloseTag(tag, false)
           + (nl ? TQString("\n") : TQString());
}

