#ifndef _KVI_DCOPHELPER_H_
#define _KVI_DCOPHELPER_H_
//=============================================================================
//
//   File : kvi_dcophelper.h
//   Created on Sat 20 Jan 2007 12:35:21 by Alexander Stillich
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2005 Szymon Stefanek <pragma at kvirc dot net>
//   Copyright (C) 2007 Alexander Stillich <torque at pltn dot org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_qcstring.h"
#include "kvi_valuelist.h"

#ifdef COMPILE_TDE_SUPPORT

typedef KviValueList<KviTQCString> KviQCStringList;

class KVILIB_API KviDCOPHelper
{

public:

	// Constructs a DCOP helper object.
	// bStartApp: tries to start application when a dcop call is about to be made and the app is not already running
	// szAppID: application name as seen by DCOP
	KviDCOPHelper(bool bStartApp, const KviTQCString &szAppId);
	~KviDCOPHelper();

protected:

	KviTQCString 	m_szAppId;
	bool 	m_bStartApp;

protected:

	bool 	ensureAppRunning(const TQString &szApp);
	bool 	findRunningApp(const TQString &szApp);
	bool 	startApp(const TQString &szApp,int iWaitMSecs = 0);
	int 		detectApp(const TQString &szApp,bool bStart,int iScoreWhenFound,int iScoreWhenStarted);

	// naming convention: [return value] Ret [argument type(s)] DCOPCall

	bool 	voidRetVoidDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc);
	bool 	voidRetIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int iVal);
	bool 	voidRetIntBoolDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int iVal, bool bVal);
	bool 	voidRetIntIntIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int iVal1, int iVal2, int iVal3);
	bool 	voidRetBoolDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool bVal);
	bool 	voidRetStringDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,const TQString &szVal);
	bool 	voidRetFloatDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,float fVal);
	bool 	stringRetVoidDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString &szRet);
	bool 	stringRetIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,TQString &szRet,int iVal);
	bool 	intRetVoidDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int &ret);
	bool 	intRetIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,int &ret, int iVal);
	bool 	boolRetVoidDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,bool &ret);

	bool		qvalueListIntRetIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,KviValueList<int> &ret, int iVal);
	bool		qcstringListRetIntDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,KviQCStringList &ret, int iVal);
	bool		qcstringListRetVoidDCOPCall(const KviTQCString &szObj,const KviTQCString &szFunc,KviQCStringList &ret);
};

#endif //COMPILE_TDE_SUPPORT

#endif // _KVI_DCOPHELPER_H_
