/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef _PARSING_HELPER_H_
#define _PARSING_HELPER_H_

#include <tqobject.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqmap.h>
#include <tqpair.h>

#include <kdirwatch.h>
#include <kurl.h>


#include "globals.h"

#include "logListItem.h"
#include "logLine.h"
#include "logManager.h"

#include "logFile.h"
#include "logViewColumn.h"
#include "logViewColumns.h"

/**
 * @author Nicolas Ternisien
 */
class ParsingHelper {
	

	public:
		/**
		 * Returns the months number represented by the 3 first letters in the TQString parameter
		 */
		static int parseMonthNumber(TQString& month);
	
		static TQDateTime parseDateTimeFromHTTP(TQString& logLine);
	
		static TQString parseSize(const TQString& size);
		
		static TQString parseHTTPResponse(const TQString& response);
		
		static TQString parseAgent(const TQString& agent);
		

		
	private:
	
		/**
		 * Map used by the static parseMonthNumber() method
		 */
		static TQMap<TQString, int> mapMonths;
		
		/**
		 * Map used by the static parseMonthNumber() method
		 */
		static TQMap<TQString, TQString> mapHTTPResponse;
};

#endif
