###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### X11 headers path

find_package( X11 )


##### check for headers

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( inttypes.h HAVE_INTTYPES_H )

check_include_file( "sys/time.h"   HAVE_SYS_TIME_H    )
check_include_files( "sys/time.h;time.h" TIME_WITH_SYS_TIME )


##### get the date and time of the package

tde_read_src_metadata()
tde_curdatetime( PACKAGE_DATETIME )


##### check for GnuTLS or OpenSSL( default )

if( WITH_GNUTLS )

    pkg_search_module( GNUTLS gnutls )
    find_program( LIBGCRYPT_CONFIG libgcrypt-config )

    if( NOT GNUTLS_FOUND )
        tde_message_fatal( "GnuTLS has been requested but was not found on your system" )
    endif( NOT GNUTLS_FOUND )

    if( LIBGCRYPT_CONFIG )
        message( STATUS "Found libgcrypt executable: ${LIBGCRYPT_CONFIG}" )
     else()
        tde_message_fatal( "libgcrypt is required but was not found on your system" )
    endif()

    macro( _libgcrypt_config __type __var )
        execute_process(
           COMMAND ${LIBGCRYPT_CONFIG} --${__type}
           OUTPUT_VARIABLE ${__var}
           RESULT_VARIABLE __result
           OUTPUT_STRIP_TRAILING_WHITESPACE
        )
        if( __result )
            tde_message_fatal( "Unable to run ${LIBGCRYPT_CONFIG}!" )
        endif()
    endmacro()

    _libgcrypt_config( libs LIBGCRYPT_LIBRARIES )
    _libgcrypt_config( cflags LIBGCRYPT_INCLUDE_DIRS )

    if( LIBGCRYPT_LIBRARIES )
        string( REGEX REPLACE "(^| +)-l" ";" LIBGCRYPT_LIBRARIES "${LIBGCRYPT_LIBRARIES}" )
        set( LIBGCRYPT_LIBRARIES "${LIBGCRYPT_LIBRARIES}" CACHE INTERNAL "" FORCE )
        message( STATUS "Libgcrypt libraries: ${LIBGCRYPT_LIBRARIES} ")
     elseif( LIBGCRYPT_INCLUDE_DIRS )
        string( REGEX REPLACE "(^| +)-I" ";" LIBGCRYPT_INCLUDE_DIRS "${LIBGCRYPT_INCLUDE_DIRS}" )
        set( LIBGCRYPT_INCLUDE_DIRS "${LIBGCRYPT_INCLUDE_DIRS}" CACHE INTERNAL "" FORCE )
        message( STATUS "Libgcrypt includes:  ${LIBGCRYPT_INCLUDE_DIRS} ")
    endif()
 else()

##### check for OpenSSL

    find_package( OpenSSL )

    if( NOT OPENSSL_FOUND )
        check_include_file( openssl/err.h HAVE_OPENSSL_H )
        check_library_exists( ssl OPENSSL_init_ssl "" HAVE_LIBSSL_11 )
        check_library_exists( crypto EVP_EncryptInit_ex "" HAVE_LIBCRYPTO )

        if( NOT HAVE_LIBSSL_11 )
            check_library_exists( ssl SSL_library_init "" HAVE_LIBSSL )
        endif()

       if( HAVE_OPENSSL_H AND HAVE_LIBCRYPTO AND (HAVE_LIBSSL_11 OR HAVE_LIBSSL)  )
           set( SSL_FOUND 1 CACHE INTERNAL "" FORCE )
           find_file( OPENSSLV_H openssl/opensslv.h )
           file( STRINGS "${OPENSSLV_H}" SSL_VERSION REGEX "#[ \t]*define[ \t]*OPENSSL_VERSION_TEXT" )
           string( REGEX REPLACE "# *define[ \t]*OPENSSL_VERSION_TEXT[ \t]*\"[^0-9 ]* *([^ ]*).*" "\\1" SSL_VERSION "${SSL_VERSION}" )
           set( SSL_VERSION "${SSL_VERSION}" CACHE INTERNAL "" FORCE )
           message( STATUS "Found OpenSSL: version ${SSL_VERSION}" )
           set( OPENSSL_LIBRARIES "ssl;crypto" CACHE INTERNAL "ssl and crypto libs" FORCE )
       endif()
    endif( NOT OPENSSL_FOUND )

    if( NOT OPENSSL_FOUND )
        tde_message_fatal( "OpenSSL support is required but OpenSSL was not found on your system" )
     else()
        set( USE_OPENSSL 1 )
    endif( NOT OPENSSL_FOUND )
endif( WITH_GNUTLS )


##### Embedded GeoIP

if( WITH_EMBEDDED_GEOIP )
    find_package( ZLIB )

    if( NOT ZLIB_FOUND )
        tde_message_fatal( "Zlib is required but was not found on your system" )
    endif()

    set( GEOIP_LIBRARIES geoip-static )
    set( GEOIPDATADIR ${SHARE_INSTALL_PREFIX}/${PROJECT_NAME}/geoip )
    message( STATUS "GEOIPDATADIR location: ${GEOIPDATADIR}" )
 else()
    pkg_search_module( GEOIP geoip )

    if( GEOIP_FOUND )
        set( EXTERNAL_GEOIP 1 )
     else()
        tde_message_fatal( "GeoIP is required but was not found on your system" )
    endif( GEOIP_FOUND )
endif( WITH_EMBEDDED_GEOIP )


##### LIVECD use

if( WITH_LIVECD_SUPPORT )
    set( LIVECD 1 )
endif()


##### Failsafe support

if( WITH_FAILSAFE )
    set( USE_FAILSAFE 1 )
endif()
