/***************************************************************************
 *   Copyright (C) 2004 by Massimo Callegari                               *
 *   massimo.callegari@telsey.it                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef SAMBROWSER_H
#define SAMBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <konqsidebarplugin.h>
#include <tqstring.h>
#include <tqwidget.h>
#include <tqvbox.h>
#include <tqwidgetstack.h>
#include <tdepopupmenu.h>
#include <tdetoolbar.h>
#include <tdehtml_part.h>
// KDE includes
#include <tdeaction.h>
#include <tdeparts/dockmainwindow.h>
#include <tdeparts/part.h>
#include <tdeparts/factory.h>


class smb4kWidget : public TQVBox
{
TQ_OBJECT
  
public:
    smb4kWidget( TQWidget * parent = 0, const char * name = 0, WFlags f = 0 );

private:

};

class KonqSidebar_Smb4K : public KonqSidebarPlugin
{
    TQ_OBJECT
  
public:
    /**
     * Construct a @ref KonqSidebarPlugin.
     *
     * @param inst The sidebar's kinstance class.
     * @param parent The sidebar internal button info class responsible for this plugin.
     * @param widgetParent The container which will contain the plugins widget.
     * @param desktopName The filename of the configuration file.
     * @param name A TQt object name for your plugin.
     **/
     KonqSidebar_Smb4K(TDEInstance *inst,TQObject *parent,TQWidget *widgetParent, TQString &desktopName, const char* name=0);

    /** destructor */
    ~KonqSidebar_Smb4K();

    TDEHTMLPart* m_part;
    virtual TQWidget *getWidget(){ return (TQWidget*)widget;}
    virtual void *provides(const TQString &) {return 0;}
    void emitStatusBarText (const TQString &) {;}

private:
    /**
     * The browser part
     */
    KParts::Part *m_browser_part;

    /**
     * The search dialog part
     */
    KParts::Part *m_search_part;

protected:
     /**
      * The main plugin widget. Contains a tdelistview and a tdetoolbox objects
      */
     smb4kWidget *widget;

     TQString                currentKonquerorURL;


    virtual void handleURL(const KURL &url);
protected slots:
    /**
     * This slot initializes a rescan of the network neighborhood.
     */
    void slotRescan();
    /**
     * This slot is connected to the clicked() signal of the topBar search button
     * It brings up the "Search" dialog.
     */
    void slotSearch();
    /**
     * Opens the configuration dialog.
     */
    void slotSmb4KOptionsDlg();
    /**
     * This slot is invoked when the config dialog is closed and the settings have
     * been changed. Emits the reloadSettings() signal and adjusts the system tray
     * widget to the new settings afterwards.
     */
    void slotSettingsChanged();
    /**
     * Called from mounter when a share is mounted
     */
    void slotMountedShare( const TQString & );
    /**
     * Called from the mounter just before a share is unmounted. This slot
     * changes the URL to the user's home so that we can unmount the share
     * without problems.
     *
     * @param mountpoint      The mount point of the share that's going to
     *                        be unmounted.
     */
    void slotPrepareUnmount( const TQString &mounpoint );
  signals:
    // see <konqsidebarplugin.h>
    void openURLRequest(const KURL &url,
                        const KParts::URLArgs &args = KParts::URLArgs());
};

#endif
