/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#ifndef _KBFXCONFIGAPP_H_
#define _KBFXCONFIGAPP_H_

#include <config.h>

#include <tqbuttongroup.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqmap.h>
#include <tqpushbutton.h>
#include <tqtabwidget.h>
#include <tqtextbrowser.h>
#include <tqtimer.h>
#include <tqtoolbox.h>
#include <tqtooltip.h>
#include <tqvariant.h>
#include <tqwhatsthis.h>
#include <tqwidgetstack.h>

#include <dcopref.h>
#include <kactivelabel.h>
#include <karchive.h>
#include <tdecmdlineargs.h>
#include <kcombobox.h>
#include <kdebug.h>
#include <tdefiledialog.h>
#include <tdehtml_part.h>
#include <tdehtmlview.h>
#include <kicondialog.h>
#include <tdeio/job.h>
#include <tdeio/netaccess.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <tdemessagebox.h>
#include <kpushbutton.h>
#include <krun.h>
#include <kstandarddirs.h>
#include <ktar.h>
#include <tdetempfile.h>
#include <ktextedit.h>
#include <kurl.h>
#include <kurlrequester.h>

#include <kbfxconfig.h>
#include <kbfxkiodownload.h>
#include <kbfxthemesdata.h>

#include "kbfxconfigdlgabout.h"
#include "kbfxconfigdlgbutton.h"
#include "kbfxconfigdlgfonts-old.h"
#include "kbfxconfigdlglayout.h"
#include "kbfxconfigdlgmain.h"
#include "kbfxconfigdlgplugins.h"
#include "kbfxconfigdlgstyle.h"
#include "kbfxconfigdlgthemes.h"
#include "kbfxconfigdlgtooltip.h"

/**
 * @short Application Main Window
 * @author PhobosK <phobosk@mail.kbfx.net>
 * @version 0.1
 */

enum {THEMES=0, BUTTON, FONTS, LAYOUT, PLUGINS, TOOLTIP, STYLE, ABOUT};

class KbfxConfigApp : public KbfxConfigDlgMain
{
		TQ_OBJECT
  
	public:
		/**
		 * Default Constructor
		 */
		KbfxConfigApp ( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );

		/**
		 * Default Destructor
		 */
		virtual ~KbfxConfigApp();
		void InitForm();

		TQString m_KbfxVersion;
		TQString m_KbfxVersion2;
		TQString m_KbfxNewsBrowserError;
		TQString m_KbfxNewsBrowserAddress;

		void browserInit();


	private:
		TQString m_KbfxLogoButton;
		TQString m_KbfxLogoThemes;
		TQString m_KbfxLogoAbout;
		TQString m_KbfxLogoLayout;
		TQString m_KbfxLogoTooltip;
		TQString m_KbfxLogoFonts;
		TQString m_KbfxLogoStyle;
		TQString m_KbfxLogoPlugins;
		KbfxConfigDlgButton *pageButton;
		KbfxConfigDlgThemes *pageThemes;
		KbfxConfigDlgFonts *pageFonts;
		KbfxConfigDlgStyle *pageStyle;
		KbfxConfigDlgPlugins *pagePlugins;
		KbfxConfigDlgLayout *pageLayout;
		KbfxConfigDlgTooltip *pageTooltip;
		KbfxConfigDlgAbout *pageAbout;
		TDEHTMLPart * browser;
		KbfxKioDownload * tdeio;
		TQString m_KbfxThemeUrl;
		TQString m_KbfxThemeFolderUrl;
		int m_KbfxPage;

	public slots:
		virtual void btn_DefaultClicked();
		virtual void btn_HelpClicked();
		virtual void btn_SaveApplyClicked();
		virtual void KbfxMenuItemChanged ( int index );
		virtual void KbfxNewsBrowserOpenURLRequest ( const KURL &, const KParts::URLArgs & );
		virtual void KbfxNewsBrowserCompleted();
		virtual void KbfxNewsBrowserLoad();
		virtual void KbfxGetMoreThemesClicked();
		virtual void KbfxThemeInstall ( TQString & );

	signals:
		void KbfxConfigDlgButtonChanged();
		void KbfxConfigDlgThemesChanged();
		void KbfxConfigDlgStyleChanged();
		void KbfxConfigDlgTooltipChanged();
		void KbfxConfigDlgLayoutChanged();
		void KbfxConfigDlgLayoutLeft();
		void KbfxConfigDlgPluginsChanged();
		void KbfxConfigDlgFontsChanged();
		void KbfxThemeDoInstall( TQString & );

};

#endif // _KBFXCONFIGAPP_H_
