/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_SPINX_SCROLL_BAR_H
#define KBFX_SPINX_SCROLL_BAR_H

#include <tqimage.h>
#include <tqpainter.h>
#include <tqpixmap.h>
#include <tqpointarray.h>
#include <tqtimer.h>
#include <tqwidget.h>

#include <kbfxplasmapixmapprovider.h>


class TQWidget;

class KbfxSpinxScrollBar:public TQWidget
{

		TQ_OBJECT
  
	public:
		typedef enum {UP,DOWN,LEFT,RIGHT}  Direction;
		KbfxSpinxScrollBar ( TQWidget * parent = 0,const char * name = 0,int type  = 0 );
		~KbfxSpinxScrollBar();
		virtual void paintEvent ( TQPaintEvent * ev );
		virtual void mousePressEvent ( TQMouseEvent * me );
		virtual void mouseReleaseEvent ( TQMouseEvent * me );
		virtual void enterEvent ( TQEvent * e );
		virtual void leaveEvent ( TQEvent * e );
		void setType ( Direction dir );
	public slots:
		void timeoutslot();

	signals:
		void scrollUp();
		void scrollDown();
		void scroll ( int , int );

	private:
		TQPixmap m_normal;
		TQPixmap m_hover;
		TQPixmap m_presseod;
		TQPointArray m_triAngle;
		Direction m_dir;
		TQTimer  * m_timer;
		bool m_pressed;


		//
		int _x;
		int _y;
		int w;
		int h;
};

#endif
