
#include "configenvironmentpage.h"

#include "configuration.h"

#include <tdelocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include <tdelistbox.h>
//#include <keditlistbox.h>
//#include <kurlrequester.h>
#include <tdefiledialog.h>
#include <kstandarddirs.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqtooltip.h>
#include <tqmap.h>


ConfigEnvironmentPage::ConfigEnvironmentPage( Config* _config, TQMap<TQString, TQString>* _binaries, TQWidget *parent, const char *name )
    : ConfigPageBase( parent, name )
{
    config = _config;
    binaries = _binaries;

    // create an icon loader object for loading icons
    TDEIconLoader* iconLoader = new TDEIconLoader();

    TQVBoxLayout* box = new TQVBoxLayout( parent, 0, 6 );

    TQLabel* lDirectoriesLabel = new TQLabel( i18n("Directories to be scanned")+":", parent, "lDirectoriesLabel" );
    box->addWidget( lDirectoriesLabel );

//     KEditListBox* eDirectories = new KEditListBox( parent, "eDirectories" );
//     box->addWidget( eDirectories );

    TQHBoxLayout* directoriesBox = new TQHBoxLayout( box );
    lDirectories = new TDEListBox( parent, "lDirectories" );
    lDirectories->insertStringList( config->data.environment.directories );
    directoriesBox->addWidget( lDirectories );
    connect( lDirectories, TQ_SIGNAL(highlighted(int)),
               this, TQ_SLOT(directoriesSelectionChanged(int))
             );

    TQVBoxLayout* directoriesMiddleBox = new TQVBoxLayout( directoriesBox );
    pDirUp = new KPushButton( "", parent, "pDirUp" );
    pDirUp->setPixmap( iconLoader->loadIcon("go-up",TDEIcon::Toolbar) );
    pDirUp->setEnabled( false );
    TQToolTip::add( pDirUp, i18n("Move selected directory one position up.\nThis effects which backend will be chosen, if there are several versions.") );
    directoriesMiddleBox->addWidget( pDirUp );
    connect( pDirUp, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(dirUp())
             );

    directoriesMiddleBox->addStretch();
    pDirDown = new KPushButton( "", parent, "pDirDown" );
    pDirDown->setPixmap( iconLoader->loadIcon("go-down",TDEIcon::Toolbar) );
    pDirDown->setEnabled( false );
    TQToolTip::add( pDirDown, i18n("Move selected directory one position down.\nThis effects which backend will be chosen, if there are several versions.") );
    directoriesMiddleBox->addWidget( pDirDown );
    connect( pDirDown, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(dirDown())
             );

    TQVBoxLayout* directoriesRightBox = new TQVBoxLayout( directoriesBox );
    pAddDirectory = new KPushButton( iconLoader->loadIcon("add",TDEIcon::Small), i18n("Add ..."), parent, "pAddDirectory" );
    directoriesRightBox->addWidget( pAddDirectory );
    connect( pAddDirectory, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(addDirectory())
             );

    pRemoveDirectory = new KPushButton( iconLoader->loadIcon("remove",TDEIcon::Small), i18n("Remove"), parent, "pRemoveDirectory" );
    directoriesRightBox->addWidget( pRemoveDirectory );
    pRemoveDirectory->setEnabled( false );
    connect( pRemoveDirectory, TQ_SIGNAL(clicked()),
               this, TQ_SLOT(removeDirectory())
             );

    directoriesRightBox->addStretch();

    box->addSpacing( 5 );

    TQHBoxLayout* programsBox = new TQHBoxLayout( box );

    TQVBoxLayout* foundProgramsBox = new TQVBoxLayout( programsBox );
    TQLabel* lFoundProgramsLabel = new TQLabel( i18n("Programs found")+":", parent, "lFoundProgramsLabel" );
    foundProgramsBox->addWidget( lFoundProgramsLabel );
    lFoundPrograms = new TDEListBox( parent, "lFoundPrograms" );
    lFoundPrograms->setSelectionMode( TQListBox::NoSelection );
    foundProgramsBox->addWidget( lFoundPrograms );
    //connect(lPrograms,TQ_SIGNAL(highlighted(int)),this,TQ_SLOT(programsSelectionChanged(int)));
    programsBox->setStretchFactor( foundProgramsBox, 3 );

    TQVBoxLayout* notFoundProgramsBox = new TQVBoxLayout( programsBox );
    TQLabel* lNotFoundProgramsLabel = new TQLabel( i18n("Programs not found")+":", parent, "lNotFoundProgramsLabel" );
    notFoundProgramsBox->addWidget( lNotFoundProgramsLabel );
    lNotFoundPrograms = new TDEListBox( parent, "lNotFoundPrograms" );
    lNotFoundPrograms->setSelectionMode( TQListBox::NoSelection );
    notFoundProgramsBox->addWidget( lNotFoundPrograms );
    //connect(lPrograms,TQ_SIGNAL(highlighted(int)),this,TQ_SLOT(programsSelectionChanged(int)));
    programsBox->setStretchFactor( notFoundProgramsBox, 2 );

    for( TQMap<TQString, TQString>::Iterator it = config->binaries.begin(); it != config->binaries.end(); ++it ) {
        if( it.data() != "" ) {
            lFoundPrograms->insertItem( it.data() );
        }
        else {
            lNotFoundPrograms->insertItem( it.key() );
        }
    }

//     box->addStretch();

    // delete the icon loader object
    delete iconLoader;
}

ConfigEnvironmentPage::~ConfigEnvironmentPage()
{}

void ConfigEnvironmentPage::resetDefaults()
{
    lDirectories->clear();
    TQString datadir = locateLocal( "data", "soundkonverter/bin/" );
    datadir.remove( datadir.length() - 1, 1 );
    lDirectories->insertItem( datadir );
    lDirectories->insertItem( TQDir::homeDirPath() + "/bin" );
    lDirectories->insertItem( "/usr/local/bin" );
    lDirectories->insertItem( "/usr/bin" );

    refill();
    cfgChanged();
}

void ConfigEnvironmentPage::saveSettings()
{
    config->data.environment.directories.clear();
    for( uint i = 0; i < lDirectories->count(); i++ ) {
        config->data.environment.directories.append( lDirectories->text(i) );
    }

    config->binaries = *binaries;
}

void ConfigEnvironmentPage::directoriesSelectionChanged( int index )
{
    pRemoveDirectory->setEnabled( true );
    if( index != 0 ) pDirUp->setEnabled( true );
    else pDirUp->setEnabled( false );
    if( index != lDirectories->count() - 1 ) pDirDown->setEnabled( true );
    else pDirDown->setEnabled( false );
}

void ConfigEnvironmentPage::dirUp()
{
    int index = lDirectories->currentItem();
    if( index > 0 ) {
        TQString text = lDirectories->currentText();
        lDirectories->removeItem( index );
        lDirectories->insertItem( text, index - 1 );
        lDirectories->setSelected( index - 1, true );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::dirDown()
{
    int index = lDirectories->currentItem();
    if( (uint)index < lDirectories->count() - 1 ) {
        TQString text = lDirectories->currentText();
        lDirectories->removeItem( index );
        lDirectories->insertItem( text, index + 1 );
        lDirectories->setSelected( index + 1, true );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::addDirectory()
{
    TQString dirname = KFileDialog::getExistingDirectory( "/", 0 );
    if( dirname != NULL ) {
        lDirectories->insertItem( dirname );
        refill();
        cfgChanged();
    }
}

void ConfigEnvironmentPage::removeDirectory()
{
    lDirectories->removeItem( lDirectories->currentItem() );
    refill();
    cfgChanged();
}

void ConfigEnvironmentPage::refill()
{
    for( TQMap<TQString, TQString>::Iterator it = binaries->begin(); it != binaries->end(); ++it ) {
        it.data() = "";
        for( uint i = 0; i < lDirectories->count(); i++ ) {
            if( it.data() == "" && TQFile::exists(lDirectories->text(i) + "/" + it.key()) ) {
                it.data() = lDirectories->text(i) + "/" + it.key();
            }
        }
    }

    lFoundPrograms->clear();
    lNotFoundPrograms->clear();
    for( TQMap<TQString, TQString>::Iterator it = binaries->begin(); it != binaries->end(); ++it ) {
        if( it.data() != "" ) {
            lFoundPrograms->insertItem( it.data() );
        }
        else {
            lNotFoundPrograms->insertItem( it.key() );
        }
    }

    emit rebuildBackendsPage();
}

#include "configenvironmentpage.moc"
