/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef FILTER_H
#define FILTER_H

#include <tqwidget.h>
#include <tqmap.h>

#include "focusedwidgets.h"

class TQToolButton;

class Tag;
class State;

/** The structure that contain all filter terms
  * @author Sbastien Laot
  */
class FilterData
{
  public:
	// Useful Enum for tagFilterType:
	enum TagFilterType { DontCareTagsFilter = 0, NotTaggedFilter, TaggedFilter, TagFilter, StateFilter };
	// Constructor and Destructor:
	FilterData()  { isFiltering = false; tagFilterType = DontCareTagsFilter; tag = 0; state = 0; }
	~FilterData() {}
	// Filter data:
	TQString  string;
	int      tagFilterType;
	Tag     *tag;
	State   *state;
	bool     isFiltering;
};

/** A TQWidget that allow user to enter terms to filter in a Basket.
  * @author Sbastien Laot
  */
class FilterBar : public TQWidget
{
  TQ_OBJECT
  
  public:
	FilterBar(TQWidget *parent = 0, const char *name = 0);
	~FilterBar();
	const FilterData& filterData();
  signals:
	void newFilter(const FilterData &data);
	void escapePressed();
	void returnPressed();
  public slots:
	void repopulateTagsComnbo();
	void reset();
	void inAllBaskets();
	void setEditFocus();
	void filterTag(Tag *tag);
	void filterState(State *state);
	void setFilterAll(bool filterAll);
	void setFilterData(const FilterData &data);
  public:
	bool hasEditFocus();
	KLineEdit* lineEdit() { return m_lineEdit; }
  private slots:
	void textChanged(const TQString &text);
	void tagChanged(int index);
  private:
	FilterData      *m_data;
	FocusedLineEdit *m_lineEdit;
	TQToolButton     *m_resetButton;
	FocusedComboBox *m_tagsBox;
	TQToolButton     *m_inAllBasketsButton;

	TQMap<int, Tag*>   m_tagsMap;
	TQMap<int, State*> m_statesMap;
};

#endif // FILTER_H
