/***************************************************************************
*   (c) 2015 Timothy Pearson <kb9vqf@pearsoncomputing.net>                *
*   Copyright (C) 2004 by Hugo Parente Lima                               *
*   hugo_pl@users.sourceforge.net                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.          *
***************************************************************************/
#ifndef STATISTICS_H
#define STATISTICS_H

#include "statisticsbase.h"
#include <tqstring.h>

class KNetStatsView;

class Statistics : public StatisticsBase
{
	TQ_OBJECT


public:
	Statistics(KNetStatsView* parent = 0, const char *name = 0);

	/**
	*	Formats a numberic byte representation
	*	\param	num		The numeric representation
	*	\param	decimal		Decimal digits
	*	\param	ksuffix		Suffix for kilobytes
	*	\param	msuffix		Suffix for megabytes
	*	\param	gsuffix		Suffix for gigabytes
	*	\param	tsuffix		Suffix for terabytes
	*/
	static inline TQString byteFormat(double num, const char* ksuffix = " KB", const char* msuffix = " MB", const char* gsuffix = " GB", const char* tsuffix = " TB");

	void show();
private:
	TQTimer* mTimer;
	const TQString& mInterface;
	KNetStatsView* mParent;
public slots:
	void accept();

private slots:
	void update();
};

TQString Statistics::byteFormat(double num, const char* ksuffix, const char* msuffix, const char* gsuffix, const char* tsuffix) {
	const double ONE_KB = 1024.0;
	const double ONE_MB = ONE_KB*ONE_KB;
	const double ONE_GB = ONE_KB*ONE_KB*ONE_KB;
	const double ONE_TB = ONE_KB*ONE_KB*ONE_KB*ONE_KB;
	if ( num >= ONE_TB ) {		// TB
		return TQString::number(num/(ONE_TB), 'f', 1) + tsuffix;
	}
	else if ( num >= ONE_GB ) {	// GB
		return TQString::number(num/(ONE_GB), 'f', 1) + gsuffix;
	}
	else if ( num >= ONE_MB ) {	// MB
		return TQString::number(num/(ONE_MB), 'f', 1) + msuffix;
	}
	else {				// KB
		return TQString::number(num/(ONE_KB), 'f', 1) + ksuffix;
	}
}

#endif
