/***************************************************************************
                          sq_dirthumbs.cpp  -  description
                             -------------------
    begin                : ??? Jul 18 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_UTIME_H
#include <sys/types.h>
#include <utime.h>
#endif

#include <tqimage.h>
#include <tqfileinfo.h>
#include <tqdatetime.h>

#include <kurl.h>
#include <kmdcodec.h>

#include "sq_dirthumbs.h"
#include "sq_thumbnailinfo.h"

SQ_DirThumbs::SQ_DirThumbs() : SQ_Dir()
{
    setRoot();
}

SQ_DirThumbs::~SQ_DirThumbs()
{}

/*
 *  Save thumbnail to storage.
 */
void SQ_DirThumbs::saveThumbnail(const KURL &url, SQ_Thumbnail &thumb)
{
    TQString ab = absPath(url);

    if(!thumb.thumbnail.isNull() && needUpdate(ab, thumb.originalTime))
    {
        // thumbnail standard tags
        thumb.thumbnail.setText("Thumb::Image::Width", 0, TQString::number(thumb.w));
        thumb.thumbnail.setText("Thumb::Image::Height", 0, TQString::number(thumb.h));
        thumb.thumbnail.setText("Thumb::URI", 0, url.prettyURL());
        thumb.thumbnail.setText("Thumb::MTime", 0, TQString::number(thumb.originalTime));
        thumb.thumbnail.setText("Software", 0, "KSquirrel");

        thumb.thumbnail.save(ab, sqdirThumbFormat, sqdirThumbQuality);

#ifdef HAVE_UTIME_H
        struct utimbuf ut;
        ut.actime = thumb.originalTime;
        ut.modtime = thumb.originalTime;
        utime((const char *)ab.local8Bit(), &ut);
#endif
    }
}

TQString SQ_DirThumbs::absPath(const KURL &relurl)
{
    KMD5 md5(TQString(TQFile::encodeName(relurl.prettyURL())).local8Bit());

    TQString ext = TQString::fromLatin1(".%1").arg(sqdirThumbFormat);

    return m_orig + TQDir::separator() + TQString(md5.hexDigest()) + ext.lower();
}

void SQ_DirThumbs::setRoot()
{
    m_orig = TQDir::cleanDirPath(homeDirPath() + TQDir::separator() + TQString::fromLatin1(".thumbnails"));
    TQDir::mkdir(m_orig);

    m_orig = TQDir::cleanDirPath(m_orig + TQDir::separator() + TQString::fromLatin1("normal"));
    TQDir::mkdir(m_orig);
}

void SQ_DirThumbs::removeFile(const KURL &url)
{
    // determine absolute path and remove file
    TQFile::remove(absPath(url));
}

bool SQ_DirThumbs::needUpdate(const TQString &turl, time_t tm)
{
    TQFileInfo fthumbpath(turl);

    TQDateTime dt_orig;
    dt_orig.setTime_t(tm);

    return (dt_orig > fthumbpath.lastModified());
}
