// Author: Mark Kretschmann (C) Copyright 2004
// Copyright: See COPYING file that comes with this distribution

#ifndef AMAROK_PLUGIN_H
#define AMAROK_PLUGIN_H

#include <config.h>
#include "amarok_export.h"

#define AMAROK_EXPORT_PLUGIN( classname ) \
    extern "C" { \
          TDE_EXPORT Amarok::Plugin* create_plugin() { return new classname; } \
    }

#include <tqmap.h>
#include <tqstring.h>

class TQWidget;

namespace Amarok
{
    class PluginConfig;

    class LIBAMAROK_EXPORT Plugin
    {
        public:
            virtual ~Plugin();

            /**
             * TODO @param parent you must parent the widget to parent
             * @return the configure widget for your plugin, create it on the heap!
             */
             //TODO rename configureWidget( TQWidget *parent )
            virtual PluginConfig* configure() const { return 0; }

            void addPluginProperty( const TQString& key, const TQString& value );
            TQString pluginProperty( const TQString& key );
            bool hasPluginProperty( const TQString& key );

        protected:
            Plugin();

        private:
            TQMap<TQString, TQString> m_properties;
    };

} //namespace Amarok


#endif /* AMAROK_PLUGIN_H */


