/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#ifndef TCONTEXTLISTENER_H
#define TCONTEXTLISTENER_H

#include "eventnumbers.h"

#include "ccontextlistener.h"

#include <tqevent.h>
#include <tqmutex.h>
#include <tqwaitcondition.h>

class ThreadContextListenerData;

/**
@author Rajko Albrecht
*/
class ThreadContextListener : public CContextListener
{
    TQ_OBJECT
  
public:
    ThreadContextListener(TQObject* parent, const char* name=0);

    virtual ~ThreadContextListener();

    virtual bool contextGetLogin(const TQString& realm, TQString& username, TQString& password, bool& maySave);
    virtual bool contextGetSavedLogin(const TQString & realm,TQString & username,TQString & password);

    virtual bool contextGetLogMessage(TQString& msg,const svn::CommitItemList&);
    virtual bool contextSslClientCertPrompt(TQString& certFile);
    virtual bool contextSslClientCertPwPrompt(TQString& password, const TQString& realm, bool& maySave);
    virtual svn::ContextListener::SslServerTrustAnswer contextSslServerTrustPrompt(const SslServerTrustData& data, apr_uint32_t& acceptedFailures);
    virtual void contextNotify(const TQString&aMsg);
    virtual void sendTick();
    virtual void contextProgress(long long int current, long long int max);

    static TQMutex*callbackMutex();

protected:
    virtual void event_contextGetLogin(void*_data);
    virtual void event_contextGetSavedLogin(void*_data);
    virtual void event_contextGetLogMessage(void*data);
    virtual void event_contextSslClientCertPrompt(void*data);
    virtual void event_contextSslClientCertPwPrompt(void*data);
    virtual void event_contextSslServerTrustPrompt(void* data);
    virtual void event_contextNotify(void*data);
    virtual void customEvent(TQCustomEvent*);

    /* stores all internals */
    TQMutex m_WaitMutex;
    ThreadContextListenerData*m_Data;
};

#endif
