/*
 * Port for usage with tqt-framework and development for tdesvn
 * (C) 2005-2007 by Rajko Albrecht
 * http://tdesvn.alwins-world.de
 */
/*
 * ====================================================================
 * Copyright (c) 2002-2005 The RapidSvn Group.  All rights reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library (in the file LGPL.txt); if not,
 * write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA  02110-1301  USA
 *
 * This software consists of voluntary contributions made by many
 * individuals.  For exact contribution history, see the revision
 * history and logs, available at http://rapidsvn.tigris.org/.
 * ====================================================================
 */

#ifndef _SVNCPP_LOCK_ENTRY_H_
#define _SVNCPP_LOCK_ENTRY_H_

#include "svnqt/svnqt_defines.h"
#include "svnqt/datetime.h"

#include <tqstring.h>

// apr
#include "apr_time.h"

// subversion api
#include "svn_types.h"
#include "svn_wc.h"

namespace svn
{
  class SVNTQT_EXPORT LockEntry
  {
  public:
    LockEntry ();

    LockEntry (const apr_time_t lock_time,
              const apr_time_t expiration_time,
              const char * lock_owner,
              const char * lock_comment,
              const char * lock_token);

    void init(const svn_wc_entry_t * src);

    void init(const apr_time_t lock_time,
              const apr_time_t expiration_time,
              const char * lock_owner,
              const char * lock_comment,
              const char * lock_token);
    void init(const svn_lock_t*);
    const TQString&Comment()const;
    const TQString&Owner()const;
    const TQString&Token()const;
    const DateTime&Date()const;
    const DateTime&Expiration()const;
    bool Locked()const;

  protected:
    DateTime date;
    DateTime exp;
    TQString owner;
    TQString comment;
    TQString token;
    bool locked;
  };
}

#endif
