# xdg-desktop-portal-tde

## What is this?

This is an implementation of the [FreeDesktop Portals API](https://flatpak.github.io/xdg-desktop-portal).

This implementation exposes TDE APIs to applications which use the Portals API. As a result, these applications
can transparently use native APIs and dialogs.

Read more about the portals API on its official [website](https://flatpak.github.io/xdg-desktop-portal/docs/introduction.html).

## How do I use this?
Before using this, make sure you have the `xdg-desktop-portal` package installed and running on your system.

- **GTK+3/4 applications**: environment variables `GDK_DEBUG=portals` or `GTK_USE_PORTAL=1`;
- **Chromium-based browsers**: see GTK+ applications
- **Mozilla Firefox**: In about:config set `widget.use-xdg-desktop-portal.file-picker` to 1 (also check out any options that start with widget.use-xdg-desktop-portal.* to enable more portals).
- **Pale Moon**: [https://forum.palemoon.org/viewtopic.php?t=22985]
- **Qt applications**: unknown

**WARNING!** Some Gtk+ applications don't respect the `GTK_USE_PORTAL=1` and `GDK_DEBUG=portals` environment variables (e.g. Inkscape).

## State of the implementation

Currently implemented are the following interfaces (listed in alphabetical order):
* Account - request user information (user ID, full name, user icon)
* Email - request to send an e-mail via the system e-mail client
* FileChooser - request a file dialog

The following implementations are considered (listed in alphabetical order):
* Access - show a grant access dialog
* App Chooser - show a "Open with..." dialog for a file
* Clipboard - request clipboard access (*)
* Notification - show a notification
* Print - request a file to be printed
* Screenshot - request a screenshot
* Secret - integration with TDEWallet
* Wallpaper - request to change the user's wallpaper

(*) Needs Session interface implementation

Additionally, it must be noted that the implementation does not currently support the Documents portal API (and therefore sandboxed applications).
