/***************************************************************************
    copyright            : (C) 2007 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "referencerimporter.h"
#include "../collection.h"
#include "../core/netaccess.h"
#include "../imagefactory.h"

#include <kstandarddirs.h>

using Tellico::Import::ReferencerImporter;

ReferencerImporter::ReferencerImporter(const KURL& url_) : XSLTImporter(url_) {
  TQString xsltFile = locate("appdata", TQString::fromLatin1("referencer2tellico.xsl"));
  if(!xsltFile.isEmpty()) {
    KURL u;
    u.setPath(xsltFile);
    XSLTImporter::setXSLTURL(u);
  } else {
    kdWarning() << "ReferencerImporter() - unable to find referencer2tellico.xml!" << endl;
  }
}

bool ReferencerImporter::canImport(int type) const {
  return type == Data::Collection::Bibtex;
}

Tellico::Data::CollPtr ReferencerImporter::collection() {
  Data::CollPtr coll = XSLTImporter::collection();
  if(!coll) {
    return 0;
  }

  Data::FieldPtr field = coll->fieldByName(TQString::fromLatin1("cover"));
  if(!field && !coll->imageFields().isEmpty()) {
    field = coll->imageFields().front();
  } else if(!field) {
    field = new Data::Field(TQString::fromLatin1("cover"), i18n("Front Cover"), Data::Field::Image);
    coll->addField(field);
  }

  Data::EntryVec entries = coll->entries();
  for(Data::EntryVecIt entry = entries.begin(); entry != entries.end(); ++entry) {
    TQString url = entry->field(TQString::fromLatin1("url"));
    if(url.isEmpty()) {
      continue;
    }
    TQPixmap pix = NetAccess::filePreview(url);
    if(pix.isNull()) {
      continue;
    }
    TQString id = ImageFactory::addImage(pix, TQString::fromLatin1("PNG"));
    if(id.isEmpty()) {
      continue;
    }
    entry->setField(field, id);
  }
  return coll;
}

#include "referencerimporter.moc"
