/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KWFootNoteDia.h"
#include "KWFootNoteDia.moc"

#include <tqbuttongroup.h>
#include <tqvbox.h>
#include <tqradiobutton.h>

#include <tdelocale.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include "KWConfigFootNoteDia.h"


/******************************************************************/
/* Class: KWFootNoteDia                                           */
/******************************************************************/

KWFootNoteDia::KWFootNoteDia( NoteType _noteType, KWFootNoteVariable::Numbering _numberingType, const TQString & _manualString, TQWidget *parent, KWDocument *_doc, const char *name )
    : KDialogBase( parent, name, true, TQString(), Ok|Cancel|User1, Ok, true )
{
    m_doc =_doc;
    //setButtonOKText(i18n("&Insert"));

    setCaption( i18n("Insert Footnote/Endnote") );

    TQVBox *page = makeVBoxMainWidget();

    TQButtonGroup *grp = new TQButtonGroup( i18n("Numbering"), page );
    TQGridLayout *grid = new TQGridLayout( grp, 9, 4, KDialog::marginHint(), KDialog::spacingHint());
    m_rbAuto = new TQRadioButton( i18n("&Automatic"), grp );
    m_rbManual= new TQRadioButton( i18n("&Manual"), grp );

    grp->setExclusive( true );
    int fHeight = grp->fontMetrics().height();
    grid->addRowSpacing( 0, fHeight/2 ); // groupbox title
    grid->addWidget( m_rbAuto, 1, 0);
    grid->addWidget( m_rbManual, 2, 0);
    if ( _numberingType == KWFootNoteVariable::Auto )
        m_rbAuto->setChecked( true );
    else
        m_rbManual->setChecked( true );
    m_footLine = new TQLineEdit( grp);
    m_footLine->setText( _manualString );
    connect( m_footLine, TQ_SIGNAL( textChanged ( const TQString & )), this, TQ_SLOT(footLineChanged( const TQString & )));
    connect( grp, TQ_SIGNAL( clicked ( int ) ), this, TQ_SLOT(footNoteTypeChanged()));
    grid->addWidget( m_footLine, 2, 1);


    grp = new TQButtonGroup( 4, TQt::Vertical, page );
    m_rbFootNote = new TQRadioButton( i18n("&Footnote"), grp );
    m_rbEndNote = new TQRadioButton( i18n("&Endnote"), grp );

    grp->setExclusive( true );
    grp->insert( m_rbFootNote );
    grp->insert( m_rbEndNote );
    if (_noteType == FootNote )
        m_rbFootNote->setChecked( true );
    else
        m_rbEndNote->setChecked( true );

    footNoteTypeChanged();
    setButtonText( KDialogBase::User1, i18n("C&onfigure...") );
    connect( this, TQ_SIGNAL( user1Clicked() ), this, TQ_SLOT(slotConfigurate()));
}

void KWFootNoteDia::footNoteTypeChanged()
{
    if ( m_rbManual->isChecked())
    {
        enableButtonOK( !m_footLine->text().isEmpty() );
        m_footLine->setFocus();
    }
    else
    {
        enableButtonOK(true);
        setFocus();
    }
}

void KWFootNoteDia::footLineChanged( const TQString &text )
{
    m_rbManual->setChecked( true );
    if ( text.isEmpty() || footNoteAlreadyExists(text) )
        enableButtonOK( false );
    else
        enableButtonOK( true );
}

NoteType KWFootNoteDia::noteType() const
{
    return m_rbFootNote->isChecked() ? FootNote : EndNote;
}

KWFootNoteVariable::Numbering KWFootNoteDia::numberingType()const
{
    return m_rbAuto->isChecked() ? KWFootNoteVariable::Auto : KWFootNoteVariable::Manual;
}

TQString KWFootNoteDia::manualString()const
{
    return  m_rbAuto->isChecked() ? TQString() : m_footLine->text();
}

void KWFootNoteDia::slotConfigurate()
{
    KWConfigFootNoteDia *dia = new KWConfigFootNoteDia( this, "configfootnote", m_doc );
    dia->exec();
    delete dia;
}

bool KWFootNoteDia::footNoteAlreadyExists( const TQString & text )
{
    return manualFootNotes.contains( text );
}

void KWFootNoteDia::appendManualFootNote( const TQString & text )
{
    manualFootNotes.append( text );
}
