/***************************************************************************
 *   Copyright (C) 2006 by Peter Penz                                      *
 *   peter.penz@gmx.at                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef STATUSBARMESSAGELABEL_H
#define STATUSBARMESSAGELABEL_H

#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqstring.h>
#include <dolphinstatusbar.h>
class TQTimer;

/**
 * @brief Represents a message text label as part of the status bar.
 *
 * Dependant from the given type automatically a corresponding icon
 * is shown in front of the text. For message texts having the type
 * DolphinStatusBar::Error a dynamic color blending is done to get the
 * attention from the user.
 *
 * @author Peter Penz
 */
class StatusBarMessageLabel : public TQWidget
{
    TQ_OBJECT
  

public:
    StatusBarMessageLabel(TQWidget* parent);
    virtual ~StatusBarMessageLabel();

    void setType(DolphinStatusBar::Type type);
    DolphinStatusBar::Type type() const { return m_type; }

    void setText(const TQString& text);
    const TQString& text() const { return m_text; }

    // TODO: maybe a better approach is possible with the size hint
    void setMinimumTextHeight(int min);
    int minimumTextHeight() const { return m_minTextHeight; }

protected:
    /** @see TQWidget::paintEvent */
    virtual void paintEvent(TQPaintEvent* event);

    /** @see TQWidget::resizeEvent */
    virtual void resizeEvent(TQResizeEvent* event);

private slots:
    void timerDone();
    void assureVisibleText();

private:
    enum State {
        Default,
        Illuminate,
        Illuminated,
        Desaturate
    };

    DolphinStatusBar::Type m_type;
    State m_state;
    int m_illumination;
    int m_minTextHeight;
    TQTimer* m_timer;
    TQString m_text;
    TQPixmap m_pixmap;

    TQColor mixColors(const TQColor& c1,
                     const TQColor& c2,
                     int percent) const;

    int pixmapGap() const { return 3; }
};

#endif
