/***************************************************************************
*   Copyright (C) 2004-2006 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef KBIBTEXWEBQUERYPUBMED_H
#define KBIBTEXWEBQUERYPUBMED_H

#include <tqwidget.h>
#include <tqxml.h>
#include <tqvaluelist.h>

#include "webquery.h"

class TQStringList;
class TQDomElement;
class TQDate;

namespace KBibTeX
{
    /**
     @author Thomas Fischer <fischer@unix-ag.uni-kl.de>
    */
    class WebQueryPubMedWidget : public WebQueryWidget
    {
        TQ_OBJECT
    public:
        WebQueryPubMedWidget( TQWidget *parent, const char *name = 0 );
    };

    class WebQueryPubMedStructureParserQuery : public TQXmlDefaultHandler
    {
    public:
        WebQueryPubMedStructureParserQuery( TQValueList<int> *intList );
        ~WebQueryPubMedStructureParserQuery( );

        bool startElement( const TQString&, const TQString&, const TQString&, const TQXmlAttributes& );
        bool endElement( const TQString&, const TQString&, const TQString& );
        bool characters( const TQString & ch );

    private:
        TQValueList<int> *m_intList;
        TQString concatString;
    };

    class WebQueryPubMedResultParser: public TQObject
    {
        TQ_OBJECT
    public:
        WebQueryPubMedResultParser();
        ~WebQueryPubMedResultParser();

        void parse( const TQDomElement& rootElement );

    signals:
        void foundEntry( BibTeX::Entry*, bool );

    private:
        void parsePubmedArticle( const TQDomElement& element, BibTeX::Entry *entry );
        void parseMedlineCitation( const TQDomElement& element, BibTeX::Entry *entry );
        void parseArticle( const TQDomElement& element, BibTeX::Entry *entry );
        void parseJournal( const TQDomElement& element, BibTeX::Entry *entry );
        void parseJournalIssue( const TQDomElement& element, BibTeX::Entry *entry );
        void parsePubDate( const TQDomElement& element, BibTeX::Entry *entry );
        void parseAuthorList( const TQDomElement& element, BibTeX::Entry *entry );
    };

    class WebQueryPubMed : public WebQuery
    {
        TQ_OBJECT
    public:
        WebQueryPubMed( TQWidget *parent );
        virtual ~WebQueryPubMed();

        void query();

        TQString title();
        TQString disclaimer();
        TQString disclaimerURL();

        WebQueryWidget *widget();

    protected:
        void cancelQuery() { /* nothing */ };

    private:
        WebQueryPubMedWidget *m_widget;
    };

}

#endif
