#include <tdeapplication.h>
#include <kstandarddirs.h>

#include <tdeconfig.h>
#include <tdelocale.h>
#include <tdeaccel.h>
#include <tqpushbutton.h>
#include <tqlabel.h>
#include <tqframe.h>
#include <tqkeycode.h>
#include <tqpixmap.h>
#include <tqstring.h>

#include "keys.h"

PKeys::PKeys( TQWidget *parent, const char *name)
    : TQDialog( parent, name, true, 0 )
{
    TDEStandardDirs *dirs = TDEGlobal::dirs();

    TQPushButton *okButton  = new TQPushButton(this);
    okButton->setText(i18n("Ok"));
    okButton->setFixedSize(okButton->size());
    connect( okButton, TQ_SIGNAL(clicked()),this, TQ_SLOT(ok()) );
    okButton->move(20,210);

    TQPushButton *defaultButton  = new TQPushButton(this);
    defaultButton->setText(i18n("Defaults"));
    defaultButton->setFixedSize(defaultButton->size());
    connect( defaultButton, TQ_SIGNAL(clicked()),this, TQ_SLOT(defaults()) );
    defaultButton->move(140,210);

    TQPushButton *cancelButton  = new TQPushButton(this);
    cancelButton->setText(i18n("Cancel"));
    cancelButton->setFixedSize(cancelButton->size());
    connect( cancelButton, TQ_SIGNAL(clicked()),this, TQ_SLOT(reject()) );
    cancelButton->move(260,210);

    TQFrame *separator = new TQFrame(this);
    separator->setFrameStyle( TQFrame::HLine | TQFrame::Sunken );
    separator->setGeometry( 20, 190, 340, 4 );

    for ( int x = 0; x < 4; x++) {
            TQLabel *l = new TQLabel(this);
            l->setAlignment(AlignCenter);
            labels[x] = l;
    }

    labels[0]->setGeometry(120, 20, 140, 20 );
    labels[1]->setGeometry(120,160, 140, 20 );
    labels[2]->setGeometry( 20, 92, 100, 20 );
    labels[3]->setGeometry(265, 92, 100, 20 );

    TQString pixPath;

    TQPushButton *up = new TQPushButton(this);
    pixPath = dirs->findResource("appdata", "pics/up.xpm");
    up->setPixmap( TQPixmap(pixPath));
    up->setFixedSize(up->pixmap()->size());
    connect( up, TQ_SIGNAL(clicked()),this, TQ_SLOT(butUp()) );
    up->move(180, 50);

    TQPushButton *down = new TQPushButton(this);
    pixPath = dirs->findResource("appdata", "pics/down.xpm");
    down->setPixmap( TQPixmap(pixPath));
    down->setFixedSize(down->pixmap()->size());
    connect( down, TQ_SIGNAL(clicked()),this, TQ_SLOT(butDown()) );
    down->move(180, 130);

    TQPushButton *left = new TQPushButton(this);
    pixPath = dirs->findResource("appdata", "pics/left.xpm");
    left->setPixmap( TQPixmap(pixPath));
    left->setFixedSize(left->pixmap()->size());
    connect( left, TQ_SIGNAL(clicked()),this, TQ_SLOT(butLeft()) );
    left->move(140, 90);

    TQPushButton *right = new TQPushButton(this);
    pixPath = dirs->findResource("appdata", "pics/right.xpm");
    right->setPixmap( TQPixmap(pixPath));
    right->setFixedSize(right->pixmap()->size());
    connect( right, TQ_SIGNAL(clicked()),this, TQ_SLOT(butRight()) );
    right->move(220, 90);


    setCaption(i18n("Change Direction Keys"));
    setFixedSize(380, 260);
    lab = 0;
    init();
}

void PKeys::keyPressEvent( TQKeyEvent *e )
{
        uint kCode = e->key() & ~(SHIFT | CTRL | ALT);
        TQString string = TDEAccel::keyToString(kCode);

        if (lab != 0) {
            if ( string.isNull() )
                    lab->setText(i18n("Undefined key"));
            else
                lab->setText(string);
        }
        else if ( lab == 0 && e->key() == Key_Escape)
            reject();
}

void PKeys::butUp()
{
    getKey(0);
}

void PKeys::butDown()
{
    getKey(1);
}

void PKeys::butLeft()
{
    getKey(2);
}

void PKeys::butRight()
{
    getKey(3);
}

void PKeys::getKey(int i)
{
    if ( lab != 0)
            focusOut(lab);

    focusIn(labels[i]);
}

void PKeys::focusOut(TQLabel *l)
{
    l->setFrameStyle( TQFrame::NoFrame );
    l->setBackgroundColor(backgroundColor());
    l->repaint();
}

void PKeys::focusIn(TQLabel *l)
{
    lab = l;
    lab->setFrameStyle( TQFrame::Panel | TQFrame::Sunken );
    lab->setBackgroundColor(white);
    lab->repaint();
}

void PKeys::defaults()
{
    if ( lab != 0)
            focusOut(lab);

    lab = 0;

    labels[0]->setText("Up");
    labels[1]->setText("Down");
    labels[2]->setText("Left");
    labels[3]->setText("Right");
}

void PKeys::init()
{
    TQString up("Up");
    up = kapp->config()->readEntry("upKey", up);
    labels[0]->setText(up);

    TQString down("Down");
    down = kapp->config()->readEntry("downKey", down);
    labels[1]->setText(down);

    TQString left("Left");
    left = kapp->config()->readEntry("leftKey", left);
    labels[2]->setText(left);

    TQString right("Right");
    right = kapp->config()->readEntry("rightKey", right);
    labels[3]->setText(right);
}

void PKeys::ok()
{
    kapp->config()->writeEntry("upKey",    labels[0]->text() );
    kapp->config()->writeEntry("downKey",  labels[1]->text() );
    kapp->config()->writeEntry("leftKey",  labels[2]->text() );
    kapp->config()->writeEntry("rightKey", labels[3]->text() );
    kapp->config()->sync();

    accept();
}

#include "keys.moc"
