/***************************************************************************
                          tdepacmanview.cpp  -  description
                             -------------------
    begin                : Sam Jan 19 13:37:57 CET 2002
    copyright            : (C) 1998-2003 by Jörg Thönnissen
    email                : joe@dsite.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for TQt
#include <tqmessagebox.h>

// include files for TDE
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kstandarddirs.h>

// application specific includes
#include "tdepacmanview.h"
#include "bitfont.h"
#include "score.h"
#include "referee.h"
#include "status.h"

TDEpacmanView::TDEpacmanView( TQWidget *parent, const char *name) : TQWidget( parent, name )
{
    bitfont = NULL;
    fontName = "";

    scheme = mode = -1;
    confScheme();

    score = new Score(this, name, scheme, mode, bitfont);
    referee = new Referee( this, name, scheme, mode, bitfont);
    status = new Status(this, name, scheme, mode);

    setFixedSize(referee->width(), bitfont->height()*3 + referee->height() + status->height());
}

TDEpacmanView::~TDEpacmanView()
{
}

void TDEpacmanView::confMisc(bool defGroup)
{
    TDEStandardDirs *dirs = TDEGlobal::dirs();
    TQString findPath;

    if (defGroup || kapp->config()->hasKey("Font")) {
        fontName = kapp->config()->readEntry("Font");

        if (fontName.left(1) != "/" && fontName.left(1) != "~")
            fontName.insert(0, "fonts/");
        if (fontName.right(1) == "/")
            fontName.append("font.xbm");

        findPath = dirs->findResource("appdata", fontName);
        if (!findPath.isEmpty())
            fontName = findPath;

        bitfontFirstChar = kapp->config()->readNumEntry("FontFirstChar", 0x0e);
        bitfontLastChar = kapp->config()->readNumEntry("FontLastChar", 0x5f);
    }
}

void TDEpacmanView::confScheme()
{
    TQString lastFontName = fontName;
    TQString oldgroup = kapp->config()->group();
    TQString newgroup;

    // if not set, read mode and scheme from the configfile
    if (mode == -1 && scheme == -1) {           
        scheme = kapp->config()->readNumEntry("Scheme", -1);
        mode = kapp->config()->readNumEntry("Mode", -1);
        
        // if mode is not set in the defGroup-group, lookup the scheme group
        if (scheme != -1 || mode == -1) {
            newgroup.sprintf("Scheme %d", scheme);
            kapp->config()->setGroup(newgroup);

            mode = kapp->config()->readNumEntry("Mode", -1);
            kapp->config()->setGroup(oldgroup);
        }
    }

    confMisc();

    if (mode != -1) {
        newgroup.sprintf("Mode %d", mode);
        kapp->config()->setGroup(newgroup);     

        confMisc(false);
    }

    if (scheme != -1) {
        newgroup.sprintf("Scheme %d", scheme);
        kapp->config()->setGroup(newgroup);

        confMisc(false);
    }

    if (lastFontName != fontName) {

        if (bitfont != 0)
            delete bitfont;

        bitfont = new Bitfont(fontName, bitfontFirstChar, bitfontLastChar);
        if (bitfont->width() == 0 || bitfont->height() == 0) {
            TQString msg = i18n("The bitfont could not be contructed.\n\n"
                               "The file '@FONTNAME@' does not exist,\n"
                               "or is of an unknown format.");
            msg.replace(TQRegExp("@FONTNAME@"), fontName);
            // TQMessageBox::critical(this, i18n("Initialization Error"), msg);
            printf("%s\n", msg.local8Bit().data());
        }
    }

    kapp->config()->setGroup(oldgroup);
}

void TDEpacmanView::setScheme(int Scheme, int Mode)
{
    mode = Mode;
    scheme = Scheme;

    confScheme();

    score->setScheme(Scheme, Mode, bitfont);
    referee->setScheme(Scheme, Mode, bitfont);
    status->setScheme(Scheme, Mode);

    setFixedSize(referee->width(),
                 bitfont->height()*3 + referee->height() + status->height());
    updateGeometry();

    score->repaint(false);
    referee->repaint(false);
    status->repaint(false);
}

void TDEpacmanView::resizeEvent( TQResizeEvent * )
{
    referee->setGeometry(0, bitfont->height()*3, referee->width(), referee->height());
    referee->setBackgroundColor(BLACK);

    status->setGeometry(0, bitfont->height()*3+referee->height(), referee->width(),
                        status->height());
    status->setBackgroundColor(BLACK);

    score->setGeometry(0, 0, referee->width(), bitfont->height()*3+referee->height()+status->height());
    score->setBackgroundColor(BLACK);
}

#include "tdepacmanview.moc"
