#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>

#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqhbox.h>
#include <tqvgroupbox.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqspinbox.h>

#include "optiondialog.h"

ConfigureDialog::ConfigureDialog(TQWidget *parent, char *name, bool modal)
	: KDialogBase(KDialogBase::TreeList, i18n("Configure"), Apply | Ok | Cancel, Ok, parent, name, modal)
{
	setHelp("mathemagics/index.html", TQString::null);

	TQFrame *DisplayPage = addPage(i18n("Display"));
	TQVBoxLayout *dBox = new TQVBoxLayout(DisplayPage, marginHint(), spacingHint());

	TQVGroupBox *numBox = new TQVGroupBox(i18n("Numbers"), DisplayPage);
	dBox->addWidget(numBox);

	TQHBox *pBox = new TQHBox(numBox);
	pBox->setSpacing(spacingHint());
	NumBoxLabel = new TQLabel(i18n("Display precision:"), pBox);
	PrecNumBox = new TQSpinBox(1, 30, 3, pBox);

	FixedCheckBox = new TQCheckBox(i18n("&Fixed precision"), numBox);
	ShowPeriodCheckBox = new TQCheckBox(i18n("Always &show decimal point"), numBox);

	TQHBox *sBox = new TQHBox(DisplayPage);
	dBox->addWidget(sBox);
	sBox->setSpacing(spacingHint());
	NumBoxLabel = new TQLabel(i18n("Visible stack levels:"), sBox);
	NumLevelsNumBox = new TQSpinBox(1, 40, 1, sBox);

	BeepBox = new TQCheckBox(i18n("&Beep on error"), DisplayPage);
	dBox->addWidget(BeepBox);

	TQFrame *HistoryPage = addPage(i18n("History"));
	TQVBoxLayout *histBox = new TQVBoxLayout(HistoryPage, marginHint(), spacingHint());

	TQHBoxLayout *hBox = new TQHBoxLayout(histBox, spacingHint());

	HistDepthBox = new TQSpinBox(0, 40, 5, HistoryPage);
	HistoryLabel = new TQLabel(HistDepthBox, i18n("History &depth:"), HistoryPage);
	hBox->addWidget(HistoryLabel);
	hBox->addWidget(HistDepthBox);

	ClearHistoryButton = new TQPushButton(i18n("C&lear History"), HistoryPage);
	connect(ClearHistoryButton, TQ_SIGNAL(clicked()), this, TQ_SIGNAL(clearHistory()));
	histBox->addWidget(ClearHistoryButton);
	histBox->addStretch();

	HistDetailCheckBox = new TQCheckBox(i18n("Show &base and angle"), HistoryPage);
	histBox->addWidget(HistDetailCheckBox);


	TQFrame *StackPage = addPage(i18n("Stack"));
	TQVBoxLayout *stackBox = new TQVBoxLayout(StackPage, marginHint(), spacingHint());

	SaveStackCheckBox = new TQCheckBox(i18n("&Save stack on quit"), StackPage);
	stackBox->addWidget(SaveStackCheckBox);

	DelDrops = new TQCheckBox(i18n("&Backspace drops on line-entry"), StackPage);
	stackBox->addWidget(DelDrops);

	connect(this, TQ_SIGNAL(cancelClicked()), this, TQ_SLOT(readConfig()));

	readConfig();
}

ConfigureDialog::~ConfigureDialog()
{
}

void ConfigureDialog::readConfig()
{
	kapp->config()->setGroup("App");
	PrecNumBox->setValue(kapp->config()->readNumEntry("formatPrec", 8));
	NumLevelsNumBox->setValue(kapp->config()->readNumEntry("numStackLevels", 12));
	BeepBox->setChecked(kapp->config()->readBoolEntry("beep", true));
	HistDepthBox->setValue(kapp->config()->readNumEntry("histNum", 15));
	ShowPeriodCheckBox->setChecked(kapp->config()->readBoolEntry("showPeriod", false));
	FixedCheckBox->setChecked(kapp->config()->readBoolEntry("fixedPrec", false));
	SaveStackCheckBox->setChecked(kapp->config()->readBoolEntry("saveStack", true));
	DelDrops->setChecked(kapp->config()->readBoolEntry("delDrops", true));
	HistDetailCheckBox->setChecked(kapp->config()->readBoolEntry("histDetail", false));
}

void ConfigureDialog::writeConfig()
{
	kapp->config()->setGroup("App");
	kapp->config()->writeEntry("formatPrec", PrecNumBox->value());
	kapp->config()->writeEntry("numStackLevels", NumLevelsNumBox->value());
	kapp->config()->writeEntry("beep", BeepBox->isChecked());
	kapp->config()->writeEntry("histNum", HistDepthBox->value());
	kapp->config()->writeEntry("showPeriod", ShowPeriodCheckBox->isChecked());
	kapp->config()->writeEntry("fixedPrec", FixedCheckBox->isChecked());
	kapp->config()->writeEntry("saveStack", SaveStackCheckBox->isChecked());
	kapp->config()->writeEntry("delDrops", DelDrops->isChecked());
	kapp->config()->writeEntry("histDetail", HistDetailCheckBox->isChecked());
}

void ConfigureDialog::slotOk()
{
	slotApply();
	accept();
}

void ConfigureDialog::slotApply()
{
	writeConfig();
	emit valueChanged();
}

#include "optiondialog.moc"
